/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import java.io.Serializable;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.CheckDigitException;

public final class VerhoeffCheckDigit
implements CheckDigit,
Serializable {
    private static final long serialVersionUID = 4138993995483695178L;
    public static final CheckDigit VERHOEFF_CHECK_DIGIT = new VerhoeffCheckDigit();
    private static final int[][] D_TABLE;
    private static final int[][] P_TABLE;
    private static final int[] INV_TABLE;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[10];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[5] = 6;
        nArray2[6] = 7;
        nArray2[7] = 8;
        nArray2[8] = 9;
        nArray2[9] = 5;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray3[2] = 4;
        nArray3[4] = 1;
        nArray3[5] = 7;
        nArray3[6] = 8;
        nArray3[7] = 9;
        nArray3[8] = 5;
        nArray3[9] = 6;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[0] = 3;
        nArray4[1] = 4;
        nArray4[3] = 1;
        nArray4[4] = 2;
        nArray4[5] = 8;
        nArray4[6] = 9;
        nArray4[7] = 5;
        nArray4[8] = 6;
        nArray4[9] = 7;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[10];
        nArray5[0] = 4;
        nArray5[2] = 1;
        nArray5[3] = 2;
        nArray5[4] = 3;
        nArray5[5] = 9;
        nArray5[6] = 5;
        nArray5[7] = 6;
        nArray5[8] = 7;
        nArray5[9] = 8;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[10];
        nArray6[0] = 5;
        nArray6[1] = 9;
        nArray6[2] = 8;
        nArray6[3] = 7;
        nArray6[4] = 6;
        nArray6[6] = 4;
        nArray6[7] = 3;
        nArray6[8] = 2;
        nArray6[9] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[10];
        nArray7[0] = 6;
        nArray7[1] = 5;
        nArray7[2] = 9;
        nArray7[3] = 8;
        nArray7[4] = 7;
        nArray7[5] = 1;
        nArray7[7] = 4;
        nArray7[8] = 3;
        nArray7[9] = 2;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[10];
        nArray8[0] = 7;
        nArray8[1] = 6;
        nArray8[2] = 5;
        nArray8[3] = 9;
        nArray8[4] = 8;
        nArray8[5] = 2;
        nArray8[6] = 1;
        nArray8[8] = 4;
        nArray8[9] = 3;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[0] = 8;
        nArray9[1] = 7;
        nArray9[2] = 6;
        nArray9[3] = 5;
        nArray9[4] = 9;
        nArray9[5] = 3;
        nArray9[6] = 2;
        nArray9[7] = 1;
        nArray9[9] = 4;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[10];
        nArray10[0] = 9;
        nArray10[1] = 8;
        nArray10[2] = 7;
        nArray10[3] = 6;
        nArray10[4] = 5;
        nArray10[5] = 4;
        nArray10[6] = 3;
        nArray10[7] = 2;
        nArray10[8] = 1;
        nArrayArray[9] = nArray10;
        D_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        int[] nArray11 = new int[10];
        nArray11[1] = 1;
        nArray11[2] = 2;
        nArray11[3] = 3;
        nArray11[4] = 4;
        nArray11[5] = 5;
        nArray11[6] = 6;
        nArray11[7] = 7;
        nArray11[8] = 8;
        nArray11[9] = 9;
        nArrayArray2[0] = nArray11;
        int[] nArray12 = new int[10];
        nArray12[0] = 1;
        nArray12[1] = 5;
        nArray12[2] = 7;
        nArray12[3] = 6;
        nArray12[4] = 2;
        nArray12[5] = 8;
        nArray12[6] = 3;
        nArray12[8] = 9;
        nArray12[9] = 4;
        nArrayArray2[1] = nArray12;
        int[] nArray13 = new int[10];
        nArray13[0] = 5;
        nArray13[1] = 8;
        nArray13[3] = 3;
        nArray13[4] = 7;
        nArray13[5] = 9;
        nArray13[6] = 6;
        nArray13[7] = 1;
        nArray13[8] = 4;
        nArray13[9] = 2;
        nArrayArray2[2] = nArray13;
        int[] nArray14 = new int[10];
        nArray14[0] = 8;
        nArray14[1] = 9;
        nArray14[2] = 1;
        nArray14[3] = 6;
        nArray14[5] = 4;
        nArray14[6] = 3;
        nArray14[7] = 5;
        nArray14[8] = 2;
        nArray14[9] = 7;
        nArrayArray2[3] = nArray14;
        int[] nArray15 = new int[10];
        nArray15[0] = 9;
        nArray15[1] = 4;
        nArray15[2] = 5;
        nArray15[3] = 3;
        nArray15[4] = 1;
        nArray15[5] = 2;
        nArray15[6] = 6;
        nArray15[7] = 8;
        nArray15[8] = 7;
        nArrayArray2[4] = nArray15;
        int[] nArray16 = new int[10];
        nArray16[0] = 4;
        nArray16[1] = 2;
        nArray16[2] = 8;
        nArray16[3] = 6;
        nArray16[4] = 5;
        nArray16[5] = 7;
        nArray16[6] = 3;
        nArray16[7] = 9;
        nArray16[9] = 1;
        nArrayArray2[5] = nArray16;
        int[] nArray17 = new int[10];
        nArray17[0] = 2;
        nArray17[1] = 7;
        nArray17[2] = 9;
        nArray17[3] = 3;
        nArray17[4] = 8;
        nArray17[6] = 6;
        nArray17[7] = 4;
        nArray17[8] = 1;
        nArray17[9] = 5;
        nArrayArray2[6] = nArray17;
        int[] nArray18 = new int[10];
        nArray18[0] = 7;
        nArray18[2] = 4;
        nArray18[3] = 6;
        nArray18[4] = 9;
        nArray18[5] = 1;
        nArray18[6] = 3;
        nArray18[7] = 2;
        nArray18[8] = 5;
        nArray18[9] = 8;
        nArrayArray2[7] = nArray18;
        P_TABLE = nArrayArray2;
        int[] nArray19 = new int[10];
        nArray19[1] = 4;
        nArray19[2] = 3;
        nArray19[3] = 2;
        nArray19[4] = 1;
        nArray19[5] = 5;
        nArray19[6] = 6;
        nArray19[7] = 7;
        nArray19[8] = 8;
        nArray19[9] = 9;
        INV_TABLE = nArray19;
    }

    @Override
    public boolean isValid(String code) {
        if (code == null || code.length() == 0) {
            return false;
        }
        try {
            return this.calculateChecksum(code, true) == 0;
        }
        catch (CheckDigitException checkDigitException) {
            return false;
        }
    }

    @Override
    public String calculate(String code) throws CheckDigitException {
        if (code == null || code.length() == 0) {
            throw new CheckDigitException("Code is missing");
        }
        int checksum = this.calculateChecksum(code, false);
        return Integer.toString(INV_TABLE[checksum]);
    }

    private int calculateChecksum(String code, boolean includesCheckDigit) throws CheckDigitException {
        int checksum = 0;
        int i = 0;
        while (i < code.length()) {
            int idx = code.length() - (i + 1);
            int num = Character.getNumericValue(code.charAt(idx));
            if (num < 0 || num > 9) {
                throw new CheckDigitException("Invalid Character[" + i + "] = '" + code.charAt(idx) + "'");
            }
            int pos = includesCheckDigit ? i : i + 1;
            checksum = D_TABLE[checksum][P_TABLE[pos % 8][num]];
            ++i;
        }
        return checksum;
    }
}

