/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

public class HttpURLConnectionManager
extends HttpManager {
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private final URL url;
    private final boolean isHttps;
    private final String method;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Property[] headers;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    public HttpURLConnectionManager(Configuration configuration, LoggerContext loggerContext, String name, URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, Property[] headers, SslConfiguration sslConfiguration, boolean verifyHostname) {
        super(configuration, loggerContext, name);
        this.url = url;
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        this.isHttps = this.url.getProtocol().equalsIgnoreCase("https");
        this.method = Objects.requireNonNull(method, "method");
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.headers = headers != null ? headers : Property.EMPTY_ARRAY;
        this.sslConfiguration = sslConfiguration;
        if (this.sslConfiguration != null && !this.isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        this.verifyHostname = verifyHostname;
    }

    @Override
    public void send(Layout<?> layout, LogEvent event) throws IOException {
        block41: {
            StringBuilder errorMessage;
            OutputStream os22;
            HttpURLConnection urlConnection = (HttpURLConnection)this.url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod(this.method);
            if (this.connectTimeoutMillis > 0) {
                urlConnection.setConnectTimeout(this.connectTimeoutMillis);
            }
            if (this.readTimeoutMillis > 0) {
                urlConnection.setReadTimeout(this.readTimeoutMillis);
            }
            if (layout.getContentType() != null) {
                urlConnection.setRequestProperty("Content-Type", layout.getContentType());
            }
            Property[] propertyArray = this.headers;
            int n = this.headers.length;
            int n2 = 0;
            while (n2 < n) {
                Property header = propertyArray[n2];
                urlConnection.setRequestProperty(header.getName(), header.isValueNeedsLookup() ? this.getConfiguration().getStrSubstitutor().replace(event, header.getValue()) : header.getValue());
                ++n2;
            }
            if (this.sslConfiguration != null) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslConfiguration.getSslSocketFactory());
            }
            if (this.isHttps && !this.verifyHostname) {
                ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
            }
            byte[] msg = layout.toByteArray(event);
            urlConnection.setFixedLengthStreamingMode(msg.length);
            urlConnection.connect();
            Throwable throwable = null;
            Throwable throwable2 = null;
            try {
                os22 = urlConnection.getOutputStream();
                try {
                    os22.write(msg);
                }
                finally {
                    if (os22 != null) {
                        os22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            byte[] buffer = new byte[1024];
            try {
                throwable2 = null;
                os22 = null;
                try (InputStream is = urlConnection.getInputStream();){
                    while (-1 != is.read(buffer)) {
                    }
                    break block41;
                }
                catch (Throwable os22) {
                    if (throwable2 == null) {
                        throwable2 = os22;
                    } else if (throwable2 != os22) {
                        throwable2.addSuppressed(os22);
                    }
                    throw throwable2;
                }
            }
            catch (IOException e) {
                errorMessage = new StringBuilder();
                Throwable throwable4 = null;
                Object var9_18 = null;
                try (InputStream es = urlConnection.getErrorStream();){
                    errorMessage.append(urlConnection.getResponseCode());
                    if (urlConnection.getResponseMessage() != null) {
                        errorMessage.append(' ').append(urlConnection.getResponseMessage());
                    }
                    if (es != null) {
                        int n3;
                        errorMessage.append(" - ");
                        while (-1 != (n3 = es.read(buffer))) {
                            errorMessage.append(new String(buffer, 0, n3, CHARSET));
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable4 == null) {
                        throwable4 = throwable5;
                    } else if (throwable4 != throwable5) {
                        throwable4.addSuppressed(throwable5);
                    }
                    throw throwable4;
                }
            }
            if (urlConnection.getResponseCode() > -1) {
                throw new IOException(errorMessage.toString());
            }
            throw e;
        }
    }
}

