/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class ResolverUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String VFSZIP = "vfszip";
    private static final String VFS = "vfs";
    private static final String JAR = "jar";
    private static final String BUNDLE_RESOURCE = "bundleresource";
    private final Set<Class<?>> classMatches = new HashSet();
    private final Set<URI> resourceMatches = new HashSet<URI>();
    private ClassLoader classloader;

    public Set<Class<?>> getClasses() {
        return this.classMatches;
    }

    public Set<URI> getResources() {
        return this.resourceMatches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader != null ? this.classloader : (this.classloader = Loader.getClassLoader(ResolverUtil.class, null));
    }

    public void setClassLoader(ClassLoader aClassloader) {
        this.classloader = aClassloader;
    }

    public void find(Test test, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            this.findInPackage(test, pkg);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void findInPackage(Test test, String packageName) {
        packageName = packageName.replace('.', '/');
        loader = this.getClassLoader();
        try {
            urls = loader.getResources(packageName);
            if (true) ** GOTO lbl68
        }
        catch (IOException ioe) {
            ResolverUtil.LOGGER.warn("Could not read package: {}", (Object)packageName, (Object)ioe);
            return;
        }
        do {
            try {
                url = urls.nextElement();
                urlPath = this.extractPath(url);
                ResolverUtil.LOGGER.info("Scanning for classes in '{}' matching criteria {}", (Object)urlPath, (Object)test);
                if ("vfszip".equals(url.getProtocol())) {
                    path = urlPath.substring(0, urlPath.length() - packageName.length() - 2);
                    newURL = new URL(url.getProtocol(), url.getHost(), path);
                    stream = new JarInputStream(newURL.openStream());
                    try {
                        this.loadImplementationsInJar(test, packageName, path, stream);
                        continue;
                    }
                    finally {
                        this.close(stream, newURL);
                    }
                }
                if ("vfs".equals(url.getProtocol())) {
                    containerPath = urlPath.substring(1, urlPath.length() - packageName.length() - 2);
                    containerFile = new File(containerPath);
                    if (containerFile.exists()) {
                        if (containerFile.isDirectory()) {
                            this.loadImplementationsInDirectory(test, packageName, new File(containerFile, packageName));
                            continue;
                        }
                        this.loadImplementationsInJar(test, packageName, containerFile);
                        continue;
                    }
                    path = urlPath.substring(0, urlPath.length() - packageName.length() - 2);
                    newURL = new URL(url.getProtocol(), url.getHost(), path);
                    var11_14 = null;
                    var12_16 = null;
                    try {
                        is = newURL.openStream();
                        try {
                            jarStream = is instanceof JarInputStream != false ? (JarInputStream)is : new JarInputStream(is);
                            this.loadImplementationsInJar(test, packageName, path, jarStream);
                            continue;
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Throwable var12_17) {
                        if (var11_14 == null) {
                            var11_14 = var12_17;
                        } else if (var11_14 != var12_17) {
                            var11_14.addSuppressed(var12_17);
                        }
                        throw var11_14;
                    }
                }
                if ("bundleresource".equals(url.getProtocol())) {
                    this.loadImplementationsInBundle(test, packageName);
                    continue;
                }
                if ("jar".equals(url.getProtocol())) {
                    this.loadImplementationsInJar(test, packageName, url);
                    continue;
                }
                file = new File(urlPath);
                if (file.isDirectory()) {
                    this.loadImplementationsInDirectory(test, packageName, file);
                    continue;
                }
                this.loadImplementationsInJar(test, packageName, file);
            }
            catch (IOException | URISyntaxException ioe) {
                ResolverUtil.LOGGER.warn("Could not read entries", (Throwable)ioe);
            }
lbl68:
            // 10 sources

        } while (urls.hasMoreElements());
    }

    String extractPath(URL url) throws UnsupportedEncodingException, URISyntaxException {
        int bangIndex;
        String urlPath = url.getPath();
        if (urlPath.startsWith("jar:")) {
            urlPath = urlPath.substring(4);
        }
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if ((bangIndex = urlPath.indexOf(33)) > 0) {
            urlPath = urlPath.substring(0, bangIndex);
        }
        String protocol = url.getProtocol();
        List<String> neverDecode = Arrays.asList(VFS, VFSZIP, BUNDLE_RESOURCE);
        if (neverDecode.contains(protocol)) {
            return urlPath;
        }
        String cleanPath = new URI(urlPath).getPath();
        if (new File(cleanPath).exists()) {
            return cleanPath;
        }
        return URLDecoder.decode(urlPath, StandardCharsets.UTF_8.name());
    }

    private void loadImplementationsInBundle(Test test, String packageName) {
        BundleWiring wiring = (BundleWiring)FrameworkUtil.getBundle(ResolverUtil.class).adapt(BundleWiring.class);
        Collection list = wiring.listResources(packageName, "*.class", 1);
        for (String name : list) {
            this.addIfMatching(test, name);
        }
    }

    private void loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String packageOrClass;
            File file = fileArray[n2];
            StringBuilder builder = new StringBuilder();
            builder.append(parent).append('/').append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file);
            } else if (this.isTestApplicable(test, file.getName())) {
                this.addIfMatching(test, packageOrClass);
            }
            ++n2;
        }
    }

    private boolean isTestApplicable(Test test, String path) {
        return test.doesMatchResource() || path.endsWith(".class") && test.doesMatchClass();
    }

    private void loadImplementationsInJar(Test test, String parent, URL url) {
        block13: {
            JarURLConnection connection = null;
            try {
                connection = (JarURLConnection)url.openConnection();
                if (connection != null) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (JarFile jarFile = connection.getJarFile();){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (entry.isDirectory() || !name.startsWith(parent) || !this.isTestApplicable(test, name)) continue;
                            this.addIfMatching(test, name);
                        }
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                LOGGER.error("Could not establish connection to {}", (Object)url.toString());
            }
            catch (IOException ex) {
                LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)url.toString(), (Object)test, (Object)ex);
            }
        }
    }

    private void loadImplementationsInJar(Test test, String parent, File jarFile) {
        block5: {
            JarInputStream jarStream = null;
            try {
                try {
                    jarStream = new JarInputStream(new FileInputStream(jarFile));
                    this.loadImplementationsInJar(test, parent, jarFile.getPath(), jarStream);
                }
                catch (IOException ex) {
                    LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)jarFile, (Object)test, (Object)ex);
                    this.close(jarStream, jarFile);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.close(jarStream, jarFile);
                throw throwable;
            }
            this.close(jarStream, jarFile);
        }
    }

    private void close(JarInputStream jarStream, Object source) {
        if (jarStream != null) {
            try {
                jarStream.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing JAR file stream for {}", source, (Object)e);
            }
        }
    }

    private void loadImplementationsInJar(Test test, String parent, String path, JarInputStream stream) {
        try {
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !this.isTestApplicable(test, name)) continue;
                this.addIfMatching(test, name);
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Could not search JAR file '{}' for classes matching criteria {} due to an IOException", (Object)path, (Object)test, (Object)ioe);
        }
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            ClassLoader loader = this.getClassLoader();
            if (test.doesMatchClass()) {
                Class<?> type;
                String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking to see if class {} matches criteria {}", (Object)externalName, (Object)test);
                }
                if (test.matches(type = loader.loadClass(externalName))) {
                    this.classMatches.add(type);
                }
            }
            if (test.doesMatchResource()) {
                URL url = loader.getResource(fqn);
                if (url == null) {
                    url = loader.getResource(fqn.substring(1));
                }
                if (url != null && test.matches(url.toURI())) {
                    this.resourceMatches.add(url.toURI());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Could not examine class {}", (Object)fqn, (Object)t);
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);

        public boolean matches(URI var1);

        public boolean doesMatchClass();

        public boolean doesMatchResource();
    }
}

