/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.oer.BitBuilder;
import org.bouncycastle.oer.Element;
import org.bouncycastle.oer.OERDefinition;
import org.bouncycastle.oer.OEROptional;
import org.bouncycastle.oer.SwitchIndexer;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class OEROutputStream
extends OutputStream {
    private static final int[] bits = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private final OutputStream out;
    protected PrintWriter debugOutput = null;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType;

    public OEROutputStream(OutputStream out) {
        this.out = out;
    }

    public static int byteLength(long value) {
        long m = -72057594037927936L;
        int j = 8;
        while (j > 0 && (value & m) == 0L) {
            value <<= 8;
            --j;
        }
        return j;
    }

    /*
     * Unable to fully structure code
     */
    public void write(ASN1Encodable encodable, Element oerElement) throws IOException {
        if (encodable == OEROptional.ABSENT) {
            return;
        }
        if (encodable instanceof OEROptional) {
            this.write(((OEROptional)encodable).get(), oerElement);
            return;
        }
        encodable = encodable.toASN1Primitive();
        switch (OEROutputStream.$SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType()[oerElement.getBaseType().ordinal()]) {
            case 22: {
                this.write(encodable, oerElement.getElementSupplier().build());
                break;
            }
            case 1: {
                seq = ASN1Sequence.getInstance((Object)encodable);
                j = 7;
                mask = 0;
                extensionDefined = false;
                if (oerElement.isExtensionsInDefinition()) {
                    t = 0;
                    while (t < oerElement.getChildren().size()) {
                        e = oerElement.getChildren().get(t);
                        if (e.getBaseType() == OERDefinition.BaseType.EXTENSION) break;
                        if (e.getBlock() > 0 && t < seq.size() && !OEROptional.ABSENT.equals(seq.getObjectAt(t))) {
                            extensionDefined = true;
                            break;
                        }
                        ++t;
                    }
                    if (extensionDefined) {
                        mask |= OEROutputStream.bits[j];
                    }
                    --j;
                }
                t = 0;
                while (t < oerElement.getChildren().size()) {
                    childOERDescription = oerElement.getChildren().get(t);
                    if (childOERDescription.getBaseType() != OERDefinition.BaseType.EXTENSION) {
                        if (childOERDescription.getBlock() > 0) break;
                        childOERDescription = Element.expandDeferredDefinition(childOERDescription, oerElement);
                        if (oerElement.getaSwitch() != null) {
                            childOERDescription = oerElement.getaSwitch().result(new SwitchIndexer.Asn1SequenceIndexer(seq));
                            childOERDescription = Element.expandDeferredDefinition(childOERDescription, oerElement);
                        }
                        if (j < 0) {
                            this.out.write(mask);
                            j = 7;
                            mask = 0;
                        }
                        asn1EncodableChild = seq.getObjectAt(t);
                        if (childOERDescription.isExplicit() && asn1EncodableChild instanceof OEROptional) {
                            throw new IllegalStateException("absent sequence element that is required by oer definition");
                        }
                        if (!childOERDescription.isExplicit()) {
                            obj = seq.getObjectAt(t);
                            if (childOERDescription.getDefaultValue() != null) {
                                if (obj instanceof OEROptional) {
                                    if (((OEROptional)obj).isDefined() && !((OEROptional)obj).get().equals(childOERDescription.getDefaultValue())) {
                                        mask |= OEROutputStream.bits[j];
                                    }
                                } else if (!childOERDescription.getDefaultValue().equals(obj)) {
                                    mask |= OEROutputStream.bits[j];
                                }
                            } else if (asn1EncodableChild != OEROptional.ABSENT) {
                                mask |= OEROutputStream.bits[j];
                            }
                            --j;
                        }
                    }
                    ++t;
                }
                if (j != 7) {
                    this.out.write(mask);
                }
                childElements = oerElement.getChildren();
                t = 0;
                while (t < childElements.size()) {
                    childOERElement = oerElement.getChildren().get(t);
                    if (childOERElement.getBaseType() != OERDefinition.BaseType.EXTENSION) {
                        if (childOERElement.getBlock() > 0) break;
                        child = seq.getObjectAt(t);
                        if (childOERElement.getaSwitch() != null) {
                            childOERElement = childOERElement.getaSwitch().result(new SwitchIndexer.Asn1SequenceIndexer(seq));
                        }
                        if (childOERElement.getDefaultValue() == null || !childOERElement.getDefaultValue().equals(child)) {
                            this.write(child, childOERElement);
                        }
                    }
                    ++t;
                }
                if (extensionDefined) {
                    start = t;
                    presensceList = new ByteArrayOutputStream();
                    j = 7;
                    mask = 0;
                    i = start;
                    while (i < childElements.size()) {
                        if (j < 0) {
                            presensceList.write(mask);
                            j = 7;
                            mask = 0;
                        }
                        if (i < seq.size() && !OEROptional.ABSENT.equals(seq.getObjectAt(i))) {
                            mask |= OEROutputStream.bits[j];
                        }
                        --j;
                        ++i;
                    }
                    if (j != 7) {
                        presensceList.write(mask);
                    }
                    this.encodeLength(presensceList.size() + 1);
                    if (j == 7) {
                        this.write(0);
                    } else {
                        this.write(j + 1);
                    }
                    this.write(presensceList.toByteArray());
                    while (t < childElements.size()) {
                        if (t < seq.size() && !OEROptional.ABSENT.equals(seq.getObjectAt(t))) {
                            this.writePlainType(seq.getObjectAt(t), childElements.get(t));
                        }
                        ++t;
                    }
                }
                this.out.flush();
                this.debugPrint(oerElement.appendLabel(""));
                break;
            }
            case 2: {
                if (encodable instanceof ASN1Set) {
                    e = ((ASN1Set)encodable).getObjects();
                    this.encodeQuantity(((ASN1Set)encodable).size());
                } else if (encodable instanceof ASN1Sequence) {
                    e = ((ASN1Sequence)encodable).getObjects();
                    this.encodeQuantity(((ASN1Sequence)encodable).size());
                } else {
                    throw new IllegalStateException("encodable at for SEQ_OF is not a container");
                }
                encodingElement = Element.expandDeferredDefinition(oerElement.getFirstChid(), oerElement);
                while (e.hasMoreElements()) {
                    o = e.nextElement();
                    this.write((ASN1Encodable)o, encodingElement);
                }
                this.out.flush();
                this.debugPrint(oerElement.appendLabel(""));
                break;
            }
            case 3: {
                item = encodable.toASN1Primitive();
                bb = new BitBuilder();
                valueToWrite = null;
                if (!(item instanceof ASN1TaggedObject)) {
                    throw new IllegalStateException("only support tagged objects");
                }
                taggedObject = (ASN1TaggedObject)item;
                tagClass = taggedObject.getTagClass();
                bb.writeBit(tagClass & 128).writeBit(tagClass & 64);
                tag = taggedObject.getTagNo();
                valueToWrite = taggedObject.getBaseObject().toASN1Primitive();
                if (tag <= 63) {
                    bb.writeBits(tag, 6);
                } else {
                    bb.writeBits(255L, 6);
                    bb.write7BitBytes(tag);
                }
                if (this.debugOutput != null && item instanceof ASN1TaggedObject) {
                    taggedObject = (ASN1TaggedObject)item;
                    if (64 == taggedObject.getTagClass()) {
                        this.debugPrint(oerElement.appendLabel("AS"));
                    } else {
                        this.debugPrint(oerElement.appendLabel("CS"));
                    }
                }
                bb.writeAndClear(this.out);
                val = oerElement.getChildren().get(tag);
                val = Element.expandDeferredDefinition(val, oerElement);
                if (val.getBlock() > 0) {
                    this.writePlainType((ASN1Encodable)valueToWrite, val);
                } else {
                    this.write((ASN1Encodable)valueToWrite, val);
                }
                this.out.flush();
                break;
            }
            case 4: {
                ordinal = encodable instanceof ASN1Integer != false ? ASN1Integer.getInstance((Object)encodable).getValue() : ASN1Enumerated.getInstance((Object)encodable).getValue();
                for (Element child : oerElement.getChildren()) {
                    if (!(child = Element.expandDeferredDefinition(child, oerElement)).getEnumValue().equals(ordinal)) continue;
                    if (ordinal.compareTo(BigInteger.valueOf(127L)) > 0) {
                        val = ordinal.toByteArray();
                        l = 128 | val.length & 255;
                        this.out.write(l);
                        this.out.write(val);
                    } else {
                        this.out.write(ordinal.intValue() & 127);
                    }
                    this.out.flush();
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                    return;
                }
                throw new IllegalArgumentException("enum value " + ordinal + " " + Hex.toHexString((byte[])ordinal.toByteArray()) + " no in defined child list");
            }
            case 5: {
                integer = ASN1Integer.getInstance((Object)encodable);
                intBytesForRange = oerElement.intBytesForRange();
                if (intBytesForRange <= 0) ** GOTO lbl186
                encoded = BigIntegers.asUnsignedByteArray((int)intBytesForRange, (BigInteger)integer.getValue());
                switch (intBytesForRange) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        this.out.write(encoded);
                        ** GOTO lbl208
                    }
                    default: {
                        throw new IllegalStateException("unknown uint length " + intBytesForRange);
                    }
                }
lbl186:
                // 1 sources

                if (intBytesForRange < 0) {
                    number = integer.getValue();
                    switch (intBytesForRange) {
                        case -1: {
                            encoded = new byte[]{BigIntegers.byteValueExact((BigInteger)number)};
                            break;
                        }
                        case -2: {
                            encoded = Pack.shortToBigEndian((short)BigIntegers.shortValueExact((BigInteger)number));
                            break;
                        }
                        case -4: {
                            encoded = Pack.intToBigEndian((int)BigIntegers.intValueExact((BigInteger)number));
                            break;
                        }
                        case -8: {
                            encoded = Pack.longToBigEndian((long)BigIntegers.longValueExact((BigInteger)number));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown twos compliment length");
                        }
                    }
                    this.out.write(encoded);
                } else {
                    encoded = oerElement.isLowerRangeZero() != false ? BigIntegers.asUnsignedByteArray((BigInteger)integer.getValue()) : integer.getValue().toByteArray();
                    this.encodeLength(encoded.length);
                    this.out.write(encoded);
                }
lbl208:
                // 3 sources

                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case 6: {
                octets = ASN1OctetString.getInstance((Object)encodable);
                bytes = octets.getOctets();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                } else {
                    this.encodeLength(bytes.length);
                    this.out.write(bytes);
                }
                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case 19: {
                iaf = ASN1IA5String.getInstance((Object)encodable);
                encoded = iaf.getOctets();
                if (oerElement.isFixedLength() && oerElement.getUpperBound().intValue() != encoded.length) {
                    throw new IOException("IA5String string length does not equal declared fixed length " + encoded.length + " " + oerElement.getUpperBound());
                }
                if (oerElement.isFixedLength()) {
                    this.out.write(encoded);
                } else {
                    this.encodeLength(encoded.length);
                    this.out.write(encoded);
                }
                this.debugPrint(oerElement.appendLabel(""));
                this.out.flush();
                break;
            }
            case 8: {
                utf8 = ASN1UTF8String.getInstance((Object)encodable);
                encoded = Strings.toUTF8ByteArray((String)utf8.getString());
                this.encodeLength(encoded.length);
                this.out.write(encoded);
                this.debugPrint(oerElement.appendLabel(""));
                this.out.flush();
                break;
            }
            case 9: {
                bitString = ASN1BitString.getInstance((Object)encodable);
                bytes = bitString.getBytes();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                } else {
                    padBits = bitString.getPadBits();
                    this.encodeLength(bytes.length + 1);
                    this.out.write(padBits);
                    this.out.write(bytes);
                    this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                }
                this.out.flush();
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                octets = ASN1OctetString.getInstance((Object)encodable);
                bytes = octets.getOctets();
                if (oerElement.isFixedLength()) {
                    this.out.write(bytes);
                } else {
                    this.encodeLength(bytes.length);
                    this.out.write(bytes);
                }
                this.debugPrint(oerElement.appendLabel(oerElement.rangeExpression()));
                this.out.flush();
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.debugPrint(oerElement.getLabel());
                asn1Boolean = ASN1Boolean.getInstance((Object)encodable);
                if (asn1Boolean.isTrue()) {
                    this.out.write(255);
                } else {
                    this.out.write(0);
                }
                this.out.flush();
            }
        }
    }

    protected void debugPrint(String what) {
        if (this.debugOutput != null) {
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            int level = -1;
            int i = 0;
            while (i != callStack.length) {
                StackTraceElement ste = callStack[i];
                if (ste.getMethodName().equals("debugPrint")) {
                    level = 0;
                } else if (ste.getClassName().contains("OERInput")) {
                    ++level;
                }
                ++i;
            }
            while (level > 0) {
                this.debugOutput.append("    ");
                --level;
            }
            this.debugOutput.append(what).append("\n");
            this.debugOutput.flush();
        }
    }

    private void encodeLength(long len) throws IOException {
        if (len <= 127L) {
            this.out.write((int)len);
        } else {
            byte[] value = BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(len));
            this.out.write(value.length | 0x80);
            this.out.write(value);
        }
    }

    private void encodeQuantity(long quantity) throws IOException {
        byte[] quantityEncoded = BigIntegers.asUnsignedByteArray((BigInteger)BigInteger.valueOf(quantity));
        this.out.write(quantityEncoded.length);
        this.out.write(quantityEncoded);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void writePlainType(ASN1Encodable value, Element e) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OEROutputStream oerOutputStream = new OEROutputStream(bos);
        oerOutputStream.write(value, e);
        oerOutputStream.flush();
        oerOutputStream.close();
        this.encodeLength(bos.size());
        this.write(bos.toByteArray());
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType() {
        if ($SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType != null) {
            return $SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType;
        }
        int[] nArray = new int[OERDefinition.BaseType.values().length];
        try {
            nArray[OERDefinition.BaseType.BIT_STRING.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.BMPString.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.BOOLEAN.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.CHOICE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.ENUM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.ENUM_ITEM.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.EXTENSION.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.IA5String.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.INT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.IS0646String.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.NULL.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.NumericString.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.OCTET_STRING.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.OPAQUE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.PrintableString.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.SEQ.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.SEQ_OF.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.Supplier.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.Switch.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.UTF8_STRING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.UniversalString.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[OERDefinition.BaseType.VisibleString.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$bouncycastle$oer$OERDefinition$BaseType = nArray;
        return nArray;
    }
}

