/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter.qual;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public enum I18nConversionCategory {
    UNUSED(null, null),
    GENERAL(null, null),
    DATE(new Class[]{Date.class, Number.class}, new String[]{"date", "time"}),
    NUMBER(new Class[]{Number.class}, new String[]{"number", "choice"});

    public final Class<? extends Object>[] types;
    public final String[] strings;

    private I18nConversionCategory(Class<? extends Object>[] types, String[] strings) {
        this.types = types;
        this.strings = strings;
    }

    public static I18nConversionCategory stringToI18nConversionCategory(String string) {
        string = string.toLowerCase();
        I18nConversionCategory[] i18nConversionCategoryArray = new I18nConversionCategory[]{DATE, NUMBER};
        int n = i18nConversionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            I18nConversionCategory v = i18nConversionCategoryArray[n2];
            String[] stringArray = v.strings;
            int n3 = v.strings.length;
            int n4 = 0;
            while (n4 < n3) {
                String s2 = stringArray[n4];
                if (s2.equals(string)) {
                    return v;
                }
                ++n4;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid format type.");
    }

    private static <E> Set<E> arrayToSet(E[] a) {
        return new HashSet<E>(Arrays.asList(a));
    }

    public static boolean isSubsetOf(I18nConversionCategory a, I18nConversionCategory b) {
        return I18nConversionCategory.intersect(a, b) == a;
    }

    public static I18nConversionCategory intersect(I18nConversionCategory a, I18nConversionCategory b) {
        if (a == UNUSED) {
            return b;
        }
        if (b == UNUSED) {
            return a;
        }
        if (a == GENERAL) {
            return b;
        }
        if (b == GENERAL) {
            return a;
        }
        Set<Class<? extends Object>> as = I18nConversionCategory.arrayToSet(a.types);
        Set<Class<? extends Object>> bs = I18nConversionCategory.arrayToSet(b.types);
        as.retainAll(bs);
        I18nConversionCategory[] i18nConversionCategoryArray = new I18nConversionCategory[]{DATE, NUMBER};
        int n = i18nConversionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            I18nConversionCategory v = i18nConversionCategoryArray[n2];
            Set<Class<? extends Object>> vs = I18nConversionCategory.arrayToSet(v.types);
            if (vs.equals(as)) {
                return v;
            }
            ++n2;
        }
        throw new RuntimeException();
    }

    public static I18nConversionCategory union(I18nConversionCategory a, I18nConversionCategory b) {
        if (a == UNUSED || b == UNUSED) {
            return UNUSED;
        }
        if (a == GENERAL || b == GENERAL) {
            return GENERAL;
        }
        if (a == DATE || b == DATE) {
            return DATE;
        }
        return NUMBER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        if (this.types == null) {
            sb.append(" conversion category (all types)");
        } else {
            sb.append(" conversion category (one of: ");
            boolean first = true;
            Class<? extends Object>[] classArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Object> cls = classArray[n2];
                if (!first) {
                    sb.append(", ");
                }
                sb.append(cls.getCanonicalName());
                first = false;
                ++n2;
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

