/*
 * Decompiled with CFR 0.152.
 */
package impl.build.transifex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JSON {
    private static final Pattern PAT_INTEGER = Pattern.compile("[-+]?[0-9]+|0[Xx][0-9]+");
    private static final Pattern PAT_DOUBLE = Pattern.compile("[+-]?[0-9]+([Ee][+-]?[0-9]+)?|[+-]?[0-9]*\\.[0-9]*([Ee][+-]?[0-9]+)?");
    private static final Pattern PAT_STRING = Pattern.compile("\"([^\\\\]+\\\\[\"'\\\\])*[^\"]*\"|'([^\\\\]+\\\\[\"'\\\\])*[^']*'");
    private static final Pattern PAT_BOOL = Pattern.compile("(true)|(false)");

    JSON() {
    }

    private static Object parse(String s, int[] start, Matcher integerMatcher, Matcher doubleMatcher, Matcher stringMatcher, Matcher booleanMatcher) {
        String substring;
        char[] c = s.toCharArray();
        JSON.skipSpace(s, start);
        if (c[start[0]] == '[') {
            start[0] = start[0] + 1;
            ArrayList<Object> a = new ArrayList<Object>();
            if (c[start[0]] == ']') {
                start[0] = start[0] + 1;
                return a;
            }
            while (true) {
                a.add(JSON.parse(s, start, integerMatcher, doubleMatcher, stringMatcher, booleanMatcher));
                boolean crlf = JSON.skipSpace(s, start);
                char p = c[start[0]];
                if (p == ']') {
                    start[0] = start[0] + 1;
                    return a;
                }
                if (p == ',') {
                    start[0] = start[0] + 1;
                    continue;
                }
                if (!crlf) break;
            }
            throw new IllegalStateException(", or ] expected");
        }
        if (c[start[0]] == '{') {
            start[0] = start[0] + 1;
            HashMap<String, Object> a = new HashMap<String, Object>();
            while (true) {
                String field = (String)JSON.parse(s, start, integerMatcher, doubleMatcher, stringMatcher, booleanMatcher);
                boolean crlf = JSON.skipSpace(s, start);
                if (c[start[0]] == ':') {
                    start[0] = start[0] + 1;
                    a.put(field, JSON.parse(s, start, integerMatcher, doubleMatcher, stringMatcher, booleanMatcher));
                    crlf = JSON.skipSpace(s, start);
                } else {
                    a.put(field, "");
                }
                char p = c[start[0]];
                if (p == '}') {
                    start[0] = start[0] + 1;
                    return a;
                }
                if (p == ',') {
                    start[0] = start[0] + 1;
                    continue;
                }
                if (crlf) continue;
                start[0] = start[0] + 1;
            }
        }
        if (integerMatcher.find(start[0]) && (substring = JSON.match(start, s, integerMatcher)) != null) {
            return Integer.valueOf(substring);
        }
        if (doubleMatcher.find(start[0]) && (substring = JSON.match(start, s, doubleMatcher)) != null) {
            return Double.valueOf(substring);
        }
        if (stringMatcher.find(start[0]) && (substring = JSON.match(start, s, stringMatcher)) != null) {
            return substring.substring(1, substring.length() - 1);
        }
        if (booleanMatcher.find(start[0]) && (substring = JSON.match(start, s, booleanMatcher)) != null) {
            return Boolean.valueOf(substring);
        }
        return null;
    }

    private static String match(int[] start, String s, Matcher matcher) {
        int ms = matcher.start();
        int me = matcher.end();
        if (start[0] == ms) {
            start[0] = me;
            return s.substring(ms, me);
        }
        return null;
    }

    public static boolean skipSpace(String s, int[] start) {
        boolean ret = false;
        while (true) {
            char c;
            boolean crlf;
            boolean bl = crlf = (c = s.charAt(start[0])) == '\r' || c == '\n';
            if (c != ' ' && !crlf) break;
            if (crlf) {
                ret = true;
            }
            start[0] = start[0] + 1;
        }
        return ret;
    }

    public static <T> T parse(String json) {
        Matcher integerMatcher = PAT_INTEGER.matcher(json);
        Matcher doubleMatcher = PAT_DOUBLE.matcher(json);
        Matcher stringMatcher = PAT_STRING.matcher(json);
        Matcher booleanMatcher = PAT_BOOL.matcher(json);
        return (T)JSON.parse(json, new int[1], integerMatcher, doubleMatcher, stringMatcher, booleanMatcher);
    }
}

