/*
 * Decompiled with CFR 0.152.
 */
package impl.build.transifex;

import impl.build.transifex.JSON;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Transifex {
    private static final String CHARSET = "ISO-8859-1";
    private static final String FILE_NAME = "controlsfx_%1s.utf8";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String BASE_URI = "https://www.transifex.com/api/2/";
    private static final String PROJECT_PATH = "https://www.transifex.com/api/2/project/controlsfx/resource/controlsfx-core";
    private static final String PROJECT_DETAILS = "https://www.transifex.com/api/2/project/controlsfx/resource/controlsfx-core?details";
    private static final String LIST_TRANSLATIONS = "https://www.transifex.com/api/2/project/controlsfx/languages/";
    private static final String GET_TRANSLATION = "https://www.transifex.com/api/2/project/controlsfx/resource/controlsfx-core/translation/%1s?file";
    private static final String TRANSLATION_STATS = "https://www.transifex.com/api/2/project/controlsfx/resource/controlsfx-core/stats/%1s/";
    private static final String TRANSIFEX_API = System.getProperty("transifex.api");
    private static final boolean FILTER_INCOMPLETE_TRANSLATIONS = Boolean.parseBoolean(System.getProperty("transifex.filterIncompleteTranslations", "false"));

    public static void main(String[] args) {
        new Transifex().doTransifexCheck();
    }

    private void doTransifexCheck() {
        System.out.println("=== Starting Transifex Check ===");
        if (TRANSIFEX_API == null || TRANSIFEX_API.isEmpty()) {
            System.out.println("transifex.api system properties must be specified");
            return;
        }
        System.out.println("  Filtering out incomplete translations: " + FILTER_INCOMPLETE_TRANSLATIONS);
        Map projectDetails = (Map)JSON.parse(this.transifexRequest(PROJECT_DETAILS, new Object[0]));
        List availableLanguages = (List)projectDetails.get("available_languages");
        availableLanguages.parallelStream().map(map -> (String)map.get("code")).filter(this::filterOutIncompleteTranslations).forEach(this::downloadTranslation);
        System.out.println("Transifex Check Complete");
    }

    private String transifexRequest(String request, Object ... args) {
        return Transifex.performTransifexTask(this::parseInputStream, request, args);
    }

    private String parseInputStream(InputStream inputStream) {
        StringBuilder response = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream, CHARSET));){
                String line;
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                    response.append(NEW_LINE);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response.toString();
    }

    private static <T> T performTransifexTask(Function<InputStream, T> consumer, String request, Object ... args) {
        request = String.format(request, args);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(request);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            String encoded = Base64.getEncoder().encodeToString(("api:" + TRANSIFEX_API).getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encoded);
            connection.setRequestProperty("Accept-Charset", CHARSET);
            T t = consumer.apply(connection.getInputStream());
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    private boolean filterOutIncompleteTranslations(String languageCode) {
        Map map = (Map)JSON.parse(this.transifexRequest(TRANSLATION_STATS, languageCode));
        String completed = map.getOrDefault("completed", "0%");
        String reviewed = map.getOrDefault("reviewed_percentage", "0%");
        boolean isAccepted = completed.equals("100%") && reviewed.equals("100%");
        System.out.println("  Reviewing translation '" + languageCode + "'" + "\tcompletion: " + completed + ",\treviewed: " + reviewed + "\t-> TRANSLATION" + (isAccepted ? " ACCEPTED" : " REJECTED"));
        return isAccepted || !FILTER_INCOMPLETE_TRANSLATIONS;
    }

    private void downloadTranslation(String languageCode) {
        System.out.println("\tDownloading translation file...");
        Function<InputStream, Void> consumer = inputStream -> {
            String outputFile = "build/resources/main/" + String.format(FILE_NAME, languageCode);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedWriter writer = new BufferedWriter(new PrintWriter(outputFile, CHARSET));){
                    writer.write(this.parseInputStream((InputStream)inputStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        };
        Transifex.performTransifexTask(consumer, GET_TRANSLATION, languageCode);
    }
}

