/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.i18n;

import impl.org.controlsfx.i18n.Translation;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class Translations {
    private static final List<Translation> translations = new ArrayList<Translation>();

    static {
        File file = new File(Translations.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (file.getName().endsWith(".jar")) {
            Path jarFile = file.toPath();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileSystem fs = FileSystems.newFileSystem(jarFile, null);){
                    fs.getRootDirectories().forEach(path -> Translations.loadFrom(path));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (translations.isEmpty()) {
            Path srcDir = new File("src/main/resources").toPath();
            Translations.loadFrom(srcDir);
        }
        if (translations.isEmpty()) {
            Path binDir = new File("bin").toPath();
            Translations.loadFrom(binDir);
        }
        if (translations.isEmpty() && file.getAbsolutePath().endsWith("controlsfx" + File.separator + "bin")) {
            Translations.loadFrom(file.toPath());
        }
        Collections.sort(translations);
    }

    private static void loadFrom(Path rootPath) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath);){
                for (Path path : stream) {
                    String filename = path.getFileName().toString();
                    if (!filename.startsWith("controlsfx") && !filename.endsWith(".properties")) continue;
                    if ("controlsfx.properties".equals(filename)) {
                        translations.add(new Translation("en", path));
                        continue;
                    }
                    if (filename.contains("_")) {
                        String locale = filename.substring(11, filename.indexOf(".properties"));
                        translations.add(new Translation(locale, path));
                        continue;
                    }
                    throw new IllegalStateException("Unknown translation file '" + path + "'.");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DirectoryIteratorException exception) {}
    }

    private Translations() {
    }

    public static Optional<Translation> getTranslation(String localeString) {
        for (Translation t : translations) {
            if (!localeString.equals(t.getLocaleString())) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static List<Translation> getAllTranslations() {
        return translations;
    }

    public static List<Locale> getAllTranslationLocales() {
        return translations.stream().map(t -> t.getLocale()).collect(Collectors.toList());
    }
}

