/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import impl.org.controlsfx.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;
import org.controlsfx.control.BreadCrumbBar;

public class BreadCrumbBarSkin<T>
extends SkinBase<BreadCrumbBar<T>> {
    private static final String STYLE_CLASS_FIRST = "first";
    private final ChangeListener<TreeItem<T>> selectedPathChangeListener = (obs, oldItem, newItem) -> this.updateSelectedPath((TreeItem<T>)newItem, (TreeItem<T>)oldItem);
    private final EventHandler<TreeItem.TreeModificationEvent<Object>> treeChildrenModifiedHandler = args -> this.updateBreadCrumbs();

    public BreadCrumbBarSkin(BreadCrumbBar<T> control) {
        super(control);
        control.selectedCrumbProperty().addListener(this.selectedPathChangeListener);
        this.updateSelectedPath((TreeItem)((BreadCrumbBar)this.getSkinnable()).selectedCrumbProperty().get(), null);
        this.fixFocusTraversal();
    }

    private void fixFocusTraversal() {
        ParentTraversalEngine engine = new ParentTraversalEngine((Parent)this.getSkinnable(), new Algorithm(){

            public Node select(Node owner, Direction dir, TraversalContext context) {
                Node node = null;
                int idx = BreadCrumbBarSkin.this.getChildren().indexOf((Object)owner);
                switch (dir) {
                    case RIGHT: 
                    case NEXT: 
                    case NEXT_IN_LINE: {
                        if (idx >= BreadCrumbBarSkin.this.getChildren().size() - 1) break;
                        node = (Node)BreadCrumbBarSkin.this.getChildren().get(idx + 1);
                        break;
                    }
                    case LEFT: 
                    case PREVIOUS: {
                        if (idx <= 0) break;
                        node = (Node)BreadCrumbBarSkin.this.getChildren().get(idx - 1);
                    }
                }
                return node;
            }

            public Node selectFirst(TraversalContext context) {
                Node first = null;
                if (!BreadCrumbBarSkin.this.getChildren().isEmpty()) {
                    first = (Node)BreadCrumbBarSkin.this.getChildren().get(0);
                }
                return first;
            }

            public Node selectLast(TraversalContext context) {
                Node last = null;
                if (!BreadCrumbBarSkin.this.getChildren().isEmpty()) {
                    last = (Node)BreadCrumbBarSkin.this.getChildren().get(BreadCrumbBarSkin.this.getChildren().size() - 1);
                }
                return last;
            }
        });
        engine.setOverriddenFocusTraversability(Boolean.valueOf(false));
        ReflectionUtils.setTraversalEngine(this.getSkinnable(), engine);
    }

    private void updateSelectedPath(TreeItem<T> newTarget, TreeItem<T> oldTarget) {
        if (oldTarget != null) {
            oldTarget.removeEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        if (newTarget != null) {
            newTarget.addEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        this.updateBreadCrumbs();
    }

    private void updateBreadCrumbs() {
        BreadCrumbBar buttonBar = (BreadCrumbBar)this.getSkinnable();
        TreeItem pathTarget = buttonBar.getSelectedCrumb();
        Callback factory = buttonBar.getCrumbFactory();
        this.getChildren().clear();
        if (pathTarget != null) {
            List crumbs = this.constructFlatPath(pathTarget);
            int i = 0;
            while (i < crumbs.size()) {
                Button crumb = this.createCrumb(factory, crumbs.get(i));
                crumb.setMnemonicParsing(false);
                if (i == 0) {
                    if (!crumb.getStyleClass().contains((Object)STYLE_CLASS_FIRST)) {
                        crumb.getStyleClass().add((Object)STYLE_CLASS_FIRST);
                    }
                } else {
                    crumb.getStyleClass().remove((Object)STYLE_CLASS_FIRST);
                }
                this.getChildren().add((Object)crumb);
                ++i;
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        int i = 0;
        while (i < this.getChildren().size()) {
            Node n = (Node)this.getChildren().get(i);
            double nw = this.snapSize(n.prefWidth(h));
            double nh = this.snapSize(n.prefHeight(-1.0));
            if (i > 0) {
                double ins = n instanceof BreadCrumbBar.BreadCrumbButton ? ((BreadCrumbBar.BreadCrumbButton)n).getArrowWidth() : 0.0;
                x = this.snapPosition(x - ins);
            }
            n.resize(nw, nh);
            n.relocate(x, y);
            x += nw;
            ++i;
        }
    }

    private List<TreeItem<T>> constructFlatPath(TreeItem<T> bottomMost) {
        ArrayList<TreeItem<T>> path = new ArrayList<TreeItem<T>>();
        TreeItem current = bottomMost;
        do {
            path.add(current);
        } while ((current = current.getParent()) != null);
        Collections.reverse(path);
        return path;
    }

    private Button createCrumb(Callback<TreeItem<T>, Button> factory, TreeItem<T> selectedCrumb) {
        Button crumb = (Button)factory.call(selectedCrumb);
        crumb.getStyleClass().add((Object)"crumb");
        crumb.setOnAction(ae -> this.onBreadCrumbAction(selectedCrumb));
        return crumb;
    }

    protected void onBreadCrumbAction(TreeItem<T> crumbModel) {
        BreadCrumbBar breadCrumbBar = (BreadCrumbBar)this.getSkinnable();
        Event.fireEvent((EventTarget)breadCrumbBar, new BreadCrumbBar.BreadCrumbActionEvent<T>(crumbModel));
        if (breadCrumbBar.isAutoNavigationEnabled()) {
            breadCrumbBar.setSelectedCrumb(crumbModel);
        }
    }
}

