/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.controlsfx.control.SegmentedButton;

public class SegmentedButtonSkin
extends SkinBase<SegmentedButton> {
    private static final String ONLY_BUTTON = "only-button";
    private static final String LEFT_PILL = "left-pill";
    private static final String CENTER_PILL = "center-pill";
    private static final String RIGHT_PILL = "right-pill";
    private final HBox container = new HBox();

    public SegmentedButtonSkin(SegmentedButton control) {
        super((Control)control);
        this.getChildren().add((Object)this.container);
        this.updateButtons();
        this.getButtons().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SegmentedButtonSkin.this.updateButtons();
            }
        });
        control.toggleGroupProperty().addListener((observable, oldValue, newValue) -> this.getButtons().forEach(button -> button.setToggleGroup(newValue)));
    }

    private ObservableList<ToggleButton> getButtons() {
        return ((SegmentedButton)this.getSkinnable()).getButtons();
    }

    private void updateButtons() {
        ObservableList<ToggleButton> buttons = this.getButtons();
        ToggleGroup group = ((SegmentedButton)this.getSkinnable()).getToggleGroup();
        this.container.getChildren().clear();
        int i = 0;
        while (i < this.getButtons().size()) {
            ToggleButton t = (ToggleButton)buttons.get(i);
            if (group != null) {
                t.setToggleGroup(group);
            }
            t.getStyleClass().removeAll((Object[])new String[]{ONLY_BUTTON, LEFT_PILL, CENTER_PILL, RIGHT_PILL});
            this.container.getChildren().add((Object)t);
            if (i == buttons.size() - 1) {
                if (i == 0) {
                    t.getStyleClass().add((Object)ONLY_BUTTON);
                } else {
                    t.getStyleClass().add((Object)RIGHT_PILL);
                }
            } else if (i == 0) {
                t.getStyleClass().add((Object)LEFT_PILL);
            } else {
                t.getStyleClass().add((Object)CENTER_PILL);
            }
            ++i;
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((SegmentedButton)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((SegmentedButton)this.getSkinnable()).prefHeight(width);
    }
}

