/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.controlsfx.control.StatusBar;

public class StatusBarSkin
extends SkinBase<StatusBar> {
    private HBox leftBox;
    private HBox rightBox;
    private Label label;
    private ProgressBar progressBar;

    public StatusBarSkin(StatusBar statusBar) {
        super((Control)statusBar);
        BooleanBinding notZeroProgressProperty = Bindings.notEqual((int)0, (ObservableNumberValue)statusBar.progressProperty());
        GridPane gridPane = new GridPane();
        this.leftBox = new HBox();
        this.leftBox.getStyleClass().add((Object)"left-items");
        this.rightBox = new HBox();
        this.rightBox.getStyleClass().add((Object)"right-items");
        this.progressBar = new ProgressBar();
        this.progressBar.progressProperty().bind((ObservableValue)statusBar.progressProperty());
        this.progressBar.visibleProperty().bind((ObservableValue)notZeroProgressProperty);
        this.progressBar.managedProperty().bind((ObservableValue)notZeroProgressProperty);
        this.label = new Label();
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.label.textProperty().bind((ObservableValue)statusBar.textProperty());
        this.label.graphicProperty().bind(statusBar.graphicProperty());
        this.label.styleProperty().bind((ObservableValue)((StatusBar)this.getSkinnable()).styleProperty());
        this.label.getStyleClass().add((Object)"status-label");
        this.leftBox.getChildren().setAll(((StatusBar)this.getSkinnable()).getLeftItems());
        this.rightBox.getChildren().setAll(((StatusBar)this.getSkinnable()).getRightItems());
        statusBar.getLeftItems().addListener(evt -> {
            boolean bl = this.leftBox.getChildren().setAll(((StatusBar)this.getSkinnable()).getLeftItems());
        });
        statusBar.getRightItems().addListener(evt -> {
            boolean bl = this.rightBox.getChildren().setAll(((StatusBar)this.getSkinnable()).getRightItems());
        });
        GridPane.setFillHeight((Node)this.leftBox, (Boolean)true);
        GridPane.setFillHeight((Node)this.rightBox, (Boolean)true);
        GridPane.setFillHeight((Node)this.label, (Boolean)true);
        GridPane.setFillHeight((Node)this.progressBar, (Boolean)true);
        GridPane.setVgrow((Node)this.leftBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.rightBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.label, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.progressBar, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        gridPane.add((Node)this.leftBox, 0, 0);
        gridPane.add((Node)this.label, 1, 0);
        gridPane.add((Node)this.progressBar, 2, 0);
        gridPane.add((Node)this.rightBox, 3, 0);
        this.getChildren().add((Object)gridPane);
    }
}

