/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.collections.MappingChange;
import impl.org.controlsfx.collections.NonIterableChange;
import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SelectedCellsMapTemp;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class TableViewSpanSelectionModel
extends TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> {
    private boolean shift = false;
    private boolean key = false;
    private boolean drag = false;
    private MouseEvent mouseEvent;
    private boolean makeAtomic;
    private SpreadsheetGridView cellsView;
    private SpreadsheetView spreadsheetView;
    private final SelectedCellsMapTemp<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsMap;
    private final ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsSeq;
    private TableColumn oldTableColumn = null;
    private int oldRow = -1;
    public Pair<Integer, Integer> direction;
    private int oldColSpan = -1;
    private int oldRowSpan = -1;
    private final Timeline timer;
    private final EventHandler<ActionEvent> timerEventHandler = event -> {
        GridViewSkin skin = this.getCellsViewSkin();
        if (this.mouseEvent != null && !this.cellsView.contains(this.mouseEvent.getX(), this.mouseEvent.getY())) {
            double sceneX = this.mouseEvent.getSceneX();
            double sceneY = this.mouseEvent.getSceneY();
            double layoutX = this.cellsView.getLocalToSceneTransform().getTx();
            double layoutY = this.cellsView.getLocalToSceneTransform().getTy();
            double layoutXMax = layoutX + this.cellsView.getWidth();
            double layoutYMax = layoutY + this.cellsView.getHeight();
            if (sceneX > layoutXMax) {
                skin.getHBar().increment();
            } else if (sceneX < layoutX) {
                skin.getHBar().decrement();
            }
            if (sceneY > layoutYMax) {
                skin.getVBar().increment();
            } else if (sceneY < layoutY) {
                skin.getVBar().decrement();
            }
        }
    };
    private final EventHandler<MouseEvent> dragDoneHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.drag = false;
            TableViewSpanSelectionModel.this.timer.stop();
            TableViewSpanSelectionModel.this.spreadsheetView.removeEventHandler(MouseEvent.MOUSE_RELEASED, this);
        }
    };
    private final EventHandler<KeyEvent> keyPressedEventHandler = keyEvent -> {
        this.key = true;
        this.shift = keyEvent.isShiftDown();
    };
    private final EventHandler<MouseEvent> mousePressedEventHandler = mouseEvent1 -> {
        this.key = false;
        this.shift = mouseEvent1.isShiftDown();
    };
    private final EventHandler<MouseEvent> onDragDetectedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.cellsView.addEventHandler(MouseEvent.MOUSE_RELEASED, TableViewSpanSelectionModel.this.dragDoneHandler);
            TableViewSpanSelectionModel.this.drag = true;
            TableViewSpanSelectionModel.this.timer.setCycleCount(-1);
            TableViewSpanSelectionModel.this.timer.play();
        }
    };
    private final EventHandler<MouseEvent> onMouseDragEventHandler = e -> {
        this.mouseEvent = e;
    };
    private final ListChangeListener<TablePosition<ObservableList<SpreadsheetCell>, ?>> listChangeListener = this::handleSelectedCellsListChangeEvent;
    private TablePosition<ObservableList<SpreadsheetCell>, ?> old = null;

    public TableViewSpanSelectionModel(@NamedArg(value="spreadsheetView") SpreadsheetView spreadsheetView, @NamedArg(value="cellsView") SpreadsheetGridView cellsView) {
        super((TableView)cellsView);
        this.cellsView = cellsView;
        this.spreadsheetView = spreadsheetView;
        this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new WeakEventHandler(this.timerEventHandler), new KeyValue[0])});
        cellsView.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new WeakEventHandler(this.keyPressedEventHandler));
        cellsView.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new WeakEventHandler(this.mousePressedEventHandler));
        cellsView.setOnDragDetected((EventHandler)new WeakEventHandler(this.onDragDetectedEventHandler));
        cellsView.setOnMouseDragged((EventHandler)new WeakEventHandler(this.onMouseDragEventHandler));
        this.selectedCellsMap = new SelectedCellsMapTemp(new WeakListChangeListener(this.listChangeListener));
        this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>(){

            @Override
            public TablePosition<ObservableList<SpreadsheetCell>, ?> get(int i) {
                return TableViewSpanSelectionModel.this.selectedCellsMap.get(i);
            }

            @Override
            public int size() {
                return TableViewSpanSelectionModel.this.selectedCellsMap.size();
            }
        };
    }

    private void handleSelectedCellsListChangeEvent(ListChangeListener.Change<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>> c) {
        if (this.makeAtomic) {
            return;
        }
        this.selectedCellsSeq.callObservers(new MappingChange(c, MappingChange.NOOP_MAP, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq));
        c.reset();
    }

    public void select(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        if (row < 0 || row >= this.getItemCount()) {
            return;
        }
        if (this.isCellSelectionEnabled() && column == null) {
            return;
        }
        TablePosition posFinal = new TablePosition(this.getTableView(), row, column);
        int columnIndex = this.cellsView.getColumns().indexOf((Object)posFinal.getTableColumn());
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(row, columnIndex);
        switch (spanType) {
            case ROW_SPAN_INVISIBLE: {
                int visibleRow;
                if (this.old != null && !this.shift && this.old.getColumn() == posFinal.getColumn() && this.old.getRow() == posFinal.getRow() - 1 && (visibleRow = FocusModelListener.getNextRowNumber(this.old, this.cellsView, this.spreadsheetView)) < this.getItemCount()) {
                    posFinal = this.getVisibleCell(visibleRow, this.oldColSpan > 1 ? this.oldTableColumn : this.old.getTableColumn());
                    break;
                }
                posFinal = this.getVisibleCell(row, this.oldColSpan > 1 ? this.oldTableColumn : column);
                break;
            }
            case BOTH_INVISIBLE: {
                posFinal = this.getVisibleCell(row, column);
                break;
            }
            case COLUMN_SPAN_INVISIBLE: {
                posFinal = this.old != null && !this.shift && this.old.getColumn() == posFinal.getColumn() - 1 && this.old.getRow() == posFinal.getRow() ? this.getVisibleCell(this.oldRowSpan > 1 ? this.oldRow : this.old.getRow(), FocusModelListener.getTableColumnSpan(this.old, this.cellsView, this.spreadsheetView)) : this.getVisibleCell(row, column);
            }
            default: {
                if (this.direction == null || !this.key) break;
                if ((Integer)this.direction.getKey() != 0 && this.oldColSpan > 1) {
                    posFinal = this.getVisibleCell(posFinal.getRow(), this.oldTableColumn);
                    break;
                }
                if ((Integer)this.direction.getValue() == 0 || this.oldRowSpan <= 1) break;
                posFinal = this.getVisibleCell(this.oldRow, posFinal.getTableColumn());
            }
        }
        this.old = posFinal;
        if (posFinal.getTableColumn() == null) {
            return;
        }
        if (!this.key) {
            this.oldRow = this.old.getRow();
            this.oldTableColumn = this.old.getTableColumn();
        } else if (this.direction != null && (Integer)this.direction.getKey() != 0) {
            this.oldRow = this.old.getRow();
        } else if (this.direction != null && (Integer)this.direction.getValue() != 0) {
            this.oldTableColumn = this.old.getTableColumn();
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        SpreadsheetCell cell = (SpreadsheetCell)this.old.getTableColumn().getCellData(this.old.getRow());
        this.oldRowSpan = this.spreadsheetView.getRowSpan(cell, this.old.getRow());
        this.oldColSpan = this.spreadsheetView.getColumnSpan(cell);
        int i = this.old.getRow();
        while (i < this.oldRowSpan + this.old.getRow()) {
            int j = this.spreadsheetView.getViewColumn(cell.getColumn());
            while (j < this.oldColSpan + this.spreadsheetView.getViewColumn(cell.getColumn())) {
                posFinal = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                this.selectedCellsMap.add(posFinal);
                ++j;
            }
            ++i;
        }
        this.updateScroll(this.old);
        this.addSelectedRowsAndColumns(this.old);
        this.setSelectedIndex(this.old.getRow());
        this.setSelectedItem((ObservableList)this.getModelItem(this.old.getRow()));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(this.old.getRow(), this.old.getTableColumn());
    }

    private void updateScroll(TablePosition<ObservableList<SpreadsheetCell>, ?> posFinal) {
        if (!this.drag && this.key && this.getCellsViewSkin().getCellsSize() != 0 && !VerticalHeader.isFixedRowEmpty(this.spreadsheetView)) {
            int start = this.getCellsViewSkin().getRow(0).getIndex();
            double posFinalOffset = 0.0;
            int j = start;
            while (j < posFinal.getRow()) {
                posFinalOffset += this.getSpreadsheetViewSkin().getRowHeight(j);
                ++j;
            }
            if (this.getCellsViewSkin().getFixedRowHeight() > posFinalOffset) {
                this.cellsView.scrollTo(posFinal.getRow());
            }
        }
    }

    public void clearSelection(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        TablePosition tp = new TablePosition(this.getTableView(), row, column);
        if (tp.getRow() < 0 || tp.getColumn() < 0) {
            return;
        }
        List<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCells = this.isSelectedRange(row, column, tp.getColumn());
        if (selectedCells != null) {
            for (TablePosition<ObservableList<SpreadsheetCell>, ?> cell : selectedCells) {
                this.selectedCellsMap.remove(cell);
                this.removeSelectedRowsAndColumns(cell);
                this.focus(cell.getRow());
            }
        } else {
            for (TablePosition pos : this.getSelectedCells()) {
                if (!pos.equals((Object)tp)) continue;
                this.selectedCellsMap.remove(pos);
                this.removeSelectedRowsAndColumns(pos);
                this.focus(row);
                return;
            }
        }
    }

    public void verifySelectedCells(List<Pair<Integer, Integer>> selectedCells) {
        HashSet<TablePosition> newList = new HashSet<TablePosition>();
        this.clearSelection();
        int itemCount = this.getItemCount();
        int columnSize = this.getTableView().getVisibleLeafColumns().size();
        final HashSet<Integer> selectedRows = new HashSet<Integer>();
        final HashSet<Integer> selectedColumns = new HashSet<Integer>();
        TablePosition pos = null;
        for (Pair<Integer, Integer> position : selectedCells) {
            TableColumn column;
            SpreadsheetCell cell;
            if ((Integer)position.getKey() < 0 || (Integer)position.getKey() >= itemCount || (Integer)position.getValue() < 0 || (Integer)position.getValue() >= columnSize || (cell = (SpreadsheetCell)(column = this.getTableView().getVisibleLeafColumn(((Integer)position.getValue()).intValue())).getCellData((pos = this.getVisibleCell((Integer)position.getKey(), column)).getRow())) == null) continue;
            int rowSpan = this.spreadsheetView.getRowSpan(cell, pos.getRow());
            int currentRow = pos.getRow();
            int i = pos.getRow();
            while (i < rowSpan + currentRow) {
                selectedColumns.add(i);
                int j = this.spreadsheetView.getViewColumn(cell.getColumn());
                while (j < this.spreadsheetView.getColumnSpan(cell) + this.spreadsheetView.getViewColumn(cell.getColumn())) {
                    selectedRows.add(j);
                    pos = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                    newList.add(pos);
                    ++j;
                }
                ++i;
            }
        }
        this.selectedCellsMap.setAll(newList);
        final TablePosition finalPos = pos;
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin == null) {
            this.cellsView.skinProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    TableViewSpanSelectionModel.this.cellsView.skinProperty().removeListener((InvalidationListener)this);
                    GridViewSkin skin = TableViewSpanSelectionModel.this.getSpreadsheetViewSkin();
                    if (skin != null) {
                        TableViewSpanSelectionModel.this.updateSelectedVisuals(skin, finalPos, selectedRows, selectedColumns);
                    }
                }
            });
        } else {
            this.updateSelectedVisuals(skin, pos, selectedRows, selectedColumns);
        }
    }

    private void updateSelectedVisuals(GridViewSkin skin, TablePosition pos, HashSet<Integer> selectedRows, HashSet<Integer> selectedColumns) {
        if (skin != null) {
            skin.getSelectedRows().addAll(selectedColumns);
            skin.getSelectedColumns().addAll(selectedRows);
        }
        if (pos != null) {
            this.getCellsViewSkin().lastRowLayout.set(true);
            this.getCellsViewSkin().lastRowLayout.addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    TableViewSpanSelectionModel.this.handleSelectedCellsListChangeEvent(new NonIterableChange.SimpleAddChange(0, TableViewSpanSelectionModel.this.selectedCellsMap.size(), (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)TableViewSpanSelectionModel.this.selectedCellsSeq));
                    TableViewSpanSelectionModel.this.getCellsViewSkin().lastRowLayout.removeListener((InvalidationListener)this);
                }
            });
        }
    }

    public void selectRange(int minRow, TableColumnBase<ObservableList<SpreadsheetCell>, ?> minColumn, int maxRow, TableColumnBase<ObservableList<SpreadsheetCell>, ?> maxColumn) {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            this.select(maxRow, maxColumn);
            return;
        }
        this.makeAtomic = true;
        int itemCount = this.getItemCount();
        int minColumnIndex = this.getTableView().getVisibleLeafIndex((TableColumn)minColumn);
        int maxColumnIndex = this.getTableView().getVisibleLeafIndex((TableColumn)maxColumn);
        int _minColumnIndex = Math.min(minColumnIndex, maxColumnIndex);
        int _maxColumnIndex = Math.max(minColumnIndex, maxColumnIndex);
        int _minRow = Math.min(minRow, maxRow);
        int _maxRow = Math.max(minRow, maxRow);
        HashSet<Integer> selectedRows = new HashSet<Integer>();
        HashSet<Integer> selectedColumns = new HashSet<Integer>();
        int _row = _minRow;
        while (_row <= _maxRow) {
            int _col = _minColumnIndex;
            while (_col <= _maxColumnIndex) {
                TableColumn column;
                if (_row >= 0 && _row < itemCount && (column = this.getTableView().getVisibleLeafColumn(_col)) != null) {
                    int currentRow;
                    TablePosition pos = this.getVisibleCell(_row, column);
                    SpreadsheetCell cell = (SpreadsheetCell)column.getCellData(pos.getRow());
                    int rowSpan = this.spreadsheetView.getRowSpan(cell, pos.getRow());
                    int i = currentRow = pos.getRow();
                    while (i < rowSpan + currentRow) {
                        selectedRows.add(i);
                        int j = this.spreadsheetView.getViewColumn(cell.getColumn());
                        while (j < this.spreadsheetView.getColumnSpan(cell) + this.spreadsheetView.getViewColumn(cell.getColumn())) {
                            selectedColumns.add(j);
                            pos = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                            this.selectedCellsMap.add(pos);
                            ++j;
                        }
                        ++i;
                    }
                }
                ++_col;
            }
            ++_row;
        }
        this.makeAtomic = false;
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(selectedRows);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(selectedColumns);
        this.setSelectedIndex(maxRow);
        this.setSelectedItem((ObservableList)this.getModelItem(maxRow));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(maxRow, (TableColumn)maxColumn);
        int startChangeIndex = this.selectedCellsMap.indexOf(new TablePosition(this.getTableView(), minRow, (TableColumn)minColumn));
        int endChangeIndex = this.selectedCellsMap.getSelectedCells().size() - 1;
        if (startChangeIndex > -1 && endChangeIndex > -1) {
            int startIndex = Math.min(startChangeIndex, endChangeIndex);
            int endIndex = Math.max(startChangeIndex, endChangeIndex);
            this.handleSelectedCellsListChangeEvent(new NonIterableChange.SimpleAddChange(startIndex, endIndex + 1, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq));
        }
    }

    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        this.quietClearSelection();
        ArrayList<TablePosition> indices = new ArrayList<TablePosition>();
        TablePosition tp = null;
        int col = 0;
        while (col < this.getTableView().getVisibleLeafColumns().size()) {
            TableColumn column = (TableColumn)this.getTableView().getVisibleLeafColumns().get(col);
            int row = 0;
            while (row < this.getItemCount()) {
                tp = new TablePosition(this.getTableView(), row, column);
                indices.add(tp);
                ++row;
            }
            ++col;
        }
        this.selectedCellsMap.setAll(indices);
        ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        int col2 = 0;
        while (col2 < this.spreadsheetView.getGrid().getColumnCount()) {
            selectedColumns.add(col2);
            ++col2;
        }
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        int row = 0;
        while (row < this.getItemCount()) {
            selectedRows.add(row);
            ++row;
        }
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(selectedRows);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(selectedColumns);
        if (tp != null) {
            this.select(tp.getRow(), tp.getTableColumn());
            this.getTableView().getFocusModel().focus(0, (TableColumn)this.getTableView().getColumns().get(0));
        }
    }

    public boolean isSelected(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        if (column == null || row < 0) {
            return false;
        }
        int columnIndex = this.getTableView().getVisibleLeafIndex(column);
        if (this.getCellsViewSkin().getCellsSize() != 0) {
            TablePosition<ObservableList<SpreadsheetCell>, ?> posFinal = this.getVisibleCell(row, column);
            return this.selectedCellsMap.isSelected(posFinal.getRow(), posFinal.getColumn());
        }
        return this.selectedCellsMap.isSelected(row, columnIndex);
    }

    public List<TablePosition<ObservableList<SpreadsheetCell>, ?>> isSelectedRange(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        if (col < 0 || row < 0) {
            return null;
        }
        SpreadsheetCell cell = (SpreadsheetCell)column.getCellData(row);
        int infRow = row;
        int supRow = infRow + this.spreadsheetView.getRowSpan(cell, row);
        int infCol = this.spreadsheetView.getViewColumn(cell.getColumn());
        int supCol = infCol + this.spreadsheetView.getColumnSpan(cell);
        ArrayList selectedCells = new ArrayList();
        for (TablePosition tp : this.getSelectedCells()) {
            if (tp.getRow() < infRow || tp.getRow() >= supRow || tp.getColumn() < infCol || tp.getColumn() >= supCol) continue;
            selectedCells.add(tp);
        }
        return selectedCells.isEmpty() ? null : selectedCells;
    }

    private void addSelectedRowsAndColumns(TablePosition<?, ?> pos) {
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin == null) {
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)pos.getTableColumn().getCellData(pos.getRow());
        int rowSpan = this.spreadsheetView.getRowSpan(cell, pos.getRow());
        int i = pos.getRow();
        while (i < rowSpan + pos.getRow()) {
            skin.getSelectedRows().add((Object)i);
            int j = this.spreadsheetView.getViewColumn(cell.getColumn());
            while (j < this.spreadsheetView.getColumnSpan(cell) + this.spreadsheetView.getViewColumn(cell.getColumn())) {
                skin.getSelectedColumns().add((Object)j);
                ++j;
            }
            ++i;
        }
    }

    private void removeSelectedRowsAndColumns(TablePosition<?, ?> pos) {
        SpreadsheetCell cell = (SpreadsheetCell)pos.getTableColumn().getCellData(pos.getRow());
        int rowSpan = this.spreadsheetView.getRowSpan(cell, pos.getRow());
        int i = pos.getRow();
        while (i < rowSpan + pos.getRow()) {
            this.getSpreadsheetViewSkin().getSelectedRows().remove((Object)i);
            int j = this.spreadsheetView.getViewColumn(cell.getColumn());
            while (j < this.spreadsheetView.getColumnSpan(cell) + this.spreadsheetView.getViewColumn(cell.getColumn())) {
                this.getSpreadsheetViewSkin().getSelectedColumns().remove((Object)j);
                ++j;
            }
            ++i;
        }
    }

    public void clearAndSelect(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        this.makeAtomic = true;
        ArrayList previousSelection = new ArrayList((Collection<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsMap.getSelectedCells());
        this.clearSelection();
        this.select(row, column);
        this.makeAtomic = false;
        if (this.old != null && this.old.getColumn() >= 0) {
            TableColumn columnFinal = this.getTableView().getVisibleLeafColumn(this.old.getColumn());
            int changeIndex = this.selectedCellsSeq.indexOf(new TablePosition(this.getTableView(), this.old.getRow(), columnFinal));
            NonIterableChange.GenericAddRemoveChange change = new NonIterableChange.GenericAddRemoveChange(changeIndex, changeIndex + 1, previousSelection, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq);
            this.handleSelectedCellsListChangeEvent(change);
        }
    }

    public ObservableList<TablePosition> getSelectedCells() {
        return (ObservableList)this.selectedCellsSeq;
    }

    public void selectAboveCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getRow() == -1) {
            this.select(this.getItemCount() - 1);
        } else if (pos.getRow() > 0) {
            this.select(pos.getRow() - 1, pos.getTableColumn());
        }
    }

    public void selectBelowCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getRow() == -1) {
            this.select(0);
        } else if (pos.getRow() < this.getItemCount() - 1) {
            this.select(pos.getRow() + 1, pos.getTableColumn());
        }
    }

    public void selectLeftCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getColumn() - 1 >= 0) {
            this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), -1));
        }
    }

    public void selectRightCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
            this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), 1));
        }
    }

    public void clearSelection() {
        if (!this.makeAtomic) {
            this.setSelectedIndex(-1);
            this.setSelectedItem((ObservableList)this.getModelItem(-1));
            this.focus(-1);
        }
        this.quietClearSelection();
    }

    private void quietClearSelection() {
        this.selectedCellsMap.clear();
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin != null) {
            skin.getSelectedRows().clear();
            skin.getSelectedColumns().clear();
        }
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getFocusedCell() {
        if (this.getTableView().getFocusModel() == null) {
            return new TablePosition(this.getTableView(), -1, null);
        }
        return this.cellsView.getFocusModel().getFocusedCell();
    }

    private TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> column, int offset) {
        int columnIndex = this.getTableView().getVisibleLeafIndex(column);
        int newColumnIndex = columnIndex + offset;
        return this.getTableView().getVisibleLeafColumn(newColumnIndex);
    }

    private GridViewSkin getSpreadsheetViewSkin() {
        return this.getCellsViewSkin();
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getVisibleCell(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        int firstRow;
        int modelColumn = this.cellsView.getColumns().indexOf(column);
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(row, modelColumn);
        switch (spanType) {
            case NORMAL_CELL: 
            case ROW_VISIBLE: {
                return new TablePosition((TableView)this.cellsView, row, column);
            }
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(row)).get(modelColumn);
        int n = firstRow = this.getCellsViewSkin() == null ? -1 : this.getCellsViewSkin().getFirstRow(cell, row);
        if (this.getCellsViewSkin() == null || this.getCellsViewSkin().getCellsSize() != 0 && this.getNonFixedRow(0).getIndex() <= firstRow) {
            return new TablePosition((TableView)this.cellsView, firstRow, this.cellsView.getVisibleLeafColumn(this.spreadsheetView.getViewColumn(cell.getColumn())));
        }
        GridRow gridRow = this.getNonFixedRow(0);
        return new TablePosition((TableView)this.cellsView, gridRow == null ? row : gridRow.getIndex(), this.cellsView.getVisibleLeafColumn(this.spreadsheetView.getViewColumn(cell.getColumn())));
    }

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    private GridRow getNonFixedRow(int index) {
        return this.getCellsViewSkin().getRow(index);
    }
}

