/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.parser.string;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.Operation;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.AggregatorsParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.StringConverter;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public class StringParser<T>
implements Parser<T> {
    private StringConverter<T> converter;
    private boolean caseSensitive;
    private String errorString = "";
    private final List<Operation<T, String>> operations = Arrays.asList(new BeginsWith(), new EndsWith(), new Contains(), new EqualsTo(), new NotEqualsTo());

    public StringParser() {
    }

    public StringParser(boolean caseSensitive) {
        this(caseSensitive, null);
    }

    public StringParser(boolean caseSensitive, StringConverter<T> converter) {
        this.caseSensitive = caseSensitive;
        this.converter = converter;
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Predicate<T> parse(String text) {
        this.errorString = "";
        Predicate aggregation = this.aggregate(text);
        if (aggregation == null) {
            Optional<Operation> optionalOperation = this.operations.stream().filter(opr -> text.startsWith(opr.get())).filter(opr -> text.length() > opr.length()).findFirst();
            if (optionalOperation.isPresent()) {
                Operation opr2 = optionalOperation.get();
                String trimText = this.trim(text, opr2.length());
                if (trimText.isEmpty()) {
                    return null;
                }
                return opr2.operate(trimText);
            }
            this.errorString = Localization.localize(Localization.asKey("parser.text.error.start.operator"));
            return null;
        }
        return aggregation;
    }

    @Override
    public boolean isValid(String text) {
        this.parse(text);
        return this.errorString.isEmpty();
    }

    @Override
    public String getErrorMessage() {
        return this.errorString;
    }

    private String trim(String text, int typeLength) {
        String trimmedText = text.substring(typeLength, text.length()).trim();
        if (!trimmedText.startsWith("\"")) {
            this.errorString = String.valueOf(trimmedText) + " " + Localization.localize(Localization.asKey("parser.text.error.string.start"));
        } else if (!trimmedText.endsWith("\"")) {
            this.errorString = String.valueOf(trimmedText.substring(1)) + " " + Localization.localize(Localization.asKey("parser.text.error.string.end"));
        } else if (trimmedText.length() > 2) {
            return trimmedText.substring(1, trimmedText.length() - 1);
        }
        return "";
    }

    @Override
    public List<String> operators() {
        return Stream.concat(this.operations.stream().map(Operation::get), AggregatorsParser.getStrings()).collect(Collectors.toList());
    }

    @Override
    public String getSymbol(String text) {
        return this.operations.stream().filter(op -> op.get().equals(text)).map(Operation::getSymbol).findFirst().orElse(StringParser.i18nString("symbol.default"));
    }

    private String casedString(String string) {
        return this.caseSensitive ? string : string.toUpperCase();
    }

    private static String i18nString(String key) {
        return Localization.localize(Localization.asKey("parser.text.operator." + key));
    }

    class BeginsWith
    implements Operation<T, String> {
        BeginsWith() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.beginswith");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String text) {
            if (StringParser.this.converter != null) {
                return t -> t != null && StringParser.this.casedString(StringParser.this.converter.toString(t)).startsWith(StringParser.this.casedString(text));
            }
            return t -> StringParser.this.casedString(String.valueOf(t)).startsWith(StringParser.this.casedString(text));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.beginswith." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class Contains
    implements Operation<T, String> {
        Contains() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.contains");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String text) {
            if (StringParser.this.converter != null) {
                return t -> t != null && StringParser.this.casedString(StringParser.this.converter.toString(t)).contains(StringParser.this.casedString(text));
            }
            return t -> StringParser.this.casedString(String.valueOf(t)).contains(StringParser.this.casedString(text));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.contains." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class EndsWith
    implements Operation<T, String> {
        EndsWith() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.endswith");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String text) {
            if (StringParser.this.converter != null) {
                return t -> t != null && StringParser.this.casedString(StringParser.this.converter.toString(t)).endsWith(StringParser.this.casedString(text));
            }
            return t -> StringParser.this.casedString(String.valueOf(t)).endsWith(StringParser.this.casedString(text));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.endswith." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class EqualsTo
    implements Operation<T, String> {
        EqualsTo() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.equalsto");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String text) {
            if (StringParser.this.converter != null) {
                return t -> t != null && StringParser.this.casedString(StringParser.this.converter.toString(t)).equals(StringParser.this.casedString(text));
            }
            return t -> StringParser.this.casedString(String.valueOf(t)).equals(StringParser.this.casedString(text));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.equalsto." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class NotEqualsTo
    implements Operation<T, String> {
        NotEqualsTo() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.notequalsto");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String text) {
            if (StringParser.this.converter != null) {
                return t -> t != null && !StringParser.this.casedString(StringParser.this.converter.toString(t)).equals(StringParser.this.casedString(text));
            }
            return t -> !StringParser.this.casedString(String.valueOf(t)).equals(StringParser.this.casedString(text));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.notequalsto." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }
}

