/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import java.util.function.Supplier;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import jidefx.scene.control.decoration.Decorator;
import jidefx.utils.PredefinedShapes;

public class PredefinedDecorators {
    private static PredefinedDecorators _instance = new PredefinedDecorators();

    public static PredefinedDecorators getInstance() {
        return _instance;
    }

    public static void setInstance(PredefinedDecorators instance) {
        _instance = instance;
    }

    public Supplier<Decorator<Button>> getIncreaseButtonDecoratorSupplier() {
        return new IncreaseButtonDecoratorSupplier();
    }

    public Supplier<Decorator<Button>> getDecreaseButtonDecoratorSupplier() {
        return new DecreaseButtonDecoratorSupplier();
    }

    public Supplier<Decorator<Button>> getClearButtonDecoratorSupplier() {
        return new ClearButtonDecoratorSupplier();
    }

    public Supplier<Decorator<Button>> getPopupButtonDecoratorSupplier() {
        return new PopupButtonDecoratorSupplier();
    }

    public static abstract class AbstractButtonDecoratorSupplier
    implements Supplier<Decorator<Button>> {
        private String STYLE_CLASS_DEFAULT = "no-background-button";

        public Decorator<Button> create(Node shape) {
            return new Decorator<Button>(this.createButton(shape), Pos.CENTER_RIGHT, new Point2D(-100.0, 0.0), new Insets(0.0, 100.0, 0.0, 0.0));
        }

        public Decorator<Button> create(Node shape, double width, double height) {
            return new Decorator<Button>(this.createButton(shape, width, height), Pos.CENTER_RIGHT, new Point2D(-100.0, 0.0), new Insets(0.0, 100.0, 0.0, 0.0));
        }

        protected Button createButton(Node shape) {
            return this.createButton(shape, shape.prefWidth(-1.0), shape.prefHeight(-1.0));
        }

        protected Button createButton(Node shape, double width, double height) {
            Button button = new Button();
            button.setPrefWidth(width);
            button.setPrefHeight(height);
            button.getStyleClass().addAll((Object[])new String[]{this.STYLE_CLASS_DEFAULT});
            button.setFocusTraversable(false);
            button.setPickOnBounds(true);
            button.setCursor(Cursor.DEFAULT);
            shape.setFocusTraversable(false);
            button.setGraphic(shape);
            return button;
        }
    }

    protected static class ClearButtonDecoratorSupplier
    extends AbstractButtonDecoratorSupplier {
        public static final double DEFAULT_SIZE = 12.0;

        protected ClearButtonDecoratorSupplier() {
        }

        @Override
        public Decorator<Button> get() {
            return this.create((Node)PredefinedShapes.getInstance().createClearIcon(12.0));
        }
    }

    protected static class DecreaseButtonDecoratorSupplier
    implements Supplier<Decorator<Button>> {
        private String STYLE_CLASS_DEFAULT = "decrease-button";
        public static final double DEFAULT_WIDTH = 10.0;
        public static final double DEFAULT_HEIGHT = 5.0;

        protected DecreaseButtonDecoratorSupplier() {
        }

        @Override
        public Decorator<Button> get() {
            return new Decorator<Button>(this.createButton(), Pos.CENTER_RIGHT, new Point2D(-100.0, 80.0), new Insets(0.0, 100.0, 0.0, 0.0));
        }

        public Button createButton() {
            Button button = new Button();
            button.setPrefWidth(10.0);
            button.setPrefHeight(5.0);
            button.getStyleClass().addAll((Object[])new String[]{this.STYLE_CLASS_DEFAULT});
            button.setFocusTraversable(false);
            button.setPickOnBounds(true);
            return button;
        }
    }

    protected static class IncreaseButtonDecoratorSupplier
    implements Supplier<Decorator<Button>> {
        private String STYLE_CLASS_DEFAULT = "increase-button";
        public static final double DEFAULT_WIDTH = 10.0;
        public static final double DEFAULT_HEIGHT = 5.0;

        protected IncreaseButtonDecoratorSupplier() {
        }

        @Override
        public Decorator<Button> get() {
            return new Decorator<Button>(this.createButton(), Pos.CENTER_RIGHT, new Point2D(-100.0, -80.0), new Insets(0.0, 100.0, 0.0, 0.0));
        }

        public Button createButton() {
            Button button = new Button();
            button.setPrefWidth(10.0);
            button.setPrefHeight(5.0);
            button.getStyleClass().addAll((Object[])new String[]{this.STYLE_CLASS_DEFAULT});
            button.setFocusTraversable(false);
            return button;
        }
    }

    protected static class PopupButtonDecoratorSupplier
    extends AbstractButtonDecoratorSupplier {
        public static final double DEFAULT_WIDTH = 12.0;
        public static final double DEFAULT_HEIGHT = 16.0;

        protected PopupButtonDecoratorSupplier() {
        }

        @Override
        public Decorator<Button> get() {
            return this.create((Node)PredefinedShapes.getInstance().createArrowIcon(10.0), 12.0, 16.0);
        }
    }
}

