/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.validation;

import javafx.event.Event;
import javafx.event.EventType;

public class ValidationEvent
extends Event {
    public static final EventType<ValidationEvent> ANY = new EventType(Event.ANY, "VALIDATION");
    public static final EventType<ValidationEvent> VALIDATION_OK = new EventType(ANY, "VALIDATION_OK");
    public static final EventType<ValidationEvent> VALIDATION_INFO = new EventType(ANY, "VALIDATION_INFO");
    public static final EventType<ValidationEvent> VALIDATION_WARNING = new EventType(ANY, "VALIDATION_WARNING");
    public static final EventType<ValidationEvent> VALIDATION_ERROR = new EventType(ANY, "VALIDATION_ERROR");
    public static final EventType<ValidationEvent> VALIDATION_UNKNOWN = new EventType(ANY, "VALIDATION_UNKNOWN");
    private FailBehavior _failBehavior = FailBehavior.REVERT;
    private int _id;
    private Object _proposedValue;
    private String _message;
    public static final ValidationEvent OK = new ValidationEvent(VALIDATION_OK);
    public static final ValidationEvent UNKNOWN = new ValidationEvent(VALIDATION_UNKNOWN);

    public ValidationEvent() {
        this(VALIDATION_UNKNOWN);
    }

    public ValidationEvent(EventType<ValidationEvent> type) {
        this(type, 0);
    }

    public ValidationEvent(EventType<ValidationEvent> type, int id) {
        this(type, id, "");
    }

    public ValidationEvent(EventType<ValidationEvent> type, int id, String message) {
        super(type);
        this._id = id;
        this._message = message;
        this._failBehavior = this.isIgnorableEvent() ? FailBehavior.IGNORE : FailBehavior.PERSIST;
    }

    public ValidationEvent(EventType<ValidationEvent> type, int id, FailBehavior failBehavior) {
        super(type);
        this._id = id;
        this._failBehavior = failBehavior;
    }

    public ValidationEvent(EventType<ValidationEvent> type, int id, FailBehavior failBehavior, String message) {
        super(type);
        this._id = id;
        this._failBehavior = failBehavior;
        this._message = message;
    }

    public ValidationEvent(EventType<ValidationEvent> type, int id, Object proposedValue, String message) {
        super(type);
        this._id = id;
        this._proposedValue = proposedValue;
        this._message = message;
        this._failBehavior = FailBehavior.SELF_CORRECT;
    }

    private boolean isIgnorableEvent() {
        return this.getEventType() == VALIDATION_OK || this.getEventType() == VALIDATION_INFO || this.getEventType() == VALIDATION_UNKNOWN;
    }

    public int getId() {
        return this._id;
    }

    public Object getProposedValue() {
        return this._proposedValue;
    }

    public String getMessage() {
        return this._message;
    }

    public FailBehavior getFailBehavior() {
        return this._failBehavior;
    }

    public EventType<ValidationEvent> getEventType() {
        return super.getEventType();
    }

    public String toString() {
        String properties = " eventType=" + this.getEventType() + " id=" + this.getId() + " message=" + this.getMessage() + " failBehavior=" + (Object)((Object)this.getFailBehavior());
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + properties + "]";
    }

    public static enum FailBehavior {
        REVERT,
        SELF_CORRECT,
        PERSIST,
        IGNORE;

    }
}

