/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.validation;

import com.jidefx.utils.function.TriFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Region;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.validation.ValidationDecorators;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationObject;
import jidefx.scene.control.validation.ValidationStatus;
import jidefx.scene.control.validation.Validator;
import jidefx.utils.CommonUtils;
import jidefx.utils.FXUtils;

public class ValidationUtils {
    private static final String PROPERTY_ON_DEMAND_VALIDATOR = "Validation.On.Demand.Validator";
    private static final String PROPERTY_ON_DEMAND_OBSERVABLE_VALUE = "Validation.On.Demand.ObservableValue";
    private static final String PROPERTY_ON_DEMAND_EVENT_FILTER = "Validation.On.Demand.EventFilter";
    private static final String PROPERTY_ON_DEMAND_OBJECT = "Validation.On.Demand.Object";
    private static final String PROPERTY_ON_FLY_VALIDATOR = "Validation.On.Fly.Validator";
    private static final String PROPERTY_ON_FLY_OBSERVABLE_VALUE = "Validation.On.Fly.ObservableValue";
    private static final String PROPERTY_ON_FLY_LISTENER = "Validation.On.Fly.Listener";
    private static final String PROPERTY_ON_FLY_EVENT_FILTER = "Validation.On.Fly.EventFilter";
    private static final String PROPERTY_ON_FOCUS_LOST_VALIDATOR = "Validation.On.FocusLost.Validator";
    private static final String PROPERTY_ON_FOCUS_LOST_LISTENER = "Validation.On.FocusLost.Listener";
    private static final String PROPERTY_ON_FOCUS_LOST_EVENT_FILTER = "Validation.On.FocusLost.EventFilter";
    private static final String PROPERTY_ON_FOCUS_LOST_OBJECT = "Validation.On.FocusLost.Object";
    private static final String PROPERTY_VALIDATION_RESULT = "Validation.Result";
    private static final String PROPERTY_VALIDATION_RESULT_MESSAGE = "Validation.Result.Message";
    public static final String PSEUDO_CLASS_VALIDATION_ERROR = "validation-error";
    public static final String PSEUDO_CLASS_VALIDATION_WARNING = "validation-warning";
    public static final String PSEUDO_CLASS_VALIDATION_INFO = "validation-info";
    public static final String PSEUDO_CLASS_VALIDATION_OK = "validation-ok";

    public static <T> boolean install(Node targetNode, Validator validator) {
        return ValidationUtils.install(targetNode, ValidationUtils.getDefaultObservableValue(targetNode), validator, ValidationUtils.getDefaultMode(), ValidationUtils.createDefaultValidationEventHandler(targetNode, ValidationDecorators::graphicDecoratorCreator));
    }

    public static <T> boolean install(Node targetNode, Validator validator, ValidationMode mode) {
        return ValidationUtils.install(targetNode, ValidationUtils.getDefaultObservableValue(targetNode), validator, mode, ValidationUtils.createDefaultValidationEventHandler(targetNode, ValidationDecorators::graphicDecoratorCreator));
    }

    public static <T> boolean install(Node targetNode, ObservableValue<T> observableValue, Validator validator) {
        return ValidationUtils.install(targetNode, observableValue, validator, ValidationMode.ON_FLY, ValidationUtils.createDefaultValidationEventHandler(targetNode, ValidationDecorators::graphicDecoratorCreator));
    }

    public static <T> boolean install(Node targetNode, ObservableValue<T> observableValue, Validator validator, ValidationMode mode) {
        return ValidationUtils.install(targetNode, observableValue, validator, mode, ValidationUtils.createDefaultValidationEventHandler(targetNode, ValidationDecorators::graphicDecoratorCreator));
    }

    public static <T> boolean install(Node targetNode, ObservableValue<T> observableValue, Validator validator, EventHandler<ValidationEvent> eventFilter) {
        return ValidationUtils.install(targetNode, observableValue, validator, ValidationUtils.getDefaultMode(), eventFilter);
    }

    public static <T> boolean install(Node targetNode, ObservableValue<T> observableValue, Validator validator, ValidationMode mode, EventHandler<ValidationEvent> eventFilter) {
        if (observableValue == null || validator == null) {
            return false;
        }
        switch (mode) {
            case ON_FOCUS_LOST: {
                return ValidationUtils.setOnFocusLostValidation(targetNode, validator, observableValue, eventFilter);
            }
            case ON_DEMAND: {
                return ValidationUtils.setOnDemandValidation(targetNode, validator, observableValue, eventFilter);
            }
            case ON_FLY: {
                return ValidationUtils.setOnFlyValidation(targetNode, validator, observableValue, eventFilter);
            }
        }
        return false;
    }

    public static <T> boolean install(Node targetNode, ObservableValue<T> observableValue, Validator validator, ValidationMode mode, TriFunction<Node, Decorator, ValidationEvent, Decorator<Label>> decorationCreator) {
        return ValidationUtils.install(targetNode, observableValue, validator, mode, ValidationUtils.createDefaultValidationEventHandler(targetNode, decorationCreator));
    }

    private static ObservableValue getDefaultObservableValue(Node targetNode) {
        ObservableValue observableValue = null;
        Class<?> clazz = targetNode.getClass();
        if (TextInputControl.class.isAssignableFrom(clazz)) {
            return ((TextInputControl)targetNode).textProperty();
        }
        if (ListView.class.isAssignableFrom(clazz)) {
            return ((ListView)targetNode).getSelectionModel().selectedItemProperty();
        }
        if (TreeView.class.isAssignableFrom(clazz)) {
            return ((TreeView)targetNode).getSelectionModel().selectedItemProperty();
        }
        if (TableView.class.isAssignableFrom(clazz)) {
            return ((TableView)targetNode).getSelectionModel().selectedItemProperty();
        }
        if (ComboBox.class.isAssignableFrom(clazz)) {
            return ((ComboBox)targetNode).getSelectionModel().selectedItemProperty();
        }
        if (ChoiceBox.class.isAssignableFrom(clazz)) {
            return ((ChoiceBox)targetNode).getSelectionModel().selectedItemProperty();
        }
        if (CheckBox.class.isAssignableFrom(clazz)) {
            return ((CheckBox)targetNode).selectedProperty();
        }
        if (RadioButton.class.isAssignableFrom(clazz)) {
            return ((RadioButton)targetNode).selectedProperty();
        }
        if (DatePicker.class.isAssignableFrom(clazz)) {
            return ((DatePicker)targetNode).valueProperty();
        }
        return observableValue;
    }

    private static ValidationMode getDefaultMode() {
        return ValidationMode.ON_FLY;
    }

    private static <T> boolean setOnFlyValidation(final Node targetNode, final Validator validator, ObservableValue<T> targetProperty, EventHandler<ValidationEvent> eventFilter) {
        ValidationUtils.uninstall(targetNode, ValidationMode.ON_FLY);
        ChangeListener listener = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                ValidationObject validationObject = new ValidationObject(targetNode, oldValue, newValue);
                ValidationEvent event = (ValidationEvent)((Object)validator.call(validationObject));
                targetNode.fireEvent((Event)event);
            }
        };
        targetProperty.addListener(listener);
        targetNode.addEventFilter(ValidationEvent.ANY, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_FLY_VALIDATOR, (Object)validator);
        targetNode.getProperties().put((Object)PROPERTY_ON_FLY_OBSERVABLE_VALUE, targetProperty);
        targetNode.getProperties().put((Object)PROPERTY_ON_FLY_EVENT_FILTER, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_FLY_LISTENER, (Object)listener);
        return true;
    }

    private static <T> boolean setOnFocusLostValidation(final Node targetNode, final Validator validator, final ObservableValue<T> targetProperty, EventHandler<ValidationEvent> eventFilter) {
        ValidationUtils.uninstall(targetNode, ValidationMode.ON_FOCUS_LOST);
        ChangeListener<Boolean> listener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    targetNode.getProperties().put((Object)ValidationUtils.PROPERTY_ON_FOCUS_LOST_OBJECT, targetProperty.getValue());
                } else {
                    Object newValidationValue;
                    Object oldValidationValue = targetNode.getProperties().get((Object)ValidationUtils.PROPERTY_ON_FOCUS_LOST_OBJECT);
                    if (!CommonUtils.equals(oldValidationValue, newValidationValue = targetProperty.getValue())) {
                        ValidationObject validationObject = new ValidationObject(targetNode, oldValidationValue, newValidationValue);
                        ValidationEvent event = (ValidationEvent)((Object)validator.call(validationObject));
                        targetNode.fireEvent((Event)event);
                    }
                }
            }
        };
        targetNode.focusedProperty().addListener((ChangeListener)listener);
        targetNode.addEventFilter(ValidationEvent.ANY, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_FOCUS_LOST_VALIDATOR, (Object)validator);
        targetNode.getProperties().put((Object)PROPERTY_ON_FOCUS_LOST_EVENT_FILTER, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_FOCUS_LOST_LISTENER, (Object)listener);
        targetNode.getProperties().put((Object)PROPERTY_ON_FOCUS_LOST_OBJECT, targetProperty.getValue());
        return true;
    }

    private static <T> boolean setOnDemandValidation(Node targetNode, Validator validator, ObservableValue<T> targetProperty, EventHandler<ValidationEvent> eventFilter) {
        ValidationUtils.uninstall(targetNode, ValidationMode.ON_DEMAND);
        targetNode.addEventFilter(ValidationEvent.ANY, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_DEMAND_VALIDATOR, (Object)validator);
        targetNode.getProperties().put((Object)PROPERTY_ON_DEMAND_OBSERVABLE_VALUE, targetProperty);
        targetNode.getProperties().put((Object)PROPERTY_ON_DEMAND_EVENT_FILTER, eventFilter);
        targetNode.getProperties().put((Object)PROPERTY_ON_DEMAND_OBJECT, targetProperty.getValue());
        return true;
    }

    public static boolean uninstall(Node targetNode) {
        return ValidationUtils.uninstall(targetNode, ValidationMode.ON_FLY) && ValidationUtils.uninstall(targetNode, ValidationMode.ON_FOCUS_LOST) && ValidationUtils.uninstall(targetNode, ValidationMode.ON_DEMAND);
    }

    public static boolean uninstall(Node targetNode, ValidationMode mode) {
        if (targetNode == null) {
            return false;
        }
        ValidationMode removeMode = mode;
        if (removeMode == null) {
            removeMode = ValidationUtils.getDefaultMode();
        }
        switch (removeMode) {
            case ON_DEMAND: {
                Object remove;
                Object eventFilter = targetNode.getProperties().get((Object)PROPERTY_ON_DEMAND_EVENT_FILTER);
                if (eventFilter instanceof EventHandler) {
                    targetNode.removeEventFilter(ValidationEvent.ANY, (EventHandler)eventFilter);
                }
                if ((remove = targetNode.getProperties().remove((Object)PROPERTY_ON_DEMAND_VALIDATOR)) != null) {
                    targetNode.getProperties().remove((Object)PROPERTY_ON_DEMAND_OBSERVABLE_VALUE);
                    targetNode.getProperties().remove((Object)PROPERTY_ON_DEMAND_EVENT_FILTER);
                    break;
                }
                return false;
            }
            case ON_FOCUS_LOST: {
                Object remove;
                Object eventFilter = targetNode.getProperties().get((Object)PROPERTY_ON_FOCUS_LOST_EVENT_FILTER);
                if (eventFilter instanceof EventHandler) {
                    targetNode.removeEventFilter(ValidationEvent.ANY, (EventHandler)eventFilter);
                }
                if ((remove = targetNode.getProperties().remove((Object)PROPERTY_ON_FOCUS_LOST_VALIDATOR)) != null) {
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FOCUS_LOST_LISTENER);
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FOCUS_LOST_EVENT_FILTER);
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FOCUS_LOST_OBJECT);
                    Object listener = targetNode.getProperties().get((Object)PROPERTY_ON_FOCUS_LOST_LISTENER);
                    if (listener instanceof ChangeListener) {
                        targetNode.focusedProperty().removeListener((ChangeListener)listener);
                        break;
                    }
                    return false;
                }
                return false;
            }
            default: {
                Object eventFilter = targetNode.getProperties().get((Object)PROPERTY_ON_FLY_EVENT_FILTER);
                if (eventFilter instanceof EventHandler) {
                    targetNode.removeEventFilter(ValidationEvent.ANY, (EventHandler)eventFilter);
                }
                DecorationUtils.uninstall(targetNode);
                Object remove = targetNode.getProperties().remove((Object)PROPERTY_ON_FLY_VALIDATOR);
                if (remove != null) {
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FLY_OBSERVABLE_VALUE);
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FLY_LISTENER);
                    targetNode.getProperties().remove((Object)PROPERTY_ON_FLY_EVENT_FILTER);
                    targetNode.getProperties().remove((Object)PROPERTY_VALIDATION_RESULT);
                    targetNode.getProperties().remove((Object)PROPERTY_VALIDATION_RESULT_MESSAGE);
                    Object onFlyValue = targetNode.getProperties().get((Object)PROPERTY_ON_FLY_OBSERVABLE_VALUE);
                    Object onFlyListener = targetNode.getProperties().get((Object)PROPERTY_ON_FLY_LISTENER);
                    if (onFlyValue instanceof ObservableValue && onFlyListener instanceof ChangeListener) {
                        ((ObservableValue)onFlyValue).removeListener((ChangeListener)onFlyListener);
                        break;
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static void forceValidate(Node validateNode, ValidationMode mode) {
        switch (mode) {
            case ON_FLY: {
                Object validator = validateNode.getProperties().get((Object)PROPERTY_ON_FLY_VALIDATOR);
                ObservableValue observableValue = (ObservableValue)validateNode.getProperties().get((Object)PROPERTY_ON_FLY_OBSERVABLE_VALUE);
                if (!(validator instanceof Validator)) break;
                ValidationObject object = new ValidationObject(validateNode, null, observableValue.getValue());
                ValidationEvent event = (ValidationEvent)((Object)((Validator)validator).call(object));
                validateNode.fireEvent((Event)event);
                break;
            }
            case ON_FOCUS_LOST: {
                Object validator = validateNode.getProperties().get((Object)PROPERTY_ON_FLY_VALIDATOR);
                ObservableValue observableValue = (ObservableValue)validateNode.getProperties().get((Object)PROPERTY_ON_FOCUS_LOST_OBJECT);
                if (!(validator instanceof Validator)) break;
                ValidationObject object = new ValidationObject(validateNode, null, observableValue);
                ValidationEvent event = (ValidationEvent)((Object)((Validator)validator).call(object));
                validateNode.fireEvent((Event)event);
            }
        }
    }

    public static boolean validateOnDemand(Node targetRegionOrNode) {
        if (targetRegionOrNode == null) {
            return false;
        }
        final ArrayList nodes = new ArrayList();
        FXUtils.setRecursively(targetRegionOrNode, new FXUtils.Handler<Node>(){

            @Override
            public boolean condition(Node c) {
                return c.getProperties().get((Object)ValidationUtils.PROPERTY_ON_DEMAND_VALIDATOR) instanceof Validator;
            }

            @Override
            public void action(Node c) {
                nodes.add(c);
            }
        });
        boolean valid = true;
        for (Node validateNode : nodes) {
            ObservableMap properties = validateNode.getProperties();
            if (!(properties.get((Object)PROPERTY_ON_DEMAND_VALIDATOR) instanceof Validator) || !(properties.get((Object)PROPERTY_ON_DEMAND_OBSERVABLE_VALUE) instanceof ObservableValue)) continue;
            Validator validator = (Validator)properties.get((Object)PROPERTY_ON_DEMAND_VALIDATOR);
            ObservableValue observableValue = (ObservableValue)properties.get((Object)PROPERTY_ON_DEMAND_OBSERVABLE_VALUE);
            Object oldValue = properties.get((Object)PROPERTY_ON_DEMAND_OBJECT);
            ValidationObject object = new ValidationObject(validateNode, oldValue, observableValue.getValue());
            ValidationEvent event = (ValidationEvent)((Object)validator.call(object));
            validateNode.fireEvent((Event)event);
            if (ValidationEvent.VALIDATION_ERROR.equals(event.getEventType())) {
                valid = false;
                continue;
            }
            properties.put((Object)PROPERTY_ON_DEMAND_OBJECT, (Object)object);
        }
        if (targetRegionOrNode instanceof Region) {
            ((Region)targetRegionOrNode).requestLayout();
        }
        return valid;
    }

    public static boolean isValidationDecorator(Decorator decorator) {
        Label validationLabel;
        long count;
        Node _node;
        return Optional.of(decorator.getNode()).isPresent() && (_node = (Node)Optional.of(decorator.getNode()).get()) instanceof Label && (count = (validationLabel = (Label)_node).getStyleClass().stream().filter(styleClass -> styleClass.equals("validation-decorator")).count()) > 0L;
    }

    public static Optional<List<Decorator>> getValidationDecorators(Node node) {
        if (Optional.ofNullable(DecorationUtils.getDecorators(node)).isPresent()) {
            Object o = Optional.of(DecorationUtils.getDecorators(node)).get();
            if (o instanceof Decorator) {
                if (ValidationUtils.isValidationDecorator((Decorator)o)) {
                    return Optional.of(new ArrayList<Decorator>(o){
                        {
                            this.add((Decorator)object);
                        }
                    });
                }
            } else if (o instanceof Decorator[]) {
                Decorator[] decorators = (Decorator[])o;
                ArrayList<Decorator> validationLabels = new ArrayList<Decorator>();
                int i = 0;
                while (i < decorators.length) {
                    Decorator d = decorators[i];
                    if (ValidationUtils.isValidationDecorator(d)) {
                        validationLabels.add(d);
                    }
                    ++i;
                }
                return Optional.of(validationLabels);
            }
        }
        return Optional.empty();
    }

    public static void showTooltip(Label label) {
        if (label != null && label.getTooltip() != null) {
            Point2D point = label.localToScene(15.0, 15.0);
            label.getTooltip().setAutoHide(true);
            label.getTooltip().show(label.getScene().getWindow(), point.getX() + label.getScene().getX() + label.getScene().getWindow().getX(), point.getY() + label.getScene().getY() + label.getScene().getWindow().getY());
        }
    }

    public static EventHandler<ValidationEvent> createDefaultValidationEventHandler(final Node targetNode, final TriFunction<Node, Decorator, ValidationEvent, Decorator<Label>> decorationCreator) {
        return new EventHandler<ValidationEvent>(){
            Decorator resultDecorator = null;

            public void handle(ValidationEvent event) {
                if (event != null) {
                    ValidationUtils.adjustValidationPseudoClasses(event, targetNode);
                    if (event.getEventType().equals(ValidationEvent.VALIDATION_UNKNOWN)) {
                        DecorationUtils.uninstall(targetNode);
                        this.resultDecorator = null;
                        targetNode.getParent().requestLayout();
                        return;
                    }
                    if (targetNode instanceof Cell && event.getEventType().equals(ValidationEvent.VALIDATION_OK)) {
                        return;
                    }
                    Object validationResultProperty = targetNode.getProperties().get((Object)ValidationUtils.PROPERTY_VALIDATION_RESULT);
                    Object validationResultMessageProperty = targetNode.getProperties().get((Object)ValidationUtils.PROPERTY_VALIDATION_RESULT_MESSAGE);
                    if (validationResultProperty != null && validationResultProperty.equals(event.getEventType().getName()) && validationResultMessageProperty != null && validationResultMessageProperty.equals(event.getMessage())) {
                        return;
                    }
                    this.resultDecorator = (Decorator)decorationCreator.apply(targetNode, this.resultDecorator, event);
                    ValidationUtils.adjustValidationPseudoClasses(event, this.resultDecorator.getNode());
                    targetNode.getProperties().put((Object)ValidationUtils.PROPERTY_VALIDATION_RESULT, (Object)event.getEventType().getName());
                    targetNode.getProperties().put((Object)ValidationUtils.PROPERTY_VALIDATION_RESULT_MESSAGE, (Object)event.getMessage());
                }
            }
        };
    }

    private static void adjustValidationPseudoClasses(ValidationEvent event, Node targetNode) {
        if (event.getEventType() == ValidationEvent.VALIDATION_OK) {
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_OK), true);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_INFO), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_WARNING), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_ERROR), false);
        } else if (event.getEventType() == ValidationEvent.VALIDATION_ERROR) {
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_OK), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_INFO), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_WARNING), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_ERROR), true);
        } else if (event.getEventType() == ValidationEvent.VALIDATION_WARNING) {
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_OK), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_INFO), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_WARNING), true);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_ERROR), false);
        } else if (event.getEventType() == ValidationEvent.VALIDATION_INFO) {
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_OK), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_INFO), true);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_WARNING), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_ERROR), false);
        } else {
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_OK), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_INFO), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_WARNING), false);
            targetNode.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)PSEUDO_CLASS_VALIDATION_ERROR), false);
        }
    }

    public static ValidationStatus getValidationStatus(Node targetNode) {
        ValidationStatus status = ValidationStatus.VALIDATION_UNKNOWN;
        Object validationResult = targetNode.getProperties().get((Object)PROPERTY_VALIDATION_RESULT);
        if (validationResult != null) {
            String validationResultName = validationResult.toString();
            if (validationResultName.equals(ValidationEvent.VALIDATION_ERROR.getName())) {
                status = ValidationStatus.VALIDATION_ERROR;
            } else if (validationResultName.equals(ValidationEvent.VALIDATION_INFO.getName())) {
                status = ValidationStatus.VALIDATION_INFO;
            } else if (validationResultName.equals(ValidationEvent.VALIDATION_OK.getName())) {
                status = ValidationStatus.VALIDATION_OK;
            } else if (validationResultName.equals(ValidationEvent.VALIDATION_UNKNOWN.getName())) {
                status = ValidationStatus.VALIDATION_UNKNOWN;
            } else if (validationResultName.equals(ValidationEvent.VALIDATION_WARNING.getName())) {
                status = ValidationStatus.VALIDATION_WARNING;
            }
        }
        return status;
    }

    public static class TooltipFix
    extends Tooltip {
        private Node parentNode;

        public TooltipFix(Node parentNode) {
            this.parentNode = parentNode;
        }

        public Styleable getStyleableParent() {
            Styleable styleableParent = super.getStyleableParent();
            if (styleableParent != null) {
                return styleableParent;
            }
            return this.parentNode;
        }
    }
}

