/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class CommonUtils {
    public static boolean equals(Object o1, Object o2) {
        return CommonUtils.equals(o1, o2, false);
    }

    public static boolean equals(Object o1, Object o2, boolean considerArrayOrList) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return CommonUtils.equals((CharSequence)o1, (CharSequence)o2, true);
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o2.getClass().isAssignableFrom(o1.getClass())) {
            return ((Comparable)o2).compareTo(o1) == 0;
        }
        if (considerArrayOrList && o1 instanceof List && o2 instanceof List) {
            int length2;
            int length1 = ((List)o1).size();
            if (length1 != (length2 = ((List)o2).size())) {
                return false;
            }
            int i = 0;
            while (i < length1) {
                if (!CommonUtils.equals(((List)o1).get(i), ((List)o2).get(i), true)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (considerArrayOrList && o1.getClass().isArray() && o2.getClass().isArray()) {
            int length2;
            int length1 = Array.getLength(o1);
            if (length1 != (length2 = Array.getLength(o2))) {
                return false;
            }
            int i = 0;
            while (i < length1) {
                if (!CommonUtils.equals(Array.get(o1, i), Array.get(o2, i), true)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static boolean equals(CharSequence s1, CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int to = 0;
        int po = 0;
        int len = s1.length();
        while (len-- > 0) {
            char c2;
            char c1;
            if ((c1 = s1.charAt(to++)) == (c2 = s2.charAt(po++)) || !caseSensitive && CommonUtils.charsEqualIgnoreCase(c1, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || CommonUtils.toUpperCase(a) == CommonUtils.toUpperCase(b) || CommonUtils.toLowerCase(a) == CommonUtils.toLowerCase(b);
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a >= 'a' && a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a >= 'A' && a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    public static void ignoreException(Exception e) {
    }

    public static void printException(Exception e) {
        System.err.println(e.getLocalizedMessage());
    }

    public static void throwException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static void throwInvocationTargetException(InvocationTargetException e) {
        if (e.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)e.getTargetException();
        }
        if (e.getTargetException() instanceof Error) {
            throw (Error)e.getTargetException();
        }
        throw new RuntimeException(e.getTargetException());
    }

    public static int binarySearch(List<Object> a, Object key) {
        int x1 = 0;
        int x2 = a.size();
        int i = x2 / 2;
        while (x1 < x2) {
            if (!(a.get(i) instanceof Comparable)) {
                return i;
            }
            int c = ((Comparable)a.get(i)).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * i;
    }

    public static int binarySearch(Object[] a, Object key) {
        int x1 = 0;
        int x2 = a.length;
        int i = x2 / 2;
        while (x1 < x2) {
            if (!(a[i] instanceof Comparable)) {
                return i;
            }
            int c = ((Comparable)a[i]).compareTo(key);
            if (c == 0) {
                return i;
            }
            if (c < 0) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * i;
    }

    public static int binarySearch(int[] a, int key) {
        return CommonUtils.binarySearch(a, key, 0, a.length);
    }

    public static int binarySearch(int[] a, int key, int start, int end) {
        int x1 = start;
        int x2 = end;
        int i = x2 / 2;
        while (x1 < x2) {
            if (a[i] == key) {
                return i;
            }
            if (a[i] < key) {
                x1 = i + 1;
            } else {
                x2 = i;
            }
            i = x1 + (x2 - x1) / 2;
        }
        return -1 * i;
    }

    public static <T, U> Comparator<T> comparing(final Comparator<? super U> comparator, final Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(comparator);
        Objects.requireNonNull(keyExtractor);
        return new Comparator<T>(){

            @Override
            public int compare(T c1, T c2) {
                return comparator.compare(keyExtractor.apply(c1), keyExtractor.apply(c2));
            }
        };
    }
}

