/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class LazyLoadUtils {
    private static final double DELAY = 200.0;
    private static final String PROPERTY_TASK = "LazyLoadUtils.Task";

    public static <T> void install(ComboBox<T> comboBox, Callback<ComboBox<T>, ObservableList<T>> callback) {
        LazyLoadUtils.install(comboBox, callback, Duration.millis((double)200.0), true, null);
    }

    public static <T> void install(ComboBox<T> comboBox, Callback<ComboBox<T>, ObservableList<T>> callback, Duration delay) {
        LazyLoadUtils.install(comboBox, callback, delay, true, null);
    }

    public static <T> void install(ComboBox<T> comboBox, Callback<ComboBox<T>, ObservableList<T>> callback, boolean beforeShowing) {
        LazyLoadUtils.install(comboBox, callback, Duration.millis((double)200.0), beforeShowing, null);
    }

    public static <T> void install(ComboBox<T> comboBox, Callback<ComboBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing) {
        LazyLoadUtils.customizeComboBox(comboBox, callback, delay, beforeShowing, null);
    }

    public static <T> void install(ComboBox<T> comboBox, Callback<ComboBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing, T initialValue) {
        LazyLoadUtils.customizeComboBox(comboBox, callback, delay, beforeShowing, initialValue);
    }

    protected static <T> void customizeComboBox(final ComboBox<T> comboBox, final Callback<ComboBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing, T initialValue) {
        Task oldTask = LazyLoadUtils.getTask(comboBox);
        if (oldTask != null) {
            oldTask.cancel(true);
        }
        if (initialValue != null) {
            comboBox.setValue(initialValue);
        }
        final Task task = new Task<ObservableList<T>>(){

            protected ObservableList<T> call() throws Exception {
                return (ObservableList)callback.call((Object)comboBox);
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                Object item = comboBox.getValue();
                Object value = event.getSource().getValue();
                if (value instanceof ObservableList) {
                    comboBox.setItems((ObservableList)value);
                    if (item == null || !((ObservableList)value).contains(item)) {
                        comboBox.setValue(null);
                        comboBox.getSelectionModel().select(0);
                    } else {
                        comboBox.setValue(null);
                        comboBox.setValue(item);
                    }
                }
            }
        });
        if (beforeShowing) {
            comboBox.setOnShowing((EventHandler)new EventHandler<Event>(){

                public void handle(Event event) {
                    if (!task.isRunning() && !task.isDone()) {
                        task.run();
                    }
                    comboBox.setOnShowing(null);
                }
            });
        }
        LazyLoadUtils.startTimer(delay, task);
        LazyLoadUtils.putTask(comboBox, task);
    }

    public static <T> void install(ChoiceBox<T> choiceBox, Callback<ChoiceBox<T>, ObservableList<T>> callback) {
        LazyLoadUtils.install(choiceBox, callback, Duration.millis((double)200.0), true, null);
    }

    public static <T> void install(ChoiceBox<T> choiceBox, Callback<ChoiceBox<T>, ObservableList<T>> callback, Duration delay) {
        LazyLoadUtils.install(choiceBox, callback, delay, true, null);
    }

    public static <T> void install(ChoiceBox<T> choiceBox, Callback<ChoiceBox<T>, ObservableList<T>> callback, boolean beforeShowing) {
        LazyLoadUtils.install(choiceBox, callback, Duration.millis((double)200.0), beforeShowing, null);
    }

    public static <T> void install(ChoiceBox<T> choiceBox, Callback<ChoiceBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing) {
        LazyLoadUtils.customizeChoiceBox(choiceBox, callback, delay, beforeShowing, null);
    }

    public static <T> void install(ChoiceBox<T> choiceBox, Callback<ChoiceBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing, T initialValue) {
        LazyLoadUtils.customizeChoiceBox(choiceBox, callback, delay, beforeShowing, initialValue);
    }

    protected static <T> void customizeChoiceBox(final ChoiceBox<T> choiceBox, final Callback<ChoiceBox<T>, ObservableList<T>> callback, Duration delay, boolean beforeShowing, T initialValue) {
        Task oldTask = LazyLoadUtils.getTask(choiceBox);
        if (oldTask != null) {
            oldTask.cancel(true);
        }
        if (initialValue != null) {
            choiceBox.setValue(initialValue);
        }
        final Task task = new Task<ObservableList<T>>(){

            protected ObservableList<T> call() throws Exception {
                return (ObservableList)callback.call((Object)choiceBox);
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                Object item = choiceBox.getValue();
                Object value = event.getSource().getValue();
                if (value instanceof ObservableList) {
                    choiceBox.setItems((ObservableList)value);
                    if (item == null || !((ObservableList)value).contains(item)) {
                        choiceBox.setValue(null);
                        choiceBox.getSelectionModel().select(0);
                    } else {
                        choiceBox.setValue(null);
                        choiceBox.setValue(item);
                    }
                }
            }
        });
        if (beforeShowing) {
            choiceBox.setOnContextMenuRequested((EventHandler)new EventHandler<Event>(){

                public void handle(Event event) {
                    if (!task.isRunning() && !task.isDone()) {
                        task.run();
                    }
                    choiceBox.setOnContextMenuRequested(null);
                }
            });
        }
        LazyLoadUtils.startTimer(delay, task);
        LazyLoadUtils.putTask(choiceBox, task);
    }

    private static <T> void startTimer(Duration delay, final Task<ObservableList<T>> task) {
        if (delay != null && !delay.isIndefinite()) {
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(delay, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    if (!task.isRunning() && !task.isDone()) {
                        new Thread((Runnable)task).start();
                    }
                }
            }, new KeyValue[0]));
            timeline.play();
        }
    }

    private static Task getTask(Node node) {
        Object task = node.getProperties().get((Object)PROPERTY_TASK);
        if (task instanceof Task) {
            return (Task)task;
        }
        return null;
    }

    private static void putTask(Node node, Task task) {
        node.getProperties().put((Object)PROPERTY_TASK, (Object)task);
    }
}

