/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation.decoration;

import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.decoration.ValidationDecoration;

public abstract class AbstractValidationDecoration
implements ValidationDecoration {
    private static final String VALIDATION_DECORATION = "$org.controlsfx.decoration.vaidation$";

    private static boolean isValidationDecoration(Decoration decoration) {
        return decoration != null && decoration.getProperties().get(VALIDATION_DECORATION) == Boolean.TRUE;
    }

    private static void setValidationDecoration(Decoration decoration) {
        if (decoration != null) {
            decoration.getProperties().put(VALIDATION_DECORATION, Boolean.TRUE);
        }
    }

    protected abstract Collection<Decoration> createValidationDecorations(ValidationMessage var1);

    protected abstract Collection<Decoration> createRequiredDecorations(Control var1);

    @Override
    public void removeDecorations(Control target) {
        ObservableList<Decoration> decorations = Decorator.getDecorations((Node)target);
        if (decorations != null) {
            Decoration[] decorationArray = (Decoration[])Decorator.getDecorations((Node)target).toArray((Object[])new Decoration[0]);
            int n = decorationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Decoration d = decorationArray[n2];
                if (AbstractValidationDecoration.isValidationDecoration(d)) {
                    Decorator.removeDecoration((Node)target, d);
                }
                ++n2;
            }
        }
    }

    @Override
    public void applyValidationDecoration(ValidationMessage message) {
        this.createValidationDecorations(message).stream().forEach(d -> this.decorate(message.getTarget(), (Decoration)d));
    }

    @Override
    public void applyRequiredDecoration(Control target) {
        if (ValidationSupport.isRequired(target)) {
            this.createRequiredDecorations(target).stream().forEach(d -> this.decorate(target, (Decoration)d));
        }
    }

    private void decorate(Control target, Decoration d) {
        AbstractValidationDecoration.setValidationDecoration(d);
        Decorator.addDecoration((Node)target, d);
    }
}

