/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.BrowseHelper;
import org.eclipse.milo.opcua.sdk.client.NodeCache;
import org.eclipse.milo.opcua.sdk.client.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.client.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaViewNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.BuiltinReferenceType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressSpace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NodeCache nodeCache = new NodeCache();
    private BrowseOptions browseOptions = new BrowseOptions();
    private final OpcUaClient client;

    public AddressSpace(OpcUaClient client) {
        this.client = client;
    }

    public UaNode getNode(NodeId nodeId) throws UaException {
        try {
            return this.getNodeAsync(nodeId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends UaNode> getNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode != null) {
            return CompletableFuture.completedFuture(cachedNode);
        }
        return this.createNode(nodeId).whenComplete((node, ex) -> {
            if (node != null) {
                this.nodeCache.put(nodeId, (UaNode)node);
            }
        });
    }

    public UaObjectNode getObjectNode(NodeId nodeId) throws UaException {
        try {
            return this.getObjectNodeAsync(nodeId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaObjectNode getObjectNode(NodeId nodeId, NodeId typeDefinitionId) throws UaException {
        try {
            return this.getObjectNodeAsync(nodeId, typeDefinitionId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<UaObjectNode> getObjectNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaObjectNode) {
            return CompletableFuture.completedFuture((UaObjectNode)cachedNode);
        }
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return typeDefinitionFuture.thenCompose(typeDefinitionId -> this.getObjectNodeAsync(nodeId, (NodeId)typeDefinitionId));
    }

    public CompletableFuture<UaObjectNode> getObjectNodeAsync(NodeId nodeId, NodeId typeDefinitionId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaObjectNode) {
            return CompletableFuture.completedFuture((UaObjectNode)cachedNode);
        }
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, (Set<AttributeId>)AttributeId.OBJECT_ATTRIBUTES);
        return future.thenCompose(response -> {
            List attributeValues = ConversionUtil.l((Object[])response.getResults());
            try {
                UaObjectNode node = this.newObjectNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    public UaVariableNode getVariableNode(NodeId nodeId) throws UaException {
        try {
            return this.getVariableNodeAsync(nodeId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public UaVariableNode getVariableNode(NodeId nodeId, NodeId typeDefinitionId) throws UaException {
        try {
            return this.getVariableNodeAsync(nodeId, typeDefinitionId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<UaVariableNode> getVariableNodeAsync(NodeId nodeId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaVariableNode) {
            return CompletableFuture.completedFuture((UaVariableNode)cachedNode);
        }
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return typeDefinitionFuture.thenCompose(typeDefinitionId -> this.getVariableNodeAsync(nodeId, (NodeId)typeDefinitionId));
    }

    public CompletableFuture<UaVariableNode> getVariableNodeAsync(NodeId nodeId, NodeId typeDefinitionId) {
        UaNode cachedNode = this.nodeCache.getIfPresent(nodeId);
        if (cachedNode instanceof UaVariableNode) {
            return CompletableFuture.completedFuture((UaVariableNode)cachedNode);
        }
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, (Set<AttributeId>)AttributeId.VARIABLE_ATTRIBUTES);
        return future.thenCompose(response -> {
            List attributeValues = ConversionUtil.l((Object[])response.getResults());
            try {
                UaVariableNode node = this.newVariableNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    public List<ReferenceDescription> browse(UaNode node) throws UaException {
        return this.browse(node, this.getBrowseOptions());
    }

    public List<ReferenceDescription> browse(UaNode node, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseAsync(node, browseOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public List<ReferenceDescription> browse(NodeId nodeId) throws UaException {
        return this.browse(nodeId, this.getBrowseOptions());
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseAsync(nodeId, browseOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(UaNode node) {
        return this.browseAsync(node.getNodeId(), this.getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(UaNode node, BrowseOptions browseOptions) {
        return this.browseAsync(node.getNodeId(), browseOptions);
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(NodeId nodeId) {
        return this.browseAsync(nodeId, this.getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(NodeId nodeId, BrowseOptions browseOptions) {
        BrowseDescription browseDescription = new BrowseDescription(nodeId, browseOptions.getBrowseDirection(), browseOptions.getReferenceTypeId(), Boolean.valueOf(browseOptions.isIncludeSubtypes()), browseOptions.getNodeClassMask(), Unsigned.uint((int)BrowseResultMask.All.getValue()));
        return BrowseHelper.browse(this.client, browseDescription, browseOptions.getMaxReferencesPerNode());
    }

    public List<? extends UaNode> browseNodes(UaNode node) throws UaException {
        return this.browseNodes(node, this.getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(UaNode node, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseNodesAsync(node, browseOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public List<? extends UaNode> browseNodes(NodeId nodeId) throws UaException {
        return this.browseNodes(nodeId, this.getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(NodeId nodeId, BrowseOptions browseOptions) throws UaException {
        try {
            return this.browseNodesAsync(nodeId, browseOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(UaNode node) {
        return this.browseNodesAsync(node.getNodeId());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(UaNode node, BrowseOptions browseOptions) {
        return this.browseNodesAsync(node.getNodeId(), browseOptions);
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(NodeId nodeId) {
        return this.browseNodesAsync(nodeId, this.getBrowseOptions());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(NodeId nodeId, BrowseOptions browseOptions) {
        BrowseDescription browseDescription = new BrowseDescription(nodeId, browseOptions.getBrowseDirection(), browseOptions.getReferenceTypeId(), Boolean.valueOf(browseOptions.isIncludeSubtypes()), browseOptions.getNodeClassMask(), Unsigned.uint((int)BrowseResultMask.All.getValue()));
        CompletableFuture<List<ReferenceDescription>> browse = BrowseHelper.browse(this.client, browseDescription, browseOptions.getMaxReferencesPerNode());
        return browse.thenCompose(references -> {
            List<CompletableFuture<? extends UaNode>> cfs = references.stream().map(reference -> {
                NodeClass nodeClass = reference.getNodeClass();
                ExpandedNodeId xNodeId = reference.getNodeId();
                ExpandedNodeId xTypeDefinitionId = reference.getTypeDefinition();
                switch (nodeClass) {
                    case Object: 
                    case Variable: {
                        CompletionStage ff = this.toNodeIdAsync(xNodeId).thenCombine(this.toNodeIdAsync(xTypeDefinitionId), (targetNodeId, typeDefinitionId) -> {
                            if (nodeClass == NodeClass.Object) {
                                return this.getObjectNodeAsync((NodeId)targetNodeId, (NodeId)typeDefinitionId);
                            }
                            return this.getVariableNodeAsync((NodeId)targetNodeId, (NodeId)typeDefinitionId);
                        });
                        return AddressSpace.unwrap((CompletableFuture<CompletableFuture<? extends UaNode>>)ff).exceptionally(ex -> {
                            this.logger.warn("Failed to create Node from Reference to {}", (Object)reference.getNodeId(), ex);
                            return null;
                        });
                    }
                }
                return ((CompletableFuture)this.toNodeIdAsync(xNodeId).thenCompose(this::getNodeAsync)).exceptionally(ex -> {
                    this.logger.warn("Failed to create Node from Reference to {}", (Object)reference.getNodeId(), ex);
                    return null;
                });
            }).collect(Collectors.toList());
            return AddressSpace.sequence(cfs);
        });
    }

    private static CompletableFuture<List<? extends UaNode>> sequence(List<CompletableFuture<? extends UaNode>> cfs) {
        if (cfs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] fa = cfs.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(fa).thenApply(v -> {
            ArrayList<UaNode> results = new ArrayList<UaNode>(cfs.size());
            for (CompletableFuture cf : cfs) {
                UaNode node = (UaNode)cf.join();
                if (node == null) continue;
                results.add(node);
            }
            return results;
        });
    }

    private static CompletableFuture<? extends UaNode> unwrap(CompletableFuture<CompletableFuture<? extends UaNode>> future) {
        return future.thenCompose(node -> node);
    }

    public NodeId toNodeId(ExpandedNodeId xni) {
        try {
            return this.toNodeIdAsync(xni).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return NodeId.NULL_VALUE;
        }
    }

    public CompletableFuture<NodeId> toNodeIdAsync(ExpandedNodeId xni) {
        if (xni.isLocal()) {
            Optional local = xni.toNodeId(this.client.getNamespaceTable());
            return local.map(CompletableFuture::completedFuture).orElse((CompletableFuture)((CompletableFuture)this.client.readNamespaceTableAsync().thenCompose(namespaceTable -> CompletableFuture.completedFuture(xni.toNodeId(namespaceTable).orElse(NodeId.NULL_VALUE)))).exceptionally(e -> NodeId.NULL_VALUE));
        }
        return CompletableFuture.completedFuture(NodeId.NULL_VALUE);
    }

    public synchronized BrowseOptions getBrowseOptions() {
        return this.browseOptions;
    }

    public synchronized void modifyBrowseOptions(Consumer<BrowseOptions.Builder> builderConsumer) {
        BrowseOptions.Builder builder = new BrowseOptions.Builder(this.browseOptions);
        builderConsumer.accept(builder);
        this.setBrowseOptions(builder.build());
    }

    public synchronized void setBrowseOptions(BrowseOptions browseOptions) {
        this.browseOptions = browseOptions;
    }

    public synchronized NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public synchronized void setNodeCache(NodeCache nodeCache) {
        this.nodeCache = nodeCache;
    }

    private CompletableFuture<NodeId> readTypeDefinition(NodeId nodeId) {
        CompletableFuture<BrowseResult> browseFuture = this.client.browse(new BrowseDescription(nodeId, BrowseDirection.Forward, Identifiers.HasTypeDefinition, Boolean.valueOf(false), Unsigned.uint((int)(NodeClass.ObjectType.getValue() | NodeClass.VariableType.getValue())), Unsigned.uint((int)BrowseResultMask.All.getValue())));
        return browseFuture.thenCompose(result -> {
            if (result.getStatusCode().isGood()) {
                Optional<ExpandedNodeId> typeDefinitionId = ConversionUtil.l((Object[])result.getReferences()).stream().filter(r -> Objects.equals(Identifiers.HasTypeDefinition, r.getReferenceTypeId())).map(ReferenceDescription::getNodeId).findFirst();
                return typeDefinitionId.map(this::toNodeIdAsync).orElse(CompletableFuture.completedFuture(NodeId.NULL_VALUE));
            }
            return CompletableFuture.completedFuture(NodeId.NULL_VALUE);
        });
    }

    private CompletableFuture<? extends UaNode> createNode(NodeId nodeId) {
        CompletableFuture<ReadResponse> future = this.readAttributes(nodeId, (Set<AttributeId>)AttributeId.BASE_ATTRIBUTES);
        return future.thenCompose(response -> {
            List results = ConversionUtil.l((Object[])response.getResults());
            return this.createNodeFromBaseAttributes(nodeId, results);
        });
    }

    private CompletableFuture<? extends UaNode> createNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        StatusCode nodeIdStatusCode = baseAttributeValues.get(0).getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            return FutureUtils.failedUaFuture((StatusCode)nodeIdStatusCode);
        }
        Integer nodeClassValue = (Integer)baseAttributeValues.get(1).getValue().getValue();
        if (nodeClassValue == null) {
            return FutureUtils.failedUaFuture((long)2153709568L);
        }
        NodeClass nodeClass = NodeClass.from((int)nodeClassValue);
        if (nodeClass == null) {
            return FutureUtils.failedUaFuture((long)2153709568L);
        }
        switch (nodeClass) {
            case DataType: {
                return this.createDataTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Method: {
                return this.createMethodNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Object: {
                return this.createObjectNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case ObjectType: {
                return this.createObjectTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case ReferenceType: {
                return this.createReferenceTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case Variable: {
                return this.createVariableNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case VariableType: {
                return this.createVariableTypeNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
            case View: {
                return this.createViewNodeFromBaseAttributes(nodeId, baseAttributeValues);
            }
        }
        throw new IllegalArgumentException("NodeClass: " + nodeClass);
    }

    private CompletableFuture<UaDataTypeNode> createDataTypeNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.DATA_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaDataTypeNode node = this.newDataTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaMethodNode> createMethodNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.METHOD_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaMethodNode node = this.newMethodNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaObjectNode> createObjectNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.OBJECT_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return CompletableFuture.allOf(attributesFuture, typeDefinitionFuture).thenCompose(ignored -> {
            ReadResponse response = (ReadResponse)attributesFuture.join();
            NodeId typeDefinitionId = (NodeId)typeDefinitionFuture.join();
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaObjectNode node = this.newObjectNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaObjectTypeNode> createObjectTypeNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.OBJECT_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaObjectTypeNode node = this.newObjectTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaReferenceTypeNode> createReferenceTypeNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.REFERENCE_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaReferenceTypeNode node = this.newReferenceTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaVariableNode> createVariableNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VARIABLE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        CompletableFuture<NodeId> typeDefinitionFuture = this.readTypeDefinition(nodeId);
        return CompletableFuture.allOf(attributesFuture, typeDefinitionFuture).thenCompose(ignored -> {
            ReadResponse response = (ReadResponse)attributesFuture.join();
            NodeId typeDefinitionId = (NodeId)typeDefinitionFuture.join();
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaVariableNode node = this.newVariableNode(nodeId, typeDefinitionId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaVariableTypeNode> createVariableTypeNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VARIABLE_TYPE_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaVariableTypeNode node = this.newVariableTypeNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<UaViewNode> createViewNodeFromBaseAttributes(NodeId nodeId, List<DataValue> baseAttributeValues) {
        Sets.SetView remainingAttributes = Sets.difference((Set)AttributeId.VIEW_ATTRIBUTES, (Set)AttributeId.BASE_ATTRIBUTES);
        CompletableFuture<ReadResponse> attributesFuture = this.readAttributes(nodeId, (Set<AttributeId>)remainingAttributes);
        return attributesFuture.thenCompose(response -> {
            ArrayList<DataValue> attributeValues = new ArrayList<DataValue>(baseAttributeValues);
            Collections.addAll(attributeValues, response.getResults());
            try {
                UaViewNode node = this.newViewNode(nodeId, attributeValues);
                this.nodeCache.put(node.getNodeId(), node);
                return CompletableFuture.completedFuture(node);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private CompletableFuture<ReadResponse> readAttributes(NodeId nodeId, Set<AttributeId> attributeIds) {
        List<ReadValueId> readValueIds = attributeIds.stream().map(id -> new ReadValueId(nodeId, id.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        return this.client.read(0.0, TimestampsToReturn.Neither, readValueIds);
    }

    private UaDataTypeNode newDataTypeNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.DataType ? 1 : 0) != 0, (Object)("expected NodeClass.DataType, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            Boolean isAbstract = (Boolean)attributeValues.get(7).getValue().getValue();
            return new UaDataTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, isAbstract);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaMethodNode newMethodNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.Method ? 1 : 0) != 0, (Object)("expected NodeClass.Method, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            Boolean executable = (Boolean)attributeValues.get(7).getValue().getValue();
            Boolean userExecutable = (Boolean)attributeValues.get(8).getValue().getValue();
            return new UaMethodNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, executable, userExecutable);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaObjectNode newObjectNode(NodeId nodeId, NodeId typeDefinitionId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.Object ? 1 : 0) != 0, (Object)("expected NodeClass.Object, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            UByte eventNotifier = (UByte)attributeValues.get(7).getValue().getValue();
            ObjectTypeManager.ObjectNodeConstructor constructor = this.client.getObjectTypeManager().getNodeConstructor(typeDefinitionId).orElse(UaObjectNode::new);
            return constructor.apply(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaObjectTypeNode newObjectTypeNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.ObjectType ? 1 : 0) != 0, (Object)("expected NodeClass.ObjectType, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            Boolean isAbstract = (Boolean)attributeValues.get(7).getValue().getValue();
            return new UaObjectTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, isAbstract);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaReferenceTypeNode newReferenceTypeNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.ReferenceType ? 1 : 0) != 0, (Object)("expected NodeClass.ReferenceType, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            Boolean isAbstract = (Boolean)attributeValues.get(7).getValue().getValue();
            Boolean symmetric = (Boolean)attributeValues.get(8).getValue().getValue();
            LocalizedText inverseName = AddressSpace.getAttributeOrNull(attributeValues.get(9), LocalizedText.class);
            return new UaReferenceTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, isAbstract, symmetric, inverseName);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaVariableNode newVariableNode(NodeId nodeId, NodeId typeDefinitionId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.Variable ? 1 : 0) != 0, (Object)("expected NodeClass.Variable, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            DataValue value = attributeValues.get(7);
            NodeId dataType = (NodeId)attributeValues.get(8).getValue().getValue();
            Integer valueRank = (Integer)attributeValues.get(9).getValue().getValue();
            UInteger[] arrayDimensions = AddressSpace.getAttributeOrNull(attributeValues.get(10), UInteger[].class);
            UByte accessLevel = (UByte)attributeValues.get(11).getValue().getValue();
            UByte userAccessLevel = (UByte)attributeValues.get(12).getValue().getValue();
            Double minimumSamplingInterval = AddressSpace.getAttributeOrNull(attributeValues.get(13), Double.class);
            Boolean historizing = (Boolean)attributeValues.get(14).getValue().getValue();
            VariableTypeManager.VariableNodeConstructor constructor = this.client.getVariableTypeManager().getNodeConstructor(typeDefinitionId).orElse(UaVariableNode::new);
            return constructor.apply(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaVariableTypeNode newVariableTypeNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.VariableType ? 1 : 0) != 0, (Object)("expected NodeClass.VariableType, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            DataValue value = attributeValues.get(7);
            NodeId dataType = (NodeId)attributeValues.get(8).getValue().getValue();
            Integer valueRank = (Integer)attributeValues.get(9).getValue().getValue();
            UInteger[] arrayDimensions = AddressSpace.getAttributeOrNull(attributeValues.get(10), UInteger[].class);
            Boolean isAbstract = (Boolean)attributeValues.get(11).getValue().getValue();
            return new UaVariableTypeNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, isAbstract);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    private UaViewNode newViewNode(NodeId nodeId, List<DataValue> attributeValues) throws UaException {
        DataValue nodeIdDataValue = attributeValues.get(0);
        StatusCode nodeIdStatusCode = nodeIdDataValue.getStatusCode();
        if (nodeIdStatusCode != null && nodeIdStatusCode.isBad()) {
            throw new UaException(nodeIdStatusCode);
        }
        try {
            NodeClass nodeClass = NodeClass.from((int)((Integer)attributeValues.get(1).getValue().getValue()));
            Preconditions.checkArgument((nodeClass == NodeClass.View ? 1 : 0) != 0, (Object)("expected NodeClass.View, got NodeClass." + nodeClass));
            QualifiedName browseName = (QualifiedName)attributeValues.get(2).getValue().getValue();
            LocalizedText displayName = (LocalizedText)attributeValues.get(3).getValue().getValue();
            LocalizedText description = AddressSpace.getAttributeOrNull(attributeValues.get(4), LocalizedText.class);
            UInteger writeMask = AddressSpace.getAttributeOrNull(attributeValues.get(5), UInteger.class);
            UInteger userWriteMask = AddressSpace.getAttributeOrNull(attributeValues.get(6), UInteger.class);
            Boolean containsNoLoops = (Boolean)attributeValues.get(7).getValue().getValue();
            UByte eventNotifier = (UByte)attributeValues.get(8).getValue().getValue();
            return new UaViewNode(this.client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, containsNoLoops, eventNotifier);
        }
        catch (Throwable t) {
            throw UaException.extract((Throwable)t).orElse(new UaException(0x80010000L, t));
        }
    }

    @Nullable
    private static <T> T getAttributeOrNull(DataValue value, Class<T> attributeClazz) {
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            return null;
        }
        Object attributeValue = value.getValue().getValue();
        try {
            return attributeClazz.cast(attributeValue);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static class BrowseOptions {
        private final BrowseDirection browseDirection;
        private final NodeId referenceTypeId;
        private final boolean includeSubtypes;
        private final UInteger nodeClassMask;
        private final UInteger maxReferencesPerNode;

        public BrowseOptions() {
            this(BrowseDirection.Forward, Identifiers.HierarchicalReferences, true, Unsigned.uint((int)255), Unsigned.uint((int)0));
        }

        public BrowseOptions(BrowseDirection browseDirection, NodeId referenceTypeId, boolean includeSubtypes, UInteger nodeClassMask, UInteger maxReferencesPerNode) {
            this.browseDirection = browseDirection;
            this.referenceTypeId = referenceTypeId;
            this.includeSubtypes = includeSubtypes;
            this.nodeClassMask = nodeClassMask;
            this.maxReferencesPerNode = maxReferencesPerNode;
        }

        public BrowseDirection getBrowseDirection() {
            return this.browseDirection;
        }

        public NodeId getReferenceTypeId() {
            return this.referenceTypeId;
        }

        public boolean isIncludeSubtypes() {
            return this.includeSubtypes;
        }

        public UInteger getNodeClassMask() {
            return this.nodeClassMask;
        }

        public UInteger getMaxReferencesPerNode() {
            return this.maxReferencesPerNode;
        }

        public BrowseOptions copy(Consumer<Builder> builderConsumer) {
            Builder builder = new Builder(this);
            builderConsumer.accept(builder);
            return builder.build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private BrowseDirection browseDirection = BrowseDirection.Forward;
            private NodeId referenceTypeId = Identifiers.HierarchicalReferences;
            private boolean includeSubtypes = true;
            private UInteger nodeClassMask = Unsigned.uint((int)255);
            private UInteger maxReferencesPerNode = Unsigned.uint((int)0);

            private Builder() {
            }

            private Builder(BrowseOptions browseOptions) {
                this.browseDirection = browseOptions.getBrowseDirection();
                this.referenceTypeId = browseOptions.getReferenceTypeId();
                this.includeSubtypes = browseOptions.isIncludeSubtypes();
                this.nodeClassMask = browseOptions.getNodeClassMask();
                this.maxReferencesPerNode = browseOptions.getMaxReferencesPerNode();
            }

            public Builder setBrowseDirection(BrowseDirection browseDirection) {
                this.browseDirection = browseDirection;
                return this;
            }

            public Builder setReferenceType(BuiltinReferenceType referenceType) {
                return this.setReferenceType(referenceType.getNodeId());
            }

            public Builder setReferenceType(NodeId referenceTypeId) {
                this.referenceTypeId = referenceTypeId;
                return this;
            }

            public Builder setIncludeSubtypes(boolean includeSubtypes) {
                this.includeSubtypes = includeSubtypes;
                return this;
            }

            public Builder setNodeClassMask(UInteger nodeClassMask) {
                this.nodeClassMask = nodeClassMask;
                return this;
            }

            public Builder setNodeClassMask(Set<NodeClass> nodeClasses) {
                int mask = 0;
                for (NodeClass nodeClass : nodeClasses) {
                    mask |= nodeClass.getValue();
                }
                return this.setNodeClassMask(Unsigned.uint((int)mask));
            }

            public Builder setMaxReferencesPerNode(UInteger maxReferencesPerNode) {
                this.maxReferencesPerNode = maxReferencesPerNode;
                return this;
            }

            public BrowseOptions build() {
                return new BrowseOptions(this.browseDirection, this.referenceTypeId, this.includeSubtypes, this.nodeClassMask, this.maxReferencesPerNode);
            }
        }
    }
}

