/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.util.Unit;

public class ManagedEventItem
extends ManagedItem {
    private final CopyOnWriteArrayList<EventValueListener> eventValueListeners = new CopyOnWriteArrayList();
    private UaMonitoredItem.EventConsumer eventConsumer = null;

    public ManagedEventItem(OpcUaClient client, ManagedSubscription subscription, OpcUaMonitoredItem monitoredItem) {
        super(client, subscription, monitoredItem);
    }

    @Override
    public CompletableFuture<Unit> deleteAsync() {
        return this.subscription.deleteEventItemAsync(this);
    }

    public synchronized EventValueListener addEventValueListener(Consumer<Variant[]> consumer) {
        EventValueListener eventValueListener = (item, fields) -> consumer.accept(fields);
        this.addEventValueListener(eventValueListener);
        return eventValueListener;
    }

    public synchronized void addEventValueListener(EventValueListener eventValueListener) {
        this.eventValueListeners.add(eventValueListener);
        if (this.eventConsumer == null) {
            this.eventConsumer = new ManagedEventConsumer();
            this.monitoredItem.setEventConsumer(this.eventConsumer);
        }
    }

    public synchronized boolean removeEventValueListener(EventValueListener eventValueListener) {
        boolean removed = this.eventValueListeners.remove(eventValueListener);
        if (this.eventValueListeners.isEmpty()) {
            this.monitoredItem.setEventConsumer((UaMonitoredItem.EventConsumer)null);
            this.eventConsumer = null;
        }
        return removed;
    }

    public static interface EventValueListener {
        public void onEventValueReceived(ManagedEventItem var1, Variant[] var2);
    }

    private class ManagedEventConsumer
    implements UaMonitoredItem.EventConsumer {
        private ManagedEventConsumer() {
        }

        @Override
        public void onEventArrived(UaMonitoredItem item, Variant[] eventValues) {
            ManagedEventItem.this.eventValueListeners.forEach(eventValueListener -> eventValueListener.onEventValueReceived(ManagedEventItem.this, eventValues));
        }
    }
}

