/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.subscriptions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaMonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyResult;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.util.AsyncSemaphore;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class OpcUaSubscription
implements UaSubscription {
    private final Map<UInteger, OpcUaMonitoredItem> itemsByClientHandle = Maps.newConcurrentMap();
    private final Map<UInteger, OpcUaMonitoredItem> itemsByServerHandle = Maps.newConcurrentMap();
    private final List<UaSubscription.NotificationListener> notificationListeners = new CopyOnWriteArrayList<UaSubscription.NotificationListener>();
    private final AsyncSemaphore notificationSemaphore = new AsyncSemaphore(1);
    private final ClientHandleSequence clientHandleSequence = new ClientHandleSequence(this.itemsByClientHandle::containsKey);
    final List<UInteger> availableAcknowledgements = Collections.synchronizedList(new ArrayList());
    private volatile long lastSequenceNumber = 0L;
    private volatile double requestedPublishingInterval = 0.0;
    private volatile double revisedPublishingInterval = 0.0;
    private volatile UInteger requestedLifetimeCount = Unsigned.uint((int)0);
    private volatile UInteger revisedLifetimeCount = Unsigned.uint((int)0);
    private volatile UInteger requestedMaxKeepAliveCount = Unsigned.uint((int)0);
    private volatile UInteger revisedMaxKeepAliveCount = Unsigned.uint((int)0);
    private volatile UInteger maxNotificationsPerPublish;
    private volatile boolean publishingEnabled;
    private volatile UByte priority;
    private final OpcUaClient client;
    private final UInteger subscriptionId;

    public OpcUaSubscription(OpcUaClient client, UInteger subscriptionId, double revisedPublishingInterval, UInteger revisedLifetimeCount, UInteger revisedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, boolean publishingEnabled, UByte priority) {
        this.client = client;
        this.subscriptionId = subscriptionId;
        this.revisedPublishingInterval = revisedPublishingInterval;
        this.revisedLifetimeCount = revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.publishingEnabled = publishingEnabled;
        this.priority = priority;
    }

    @Override
    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
        CompletableFuture<CreateMonitoredItemsResponse> future = this.client.createMonitoredItems(this.subscriptionId, timestampsToReturn, itemsToCreate);
        return future.thenApply(response -> {
            List results = ConversionUtil.l((Object[])response.getResults());
            ArrayList createdItems = Lists.newArrayListWithCapacity((int)itemsToCreate.size());
            int i = 0;
            while (i < itemsToCreate.size()) {
                MonitoredItemCreateRequest request = (MonitoredItemCreateRequest)itemsToCreate.get(i);
                MonitoredItemCreateResult result = (MonitoredItemCreateResult)results.get(i);
                OpcUaMonitoredItem item = new OpcUaMonitoredItem(this.client, request.getRequestedParameters().getClientHandle(), request.getItemToMonitor(), result.getMonitoredItemId(), result.getStatusCode(), result.getRevisedSamplingInterval(), result.getRevisedQueueSize(), result.getFilterResult(), request.getMonitoringMode(), request.getRequestedParameters().getFilter(), request.getRequestedParameters().getDiscardOldest(), timestampsToReturn);
                item.setRequestedSamplingInterval(request.getRequestedParameters().getSamplingInterval());
                item.setRequestedQueueSize(request.getRequestedParameters().getQueueSize());
                if (item.getStatusCode().isGood()) {
                    this.itemsByClientHandle.put(item.getClientHandle(), item);
                    this.itemsByServerHandle.put(item.getMonitoredItemId(), item);
                }
                createdItems.add(item);
                ++i;
            }
            return createdItems;
        });
    }

    @Override
    public CompletableFuture<List<UaMonitoredItem>> createMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate, UaSubscription.ItemCreationCallback itemCreationCallback) {
        return this.notificationSemaphore.acquire().thenCompose(permit -> {
            CompletableFuture<List<UaMonitoredItem>> itemsFuture = this.createMonitoredItems(timestampsToReturn, itemsToCreate);
            return itemsFuture.whenComplete((items, ex) -> {
                try {
                    if (items != null) {
                        int i = 0;
                        while (i < items.size()) {
                            UaMonitoredItem item = (UaMonitoredItem)items.get(i);
                            itemCreationCallback.onItemCreated(item, i);
                            ++i;
                        }
                    }
                }
                finally {
                    permit.release();
                }
            });
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> modifyMonitoredItems(TimestampsToReturn timestampsToReturn, List<MonitoredItemModifyRequest> itemsToModify) {
        CompletableFuture<ModifyMonitoredItemsResponse> future = this.client.modifyMonitoredItems(this.subscriptionId, timestampsToReturn, itemsToModify);
        return future.thenApply(response -> {
            ArrayList statusCodes = Lists.newArrayList();
            List results = ConversionUtil.l((Object[])response.getResults());
            int i = 0;
            while (i < results.size()) {
                MonitoredItemModifyRequest request = (MonitoredItemModifyRequest)itemsToModify.get(i);
                MonitoredItemModifyResult result = (MonitoredItemModifyResult)results.get(i);
                StatusCode statusCode = result.getStatusCode();
                OpcUaMonitoredItem item = this.itemsByServerHandle.get(request.getMonitoredItemId());
                if (item != null) {
                    item.setStatusCode(statusCode);
                    if (statusCode.isGood()) {
                        item.setTimestamps(timestampsToReturn);
                        item.setRevisedSamplingInterval(result.getRevisedSamplingInterval());
                        item.setRevisedQueueSize(result.getRevisedQueueSize());
                        item.setFilterResult(result.getFilterResult());
                        item.setDiscardOldest(request.getRequestedParameters().getDiscardOldest());
                        item.setRequestedFilter(request.getRequestedParameters().getFilter());
                        item.setRequestedSamplingInterval(request.getRequestedParameters().getSamplingInterval());
                        item.setRequestedQueueSize(request.getRequestedParameters().getQueueSize());
                    }
                }
                statusCodes.add(statusCode);
                ++i;
            }
            return statusCodes;
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> deleteMonitoredItems(List<UaMonitoredItem> itemsToDelete) {
        List<UInteger> monitoredItemIds = itemsToDelete.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList());
        return this.client.deleteMonitoredItems(this.subscriptionId, monitoredItemIds).thenApply(response -> {
            List results = ConversionUtil.l((Object[])response.getResults());
            int i = 0;
            while (i < itemsToDelete.size()) {
                OpcUaMonitoredItem item = (OpcUaMonitoredItem)itemsToDelete.get(i);
                this.itemsByClientHandle.remove(item.getClientHandle());
                this.itemsByServerHandle.remove(item.getMonitoredItemId());
                item.setStatusCode((StatusCode)results.get(i));
                ++i;
            }
            return results;
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> setMonitoringMode(MonitoringMode monitoringMode, List<UaMonitoredItem> items) {
        List<UInteger> monitoredItemIds = items.stream().map(UaMonitoredItem::getMonitoredItemId).collect(Collectors.toList());
        CompletableFuture<SetMonitoringModeResponse> future = this.client.setMonitoringMode(this.subscriptionId, monitoringMode, monitoredItemIds);
        return future.thenApply(response -> {
            List results = ConversionUtil.l((Object[])response.getResults());
            int i = 0;
            while (i < monitoredItemIds.size()) {
                UInteger id = (UInteger)monitoredItemIds.get(i);
                OpcUaMonitoredItem item = this.itemsByServerHandle.get(id);
                StatusCode result = (StatusCode)results.get(i);
                if (result.isGood() && item != null) {
                    item.setMonitoringMode(monitoringMode);
                }
                ++i;
            }
            return results;
        });
    }

    @Override
    public CompletableFuture<StatusCode> setPublishingMode(boolean publishingEnabled) {
        return this.client.setPublishingMode(publishingEnabled, Lists.newArrayList((Object[])new UInteger[]{this.subscriptionId})).thenApply(response -> {
            StatusCode statusCode = (StatusCode)ConversionUtil.l((Object[])response.getResults()).get(0);
            if (statusCode.isGood()) {
                this.setPublishingEnabled(publishingEnabled);
            }
            return statusCode;
        });
    }

    @Override
    public CompletableFuture<List<StatusCode>> addTriggeringLinks(UInteger triggeringItemId, List<UInteger> linksToAdd) {
        CompletableFuture<SetTriggeringResponse> future = this.client.setTriggering(this.subscriptionId, triggeringItemId, linksToAdd, Collections.emptyList());
        return future.thenApply(r -> Arrays.asList(r.getAddResults()));
    }

    @Override
    public CompletableFuture<List<StatusCode>> removeTriggeringLinks(UInteger triggeringItemId, List<UInteger> linksToRemove) {
        CompletableFuture<SetTriggeringResponse> future = this.client.setTriggering(this.subscriptionId, triggeringItemId, Collections.emptyList(), linksToRemove);
        return future.thenApply(r -> Arrays.asList(r.getRemoveResults()));
    }

    @Override
    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public double getRequestedPublishingInterval() {
        return this.requestedPublishingInterval;
    }

    @Override
    public double getRevisedPublishingInterval() {
        return this.revisedPublishingInterval;
    }

    @Override
    public UInteger getRequestedLifetimeCount() {
        return this.requestedLifetimeCount;
    }

    @Override
    public UInteger getRevisedLifetimeCount() {
        return this.revisedLifetimeCount;
    }

    @Override
    public UInteger getRequestedMaxKeepAliveCount() {
        return this.requestedMaxKeepAliveCount;
    }

    @Override
    public UInteger getRevisedMaxKeepAliveCount() {
        return this.revisedMaxKeepAliveCount;
    }

    @Override
    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    @Override
    public boolean isPublishingEnabled() {
        return this.publishingEnabled;
    }

    @Override
    public UByte getPriority() {
        return this.priority;
    }

    @Override
    public ImmutableList<UaMonitoredItem> getMonitoredItems() {
        return ImmutableList.copyOf(this.itemsByClientHandle.values());
    }

    @Override
    public UInteger nextClientHandle() {
        return this.clientHandleSequence.nextClientHandle();
    }

    @Override
    public void addNotificationListener(UaSubscription.NotificationListener listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public void removeNotificationListener(UaSubscription.NotificationListener listener) {
        this.notificationListeners.remove(listener);
    }

    List<UaSubscription.NotificationListener> getNotificationListeners() {
        return this.notificationListeners;
    }

    AsyncSemaphore getNotificationSemaphore() {
        return this.notificationSemaphore;
    }

    Map<UInteger, OpcUaMonitoredItem> getItemsByClientHandle() {
        return this.itemsByClientHandle;
    }

    Map<UInteger, OpcUaMonitoredItem> getItemsByServerHandle() {
        return this.itemsByServerHandle;
    }

    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    void setRequestedPublishingInterval(double requestedPublishingInterval) {
        this.requestedPublishingInterval = requestedPublishingInterval;
    }

    void setRevisedPublishingInterval(double revisedPublishingInterval) {
        this.revisedPublishingInterval = revisedPublishingInterval;
    }

    void setRequestedLifetimeCount(UInteger requestedLifetimeCount) {
        this.requestedLifetimeCount = requestedLifetimeCount;
    }

    void setRevisedLifetimeCount(UInteger revisedLifetimeCount) {
        this.revisedLifetimeCount = revisedLifetimeCount;
    }

    void setRequestedMaxKeepAliveCount(UInteger requestedMaxKeepAliveCount) {
        this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
    }

    void setRevisedMaxKeepAliveCount(UInteger revisedMaxKeepAliveCount) {
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
    }

    void setMaxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
    }

    void setPublishingEnabled(boolean publishingEnabled) {
        this.publishingEnabled = publishingEnabled;
    }

    void setPriority(UByte priority) {
        this.priority = priority;
    }

    void setLastSequenceNumber(long lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
    }

    static class ClientHandleSequence {
        private final AtomicLong clientHandle;
        private final Predicate<UInteger> handleInUse;

        ClientHandleSequence(Predicate<UInteger> handleInUse) {
            this(handleInUse, 0L);
        }

        @VisibleForTesting
        ClientHandleSequence(Predicate<UInteger> handleInUse, long initialValue) {
            this.handleInUse = handleInUse;
            this.clientHandle = new AtomicLong(initialValue);
        }

        synchronized UInteger nextClientHandle() {
            UInteger original;
            UInteger next = original = this.getAndIncrementWithRollover();
            while (this.handleInUse.test(next)) {
                next = this.getAndIncrementWithRollover();
                if (!next.equals((Object)original)) continue;
                throw new IllegalStateException("no unused client handles");
            }
            return next;
        }

        private UInteger getAndIncrementWithRollover() {
            long current = this.clientHandle.get();
            if (current > 0xFFFFFFFFL) {
                this.clientHandle.set(0L);
            }
            return Unsigned.uint((long)this.clientHandle.getAndIncrement());
        }
    }
}

