/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public enum WriteMask {
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    ValueForVariableType(0x200000);

    public static final Set<WriteMask> NONE;
    private final int value;

    static {
        NONE = ImmutableSet.of();
    }

    private WriteMask(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EnumSet<WriteMask> fromMask(int accessLevel) {
        EnumSet<WriteMask> e = EnumSet.noneOf(WriteMask.class);
        WriteMask[] writeMaskArray = org.eclipse.milo.opcua.sdk.core.WriteMask.values();
        int n = writeMaskArray.length;
        int n2 = 0;
        while (n2 < n) {
            WriteMask wm = writeMaskArray[n2];
            if ((wm.value & accessLevel) != 0) {
                e.add(wm);
            }
            ++n2;
        }
        return e;
    }

    public static EnumSet<WriteMask> fromMask(UInteger accessLevel) {
        return org.eclipse.milo.opcua.sdk.core.WriteMask.fromMask(accessLevel.intValue());
    }
}

