/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class GroupMapCollate {
    public static <T, K, R> CompletableFuture<List<R>> groupMapCollate(List<T> items, Function<T, K> grouper, Function<K, Mapper<T, R>> mappers) {
        ArrayList pending = new ArrayList();
        int i = 0;
        while (i < items.size()) {
            pending.add(new Pending(items.get(i), i));
            ++i;
        }
        Map<Object, List<Pending>> grouped = pending.stream().collect(Collectors.groupingBy(p -> grouper.apply(p.item)));
        Stream<CompletableFuture<Void>> futures = grouped.entrySet().stream().map(entry -> {
            Object key = entry.getKey();
            List pendingForKey = (List)entry.getValue();
            Mapper mapper = (Mapper)mappers.apply(key);
            CompletableFuture future = mapper.map(pendingForKey.stream().map(p -> p.item).collect(Collectors.toList()));
            return future.thenAccept(results -> {
                if (results.size() != pendingForKey.size()) {
                    String message = String.format("result size (%s) does not match pending size (%s)", results.size(), pendingForKey.size());
                    LoggerFactory.getLogger(GroupMapCollate.class).error(message);
                    throw new RuntimeException(message);
                }
                int i = 0;
                while (i < pendingForKey.size()) {
                    ((Pending)list.get((int)i)).result = results.get(i);
                    ++i;
                }
            });
        });
        return GroupMapCollate.allOf(futures).thenApply(v -> pending.stream().map(p -> p.result).collect(Collectors.toList()));
    }

    private static CompletableFuture<Void> allOf(Stream<CompletableFuture<Void>> futureStream) {
        CompletableFuture[] fa = (CompletableFuture[])futureStream.toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(fa);
    }

    public static interface Mapper<T, R> {
        public CompletableFuture<List<R>> map(List<T> var1);
    }

    private static class Pending<T, R> {
        volatile R result;
        final T item;
        final int index;

        Pending(T item, int index) {
            this.item = item;
            this.index = index;
        }
    }
}

