/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;

public class DiagnosticsContext<T> {
    private final Map<T, DiagnosticInfo> diagnosticsMap = Maps.newConcurrentMap();

    public EnumSet<OperationDiagnostic> getRequestedOperationDiagnostics(T t) {
        return null;
    }

    public void setOperationDiagnostic(T t, DiagnosticInfo diagnosticInfo) {
    }

    public Map<T, DiagnosticInfo> getDiagnosticsMap() {
        return this.diagnosticsMap;
    }

    public DiagnosticInfo[] getDiagnosticInfos(T[] ts) {
        return this.getDiagnosticInfos(Arrays.asList(ts));
    }

    public DiagnosticInfo[] getDiagnosticInfos(List<T> ts) {
        if (this.diagnosticsMap.isEmpty()) {
            return new DiagnosticInfo[0];
        }
        DiagnosticInfo[] diagnostics = new DiagnosticInfo[ts.size()];
        int i = 0;
        while (i < ts.size()) {
            DiagnosticInfo diagnosticInfo;
            diagnostics[i] = diagnosticInfo = this.diagnosticsMap.getOrDefault(ts.get(i), DiagnosticInfo.NULL_VALUE);
            ++i;
        }
        return diagnostics;
    }

    public static enum OperationDiagnostic {
        SymbolicId,
        LocalizedText,
        InnerStatusCode,
        InnerDiagnostics;

    }
}

