/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.primitives.Bytes;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.jetbrains.annotations.Nullable;

public final class SecurityConfiguration {
    private final SecurityPolicy securityPolicy;
    private final MessageSecurityMode securityMode;
    private final KeyPair keyPair;
    private final X509Certificate serverCertificate;
    private final List<X509Certificate> serverCertificateChain;
    private final X509Certificate clientCertificate;
    private final List<X509Certificate> clientCertificateChain;

    public SecurityConfiguration(SecurityPolicy securityPolicy, MessageSecurityMode securityMode, @Nullable KeyPair keyPair, @Nullable X509Certificate serverCertificate, @Nullable List<X509Certificate> serverCertificateChain, @Nullable X509Certificate clientCertificate, @Nullable List<X509Certificate> clientCertificateChain) {
        this.securityPolicy = securityPolicy;
        this.securityMode = securityMode;
        this.keyPair = keyPair;
        this.serverCertificate = serverCertificate;
        this.serverCertificateChain = serverCertificateChain;
        this.clientCertificate = clientCertificate;
        this.clientCertificateChain = clientCertificateChain;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    @Nullable
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Nullable
    public X509Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    @Nullable
    public List<X509Certificate> getServerCertificateChain() {
        return this.serverCertificateChain;
    }

    @Nullable
    public X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    @Nullable
    public List<X509Certificate> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public ByteString getClientCertificateBytes() throws UaException {
        return SecurityConfiguration.getCertificateBytes(this.getClientCertificate());
    }

    public ByteString getClientCertificateChainBytes() throws UaException {
        return SecurityConfiguration.getCertificateChainBytes(this.getClientCertificateChain());
    }

    public ByteString getServerCertificateBytes() throws UaException {
        return SecurityConfiguration.getCertificateBytes(this.getServerCertificate());
    }

    public ByteString getServerCertificateChainBytes() throws UaException {
        return SecurityConfiguration.getCertificateChainBytes(this.getServerCertificateChain());
    }

    private static ByteString getCertificateBytes(@Nullable X509Certificate certificate) throws UaException {
        if (certificate == null) {
            return ByteString.NULL_VALUE;
        }
        try {
            return ByteString.of((byte[])certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    private static ByteString getCertificateChainBytes(@Nullable List<X509Certificate> certificateChain) throws UaException {
        if (certificateChain == null) {
            return ByteString.NULL_VALUE;
        }
        ArrayList<byte[]> certificates = new ArrayList<byte[]>(certificateChain.size());
        for (X509Certificate certificate : certificateChain) {
            try {
                certificates.add(certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new UaException(2148663296L, (Throwable)e);
            }
        }
        byte[] encoded = certificates.stream().reduce(new byte[0], (byArray, byArray2) -> Bytes.concat((byte[][])new byte[][]{byArray, byArray2}));
        return ByteString.of((byte[])encoded);
    }
}

