/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.methods;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.methods.InvalidArgumentException;
import org.eclipse.milo.opcua.sdk.server.api.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.slf4j.LoggerFactory;

public abstract class AbstractMethodInvocationHandler
implements MethodInvocationHandler {
    private final UaMethodNode node;

    public AbstractMethodInvocationHandler(UaMethodNode node) {
        this.node = node;
    }

    public UaMethodNode getNode() {
        return this.node;
    }

    @Override
    public final CallMethodResult invoke(final AccessContext accessContext, final CallMethodRequest request) {
        try {
            this.checkExecutableAttributes(accessContext);
            Variant[] inputArgumentValues = request.getInputArguments();
            if (inputArgumentValues == null) {
                inputArgumentValues = new Variant[]{};
            }
            if (inputArgumentValues.length != this.getInputArguments().length) {
                throw new UaException(2155216896L);
            }
            StatusCode[] inputDataTypeCheckResults = new StatusCode[inputArgumentValues.length];
            int i = 0;
            while (i < inputArgumentValues.length) {
                Argument argument = this.getInputArguments()[i];
                Variant variant = inputArgumentValues[i];
                Object value = variant.getValue();
                boolean dataTypeMatch = value == null || variant.getDataType().flatMap(xni -> xni.toNodeId(this.node.getNodeContext().getNamespaceTable())).map(type -> {
                    if (type.equals((Object)argument.getDataType())) {
                        return true;
                    }
                    if (Identifiers.Structure.equals(type) && value instanceof ExtensionObject) {
                        SerializationContext serializationContext = this.getNode().getNodeContext().getServer().getSerializationContext();
                        try {
                            Object decoded = ((ExtensionObject)value).decode(serializationContext);
                            if (decoded instanceof UaStructure) {
                                return ((UaStructure)decoded).getTypeId().toNodeId(this.node.getNodeContext().getNamespaceTable()).map(arg_0 -> ((NodeId)argument.getDataType()).equals(arg_0)).orElse(false);
                            }
                        }
                        catch (UaSerializationException e) {
                            LoggerFactory.getLogger(this.getClass()).warn("Error decoding argument value", (Throwable)e);
                        }
                    }
                    return false;
                }).orElse(false) != false;
                switch (argument.getValueRank()) {
                    case -1: {
                        if (value == null || !value.getClass().isArray()) break;
                        dataTypeMatch = false;
                        break;
                    }
                    case 0: 
                    case 1: {
                        if (value == null || value.getClass().isArray()) break;
                        dataTypeMatch = false;
                        break;
                    }
                }
                inputDataTypeCheckResults[i] = dataTypeMatch ? StatusCode.GOOD : new StatusCode(2155085824L);
                ++i;
            }
            if (Arrays.stream(inputDataTypeCheckResults).anyMatch(StatusCode::isBad)) {
                throw new InvalidArgumentException(inputDataTypeCheckResults);
            }
            this.validateInputArgumentValues(inputArgumentValues);
            InvocationContext invocationContext = new InvocationContext(){

                @Override
                public OpcUaServer getServer() {
                    return AbstractMethodInvocationHandler.this.node.getNodeContext().getServer();
                }

                @Override
                public NodeId getObjectId() {
                    return request.getObjectId();
                }

                @Override
                public UaMethodNode getMethodNode() {
                    return AbstractMethodInvocationHandler.this.node;
                }

                @Override
                public Optional<Session> getSession() {
                    return accessContext.getSession();
                }
            };
            Variant[] outputValues = this.invoke(invocationContext, inputArgumentValues);
            return new CallMethodResult(StatusCode.GOOD, new StatusCode[0], new DiagnosticInfo[0], outputValues);
        }
        catch (InvalidArgumentException e) {
            return new CallMethodResult(e.getStatusCode(), e.getInputArgumentResults(), e.getInputArgumentDiagnosticInfos(), new Variant[0]);
        }
        catch (UaException e) {
            return new CallMethodResult(e.getStatusCode(), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]);
        }
    }

    protected void checkExecutableAttributes(AccessContext accessContext) throws UaException {
        AttributeContext attributeContext = new AttributeContext(this.node.getNodeContext().getServer(), accessContext.getSession().orElse(null));
        Boolean executable = (Boolean)AttributeUtil.extract(this.node.getAttribute(attributeContext, AttributeId.Executable));
        if (executable == null || !executable.booleanValue()) {
            throw new UaException(StatusCode.BAD);
        }
        Boolean userExecutable = (Boolean)AttributeUtil.extract(this.node.getAttribute(attributeContext, AttributeId.UserExecutable));
        if (userExecutable == null || !userExecutable.booleanValue()) {
            throw new UaException(2149515264L);
        }
    }

    public abstract Argument[] getInputArguments();

    public abstract Argument[] getOutputArguments();

    protected abstract Variant[] invoke(InvocationContext var1, Variant[] var2) throws UaException;

    protected void validateInputArgumentValues(Variant[] inputArgumentValues) throws InvalidArgumentException {
    }

    public static interface InvocationContext
    extends AccessContext {
        public OpcUaServer getServer();

        public NodeId getObjectId();

        public UaMethodNode getMethodNode();
    }
}

