/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ByteConversions {
    private ByteConversions() {
    }

    @NotNull
    static Boolean byteToBoolean(@NotNull UByte ub) {
        if (ub.intValue() != 0) {
            return true;
        }
        return false;
    }

    @NotNull
    static Double byteToDouble(@NotNull UByte ub) {
        return ub.doubleValue();
    }

    @NotNull
    static Float byteToFloat(@NotNull UByte ub) {
        return Float.valueOf(ub.floatValue());
    }

    @NotNull
    static Short byteToInt16(@NotNull UByte ub) {
        return ub.shortValue();
    }

    @NotNull
    static Integer byteToInt32(@NotNull UByte ub) {
        return ub.intValue();
    }

    @NotNull
    static Long byteToInt64(@NotNull UByte ub) {
        return ub.longValue();
    }

    @Nullable
    static Byte byteToSByte(@NotNull UByte ub) {
        return ub.intValue() > 127 ? null : Byte.valueOf(ub.byteValue());
    }

    @NotNull
    static String byteToString(@NotNull UByte ub) {
        return ub.toString();
    }

    @NotNull
    static UShort byteToUInt16(@NotNull UByte ub) {
        return Unsigned.ushort((int)ub.intValue());
    }

    @NotNull
    static UInteger byteToUInt32(@NotNull UByte ub) {
        return Unsigned.uint((int)ub.intValue());
    }

    @NotNull
    static ULong byteToUInt64(@NotNull UByte ub) {
        return Unsigned.ulong((long)ub.longValue());
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UByte) {
            UByte b = (UByte)o;
            return implicit ? ByteConversions.implicitConversion(b, targetType) : ByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull UByte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return ByteConversions.byteToBoolean(b);
            }
            case String: {
                return ByteConversions.byteToString(b);
            }
        }
        return ByteConversions.implicitConversion(b, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull UByte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return ByteConversions.byteToDouble(b);
            }
            case Float: {
                return ByteConversions.byteToFloat(b);
            }
            case Int16: {
                return ByteConversions.byteToInt16(b);
            }
            case Int32: {
                return ByteConversions.byteToInt32(b);
            }
            case Int64: {
                return ByteConversions.byteToInt64(b);
            }
            case SByte: {
                return ByteConversions.byteToSByte(b);
            }
            case UInt16: {
                return ByteConversions.byteToUInt16(b);
            }
            case UInt32: {
                return ByteConversions.byteToUInt32(b);
            }
            case UInt64: {
                return ByteConversions.byteToUInt64(b);
            }
        }
        return null;
    }
}

