/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Int32Conversions {
    private Int32Conversions() {
    }

    @NotNull
    static Boolean int32ToBoolean(@NotNull Integer i) {
        if (i != 0) {
            return true;
        }
        return false;
    }

    @Nullable
    static UByte int32ToByte(@NotNull Integer i) {
        if (i >= 0 && i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    @NotNull
    static Double int32ToDouble(@NotNull Integer i) {
        return i.doubleValue();
    }

    @NotNull
    static Float int32ToFloat(@NotNull Integer i) {
        return Float.valueOf(i.floatValue());
    }

    @Nullable
    static Short int32ToInt16(@NotNull Integer i) {
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return i.shortValue();
        }
        return null;
    }

    @NotNull
    static Long int32ToInt64(@NotNull Integer i) {
        return i.longValue();
    }

    @Nullable
    static Byte int32ToSByte(@NotNull Integer i) {
        if (i >= -128 && i <= 127) {
            return i.byteValue();
        }
        return null;
    }

    @NotNull
    static StatusCode int32ToStatusCode(@NotNull Integer i) {
        return new StatusCode(i.intValue());
    }

    @NotNull
    static String int32ToString(@NotNull Integer i) {
        return i.toString();
    }

    @Nullable
    static UShort int32ToUInt16(@NotNull Integer i) {
        if (i >= 0 && i <= 65535) {
            return Unsigned.ushort((int)i);
        }
        return null;
    }

    @Nullable
    static UInteger int32ToUInt32(@NotNull Integer i) {
        if (i >= 0) {
            return Unsigned.uint((int)i);
        }
        return null;
    }

    @Nullable
    static ULong int32ToUInt64(@NotNull Integer i) {
        if (i >= 0) {
            return Unsigned.ulong((long)i.intValue());
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return implicit ? Int32Conversions.implicitConversion(i, targetType) : Int32Conversions.explicitConversion(i, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull Integer i, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int32Conversions.int32ToBoolean(i);
            }
            case Byte: {
                return Int32Conversions.int32ToByte(i);
            }
            case Int16: {
                return Int32Conversions.int32ToInt16(i);
            }
            case SByte: {
                return Int32Conversions.int32ToSByte(i);
            }
            case StatusCode: {
                return Int32Conversions.int32ToStatusCode(i);
            }
            case String: {
                return Int32Conversions.int32ToString(i);
            }
            case UInt16: {
                return Int32Conversions.int32ToUInt16(i);
            }
            case UInt32: {
                return Int32Conversions.int32ToUInt32(i);
            }
        }
        return Int32Conversions.implicitConversion(i, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull Integer i, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int32Conversions.int32ToDouble(i);
            }
            case Float: {
                return Int32Conversions.int32ToFloat(i);
            }
            case Int64: {
                return Int32Conversions.int32ToInt64(i);
            }
            case UInt64: {
                return Int32Conversions.int32ToUInt64(i);
            }
        }
        return null;
    }
}

