/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SByteConversions {
    private SByteConversions() {
    }

    @NotNull
    static Boolean sByteToBoolean(@NotNull Byte b) {
        if (b != 0) {
            return true;
        }
        return false;
    }

    @Nullable
    static UByte sByteToByte(@NotNull Byte b) {
        if (b >= 0) {
            return Unsigned.ubyte((byte)b);
        }
        return null;
    }

    @NotNull
    static Double sByteToDouble(@NotNull Byte b) {
        return b.doubleValue();
    }

    @NotNull
    static Float sByteToFloat(@NotNull Byte b) {
        return Float.valueOf(b.floatValue());
    }

    @NotNull
    static Short sByteToInt16(@NotNull Byte b) {
        return b.shortValue();
    }

    @NotNull
    static Integer sByteToInt32(@NotNull Byte b) {
        return b.intValue();
    }

    @NotNull
    static Long sByteToInt64(@NotNull Byte b) {
        return b.longValue();
    }

    @NotNull
    static String sByteToString(@NotNull Byte b) {
        return b.toString();
    }

    @Nullable
    static UShort sByteToUInt16(@NotNull Byte b) {
        if (b >= 0) {
            return Unsigned.ushort((short)b.byteValue());
        }
        return null;
    }

    @Nullable
    static UInteger sByteToUInt32(@NotNull Byte b) {
        if (b >= 0) {
            return Unsigned.uint((int)b.byteValue());
        }
        return null;
    }

    @Nullable
    static ULong sByteToUInt64(@NotNull Byte b) {
        if (b >= 0) {
            return Unsigned.ulong((long)b.byteValue());
        }
        return null;
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Byte) {
            Byte b = (Byte)o;
            return implicit ? SByteConversions.implicitConversion(b, targetType) : SByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull Byte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return SByteConversions.sByteToBoolean(b);
            }
            case Byte: {
                return SByteConversions.sByteToByte(b);
            }
            case String: {
                return SByteConversions.sByteToString(b);
            }
        }
        return SByteConversions.implicitConversion(b, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull Byte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return SByteConversions.sByteToDouble(b);
            }
            case Float: {
                return SByteConversions.sByteToFloat(b);
            }
            case Int16: {
                return SByteConversions.sByteToInt16(b);
            }
            case Int32: {
                return SByteConversions.sByteToInt32(b);
            }
            case Int64: {
                return SByteConversions.sByteToInt64(b);
            }
            case UInt16: {
                return SByteConversions.sByteToUInt16(b);
            }
            case UInt32: {
                return SByteConversions.sByteToUInt32(b);
            }
            case UInt64: {
                return SByteConversions.sByteToUInt64(b);
            }
        }
        return null;
    }
}

