/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UInt16Conversions {
    private UInt16Conversions() {
    }

    @NotNull
    static Boolean uInt16ToBoolean(@NotNull UShort us) {
        if (us.intValue() != 0) {
            return true;
        }
        return false;
    }

    @Nullable
    static UByte uInt16ToByte(@NotNull UShort us) {
        int i = us.intValue();
        if (i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    @NotNull
    static Double uInt16ToDouble(@NotNull UShort us) {
        return us.doubleValue();
    }

    @NotNull
    static Float uInt16ToFloat(@NotNull UShort us) {
        return Float.valueOf(us.floatValue());
    }

    @Nullable
    static Short uInt16ToInt16(@NotNull UShort us) {
        int i = us.intValue();
        if (i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return null;
    }

    @NotNull
    static Integer uInt16ToInt32(@NotNull UShort us) {
        return us.intValue();
    }

    @NotNull
    static Long uInt16ToInt64(@NotNull UShort us) {
        return us.longValue();
    }

    @Nullable
    static Byte uInt16ToSByte(@NotNull UShort us) {
        int i = us.intValue();
        if (i <= 127) {
            return (byte)i;
        }
        return null;
    }

    @NotNull
    static StatusCode uInt16ToStatusCode(@NotNull UShort us) {
        return new StatusCode(us.longValue() << 16);
    }

    @NotNull
    static String uInt16ToString(@NotNull UShort us) {
        return us.toString();
    }

    @NotNull
    static UInteger uInt16ToUInt32(@NotNull UShort us) {
        return Unsigned.uint((int)us.intValue());
    }

    @NotNull
    static ULong uInt16ToUInt64(@NotNull UShort us) {
        return Unsigned.ulong((long)us.longValue());
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UShort) {
            UShort us = (UShort)o;
            return implicit ? UInt16Conversions.implicitConversion(us, targetType) : UInt16Conversions.explicitConversion(us, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull UShort us, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt16Conversions.uInt16ToBoolean(us);
            }
            case Byte: {
                return UInt16Conversions.uInt16ToByte(us);
            }
            case SByte: {
                return UInt16Conversions.uInt16ToSByte(us);
            }
            case String: {
                return UInt16Conversions.uInt16ToString(us);
            }
        }
        return UInt16Conversions.implicitConversion(us, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull UShort us, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt16Conversions.uInt16ToDouble(us);
            }
            case Float: {
                return UInt16Conversions.uInt16ToFloat(us);
            }
            case Int16: {
                return UInt16Conversions.uInt16ToInt16(us);
            }
            case Int32: {
                return UInt16Conversions.uInt16ToInt32(us);
            }
            case Int64: {
                return UInt16Conversions.uInt16ToInt64(us);
            }
            case StatusCode: {
                return UInt16Conversions.uInt16ToStatusCode(us);
            }
            case UInt32: {
                return UInt16Conversions.uInt16ToUInt32(us);
            }
            case UInt64: {
                return UInt16Conversions.uInt16ToUInt64(us);
            }
        }
        return null;
    }
}

