/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.operators;

import com.google.common.primitives.UnsignedLongs;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.operators.ImplicitConversionBinaryOperator;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.jetbrains.annotations.Nullable;

public class GreaterThan
extends ImplicitConversionBinaryOperator<Boolean> {
    GreaterThan() {
    }

    @Override
    @Nullable
    protected Boolean apply(OperatorContext context, BaseEventTypeNode eventNode, BuiltinDataType dataType, @Nullable Object operand0, @Nullable Object operand1) {
        if (operand0 instanceof Number && operand1 instanceof Number) {
            Number n0 = (Number)operand0;
            Number n1 = (Number)operand1;
            switch (dataType) {
                case SByte: 
                case Byte: 
                case Int16: 
                case UInt16: 
                case Int32: 
                case UInt32: 
                case Int64: {
                    if (n0.longValue() > n1.longValue()) {
                        return true;
                    }
                    return false;
                }
                case UInt64: {
                    if (UnsignedLongs.compare((long)n0.longValue(), (long)n1.longValue()) > 0) {
                        return true;
                    }
                    return false;
                }
                case Float: {
                    if (n0.floatValue() > n1.floatValue()) {
                        return true;
                    }
                    return false;
                }
                case Double: {
                    if (n0.doubleValue() > n1.doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }
}

