/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import com.google.common.primitives.Bytes;
import java.security.cert.X509Certificate;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractX509IdentityValidator<T>
extends AbstractIdentityValidator<T> {
    @Override
    protected T validateX509Token(Session session, X509IdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        SecurityAlgorithm algorithm;
        ByteString clientCertificateBs = token.getCertificateData();
        X509Certificate identityCertificate = CertificateUtil.decodeCertificate((byte[])clientCertificateBs.bytesOrEmpty());
        if (tokenPolicy.getSecurityPolicyUri() != null) {
            securityPolicy = SecurityPolicy.fromUri((String)tokenPolicy.getSecurityPolicyUri());
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(tokenSignature.getAlgorithm())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by token policy");
            }
        } else {
            securityPolicy = session.getSecurityConfiguration().getSecurityPolicy();
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(tokenSignature.getAlgorithm())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by secure channel");
            }
        }
        if ((algorithm = SecurityAlgorithm.fromUri((String)tokenSignature.getAlgorithm())) != SecurityAlgorithm.None) {
            AbstractX509IdentityValidator.verifySignature(session, tokenSignature, identityCertificate, algorithm);
        }
        return this.authenticateIdentityCertificateOrThrow(session, identityCertificate);
    }

    private T authenticateIdentityCertificateOrThrow(Session session, X509Certificate identityCertificate) throws UaException {
        T identityObject = this.authenticateIdentityCertificate(session, identityCertificate);
        if (identityObject != null) {
            return identityObject;
        }
        throw new UaException(2149515264L);
    }

    @Nullable
    protected abstract T authenticateIdentityCertificate(Session var1, X509Certificate var2);

    private static void verifySignature(Session session, SignatureData tokenSignature, X509Certificate identityCertificate, SecurityAlgorithm algorithm) throws UaException {
        ByteString serverCertificateBs = session.getEndpoint().getServerCertificate();
        ByteString lastNonceBs = session.getLastNonce();
        try {
            byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
            byte[] signatureBytes = tokenSignature.getSignature().bytesOrEmpty();
            SignatureUtil.verify((SecurityAlgorithm)algorithm, (X509Certificate)identityCertificate, (byte[])dataBytes, (byte[])signatureBytes);
        }
        catch (UaException e) {
            ByteString serverCertificateChainBs = session.getSecurityConfiguration().getServerCertificateChainBytes();
            if (serverCertificateBs.equals((Object)serverCertificateChainBs)) {
                throw e;
            }
            byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateChainBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
            byte[] signatureBytes = tokenSignature.getSignature().bytesOrEmpty();
            SignatureUtil.verify((SecurityAlgorithm)algorithm, (X509Certificate)identityCertificate, (byte[])dataBytes, (byte[])signatureBytes);
        }
    }
}

