/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNodeProperties;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.TimeZoneDataType;
import org.jetbrains.annotations.Nullable;

public class UaVariableNode
extends UaNode
implements VariableNode {
    private static final DataValue INITIAL_VALUE = new DataValue(new StatusCode(1083310080L));
    private DataValue value = INITIAL_VALUE;
    private NodeId dataType = Identifiers.BaseDataType;
    private Integer valueRank = -1;
    private UInteger[] arrayDimensions = null;
    private UByte accessLevel = AccessLevel.toValue((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead});
    private UByte userAccessLevel = AccessLevel.toValue((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead});
    private Double minimumSamplingInterval = -1.0;
    private Boolean historizing = false;

    public UaVariableNode(UaNodeContext context, NodeId nodeId, VariableTypeNode variableTypeNode) {
        this(context, nodeId, variableTypeNode.getBrowseName(), variableTypeNode.getDisplayName());
        this.setDescription(variableTypeNode.getDescription());
        this.setWriteMask(variableTypeNode.getWriteMask());
        this.setUserWriteMask(variableTypeNode.getUserWriteMask());
        this.setValue(variableTypeNode.getValue());
        this.setDataType(variableTypeNode.getDataType());
        this.setValueRank(variableTypeNode.getValueRank());
        this.setArrayDimensions(variableTypeNode.getArrayDimensions());
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName);
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName, description, writeMask, userWriteMask);
    }

    public UaVariableNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(context, nodeId, NodeClass.Variable, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.accessLevel = accessLevel;
        this.userAccessLevel = userAccessLevel;
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.historizing = historizing;
    }

    public DataValue getValue() {
        return (DataValue)this.filterChain.getAttribute(this, AttributeId.Value);
    }

    public NodeId getDataType() {
        return (NodeId)this.filterChain.getAttribute(this, AttributeId.DataType);
    }

    public Integer getValueRank() {
        return (Integer)this.filterChain.getAttribute(this, AttributeId.ValueRank);
    }

    public UInteger[] getArrayDimensions() {
        return (UInteger[])this.filterChain.getAttribute(this, AttributeId.ArrayDimensions);
    }

    public UByte getAccessLevel() {
        return (UByte)this.filterChain.getAttribute(this, AttributeId.AccessLevel);
    }

    public UByte getUserAccessLevel() {
        return (UByte)this.filterChain.getAttribute(this, AttributeId.UserAccessLevel);
    }

    public Double getMinimumSamplingInterval() {
        return (Double)this.filterChain.getAttribute(this, AttributeId.MinimumSamplingInterval);
    }

    public Boolean getHistorizing() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.Historizing);
    }

    public void setValue(DataValue value) {
        this.filterChain.setAttribute(this, AttributeId.Value, value);
    }

    public void setDataType(NodeId dataType) {
        this.filterChain.setAttribute(this, AttributeId.DataType, dataType);
    }

    public void setValueRank(Integer valueRank) {
        this.filterChain.setAttribute(this, AttributeId.ValueRank, valueRank);
    }

    public void setArrayDimensions(UInteger[] arrayDimensions) {
        this.filterChain.setAttribute(this, AttributeId.ArrayDimensions, arrayDimensions);
    }

    public void setAccessLevel(UByte accessLevel) {
        this.filterChain.setAttribute(this, AttributeId.AccessLevel, accessLevel);
    }

    public void setUserAccessLevel(UByte userAccessLevel) {
        this.filterChain.setAttribute(this, AttributeId.UserAccessLevel, userAccessLevel);
    }

    public void setMinimumSamplingInterval(Double minimumSamplingInterval) {
        this.filterChain.setAttribute(this, AttributeId.MinimumSamplingInterval, minimumSamplingInterval);
    }

    public void setHistorizing(Boolean historizing) {
        this.filterChain.setAttribute(this, AttributeId.Historizing, historizing);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case Value: {
                return this.value.copy(b -> {
                    DataValue.Builder builder = b.setServerTime(DateTime.now());
                });
            }
            case DataType: {
                return this.dataType;
            }
            case ValueRank: {
                return this.valueRank;
            }
            case ArrayDimensions: {
                return this.arrayDimensions;
            }
            case AccessLevel: {
                return this.accessLevel;
            }
            case UserAccessLevel: {
                return this.userAccessLevel;
            }
            case MinimumSamplingInterval: {
                return this.minimumSamplingInterval;
            }
            case Historizing: {
                return this.historizing;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case Value: {
                this.value = (DataValue)value;
                break;
            }
            case DataType: {
                this.dataType = (NodeId)value;
                break;
            }
            case ValueRank: {
                this.valueRank = (Integer)value;
                break;
            }
            case ArrayDimensions: {
                this.arrayDimensions = (UInteger[])value;
                break;
            }
            case AccessLevel: {
                this.accessLevel = (UByte)value;
                break;
            }
            case UserAccessLevel: {
                this.userAccessLevel = (UByte)value;
                break;
            }
            case MinimumSamplingInterval: {
                this.minimumSamplingInterval = (Double)value;
                break;
            }
            case Historizing: {
                this.historizing = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public List<Node> getComponentNodes() {
        return this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public VariableTypeNode getTypeDefinitionNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_TYPE_DEFINITION_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        return node instanceof VariableTypeNode ? (VariableTypeNode)node : null;
    }

    public void addComponent(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    public void removeComponent(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasComponent, node.getNodeId().expanded(), true));
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(VariableNodeProperties.NodeVersion).orElse(null);
    }

    @Nullable
    public TimeZoneDataType getLocalTime() {
        return this.getProperty(VariableNodeProperties.LocalTime).orElse(null);
    }

    @Nullable
    public String getDataTypeVersion() {
        return this.getProperty(VariableNodeProperties.DataTypeVersion).orElse(null);
    }

    @Nullable
    public ByteString getDictionaryFragment() {
        return this.getProperty(VariableNodeProperties.DictionaryFragment).orElse(null);
    }

    @Nullable
    public Boolean getAllowNulls() {
        return this.getProperty(VariableNodeProperties.AllowNulls).orElse(null);
    }

    @Nullable
    public UInteger getMaxStringLength() {
        return this.getProperty(VariableNodeProperties.MaxStringLength).orElse(null);
    }

    @Nullable
    public UInteger getMaxArrayLength() {
        return this.getProperty(VariableNodeProperties.MaxArrayLength).orElse(null);
    }

    @Nullable
    public EUInformation getEngineeringUnits() {
        return this.getProperty(VariableNodeProperties.EngineeringUnits).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(VariableNodeProperties.NodeVersion, nodeVersion);
    }

    public void setLocalTime(TimeZoneDataType localTime) {
        this.setProperty(VariableNodeProperties.LocalTime, localTime);
    }

    public void setDataTypeVersion(String dataTypeVersion) {
        this.setProperty(VariableNodeProperties.DataTypeVersion, dataTypeVersion);
    }

    public void setDictionaryFragment(ByteString dictionaryFragment) {
        this.setProperty(VariableNodeProperties.DictionaryFragment, dictionaryFragment);
    }

    public void setAllowNulls(Boolean allowNulls) {
        this.setProperty(VariableNodeProperties.AllowNulls, allowNulls);
    }

    public void setMaxStringLength(UInteger maxStringLength) {
        this.setProperty(VariableNodeProperties.MaxStringLength, maxStringLength);
    }

    public void setMaxArrayLength(UInteger maxArrayLength) {
        this.setProperty(VariableNodeProperties.MaxArrayLength, maxArrayLength);
    }

    public void setEngineeringUnits(EUInformation engineeringUnits) {
        this.setProperty(VariableNodeProperties.EngineeringUnits, engineeringUnits);
    }

    @Deprecated
    public static UaVariableNodeBuilder builder(UaNodeContext context) {
        return new UaVariableNodeBuilder(context);
    }

    public static UaVariableNode build(UaNodeContext context, Function<UaVariableNodeBuilder, UaVariableNode> build) {
        UaVariableNodeBuilder builder = new UaVariableNodeBuilder(context);
        return build.apply(builder);
    }

    public static class UaVariableNodeBuilder
    implements Supplier<UaVariableNode> {
        private final List<AttributeFilter> attributeFilters = new ArrayList<AttributeFilter>();
        private final List<Reference> references = new ArrayList<Reference>();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private DataValue value = new DataValue(Variant.NULL_VALUE, new StatusCode(1083310080L), DateTime.NULL_VALUE, DateTime.now());
        private NodeId dataType = Identifiers.BaseDataType;
        private int valueRank = -1;
        private UInteger[] arrayDimensions = null;
        private UByte accessLevel = AccessLevel.toValue((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead});
        private UByte userAccessLevel = AccessLevel.toValue((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead});
        private Double minimumSamplingInterval = -1.0;
        private boolean historizing = false;
        private final UaNodeContext context;

        public UaVariableNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        @Override
        public UaVariableNode get() {
            return this.build();
        }

        public UaVariableNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            long hasTypeDefinitionCount = this.references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).count();
            if (hasTypeDefinitionCount == 0L) {
                this.setTypeDefinition(Identifiers.BaseDataVariableType);
            } else {
                Preconditions.checkState((hasTypeDefinitionCount == 1L ? 1 : 0) != 0, (Object)"Variable Node must have exactly one HasTypeDefinition reference.");
            }
            UaVariableNode node = new UaVariableNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.value, this.dataType, this.valueRank, this.arrayDimensions, this.accessLevel, this.userAccessLevel, this.minimumSamplingInterval, this.historizing);
            this.references.forEach(node::addReference);
            node.getFilterChain().addLast(this.attributeFilters);
            return node;
        }

        public UaVariableNode buildAndAdd() {
            UaVariableNode node = this.build();
            this.context.getNodeManager().addNode(node);
            return node;
        }

        public UaVariableNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaVariableNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaVariableNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaVariableNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaVariableNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaVariableNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaVariableNodeBuilder setValue(DataValue value) {
            this.value = value;
            return this;
        }

        public UaVariableNodeBuilder setDataType(NodeId dataType) {
            this.dataType = dataType;
            return this;
        }

        public UaVariableNodeBuilder setValueRank(int valueRank) {
            this.valueRank = valueRank;
            return this;
        }

        public UaVariableNodeBuilder setArrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return this;
        }

        public UaVariableNodeBuilder setAccessLevel(UByte accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public UaVariableNodeBuilder setAccessLevel(AccessLevel ... accessLevel) {
            this.setAccessLevel(AccessLevel.toValue((AccessLevel[])accessLevel));
            return this;
        }

        public UaVariableNodeBuilder setAccessLevel(Set<AccessLevel> accessLevel) {
            this.setAccessLevel(AccessLevel.toValue(accessLevel));
            return this;
        }

        public UaVariableNodeBuilder setUserAccessLevel(UByte userAccessLevel) {
            this.userAccessLevel = userAccessLevel;
            return this;
        }

        public UaVariableNodeBuilder setUserAccessLevel(AccessLevel ... accessLevel) {
            this.setUserAccessLevel(AccessLevel.toValue((AccessLevel[])accessLevel));
            return this;
        }

        public UaVariableNodeBuilder setUserAccessLevel(Set<AccessLevel> accessLevel) {
            this.setUserAccessLevel(AccessLevel.toValue(accessLevel));
            return this;
        }

        public UaVariableNodeBuilder setMinimumSamplingInterval(Double minimumSamplingInterval) {
            this.minimumSamplingInterval = minimumSamplingInterval;
            return this;
        }

        public UaVariableNodeBuilder setHistorizing(boolean historizing) {
            this.historizing = historizing;
            return this;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        public LocalizedText getDisplayName() {
            return this.displayName;
        }

        public LocalizedText getDescription() {
            return this.description;
        }

        public UInteger getWriteMask() {
            return this.writeMask;
        }

        public UInteger getUserWriteMask() {
            return this.userWriteMask;
        }

        public DataValue getValue() {
            return this.value;
        }

        public NodeId getDataType() {
            return this.dataType;
        }

        public int getValueRank() {
            return this.valueRank;
        }

        public UInteger[] getArrayDimensions() {
            return this.arrayDimensions;
        }

        public UByte getAccessLevel() {
            return this.accessLevel;
        }

        public UByte getUserAccessLevel() {
            return this.userAccessLevel;
        }

        public Double getMinimumSamplingInterval() {
            return this.minimumSamplingInterval;
        }

        public boolean getHistorizing() {
            return this.historizing;
        }

        public UaVariableNodeBuilder addAttributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilters.add(attributeFilter);
            return this;
        }

        public UaVariableNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }

        public UaVariableNodeBuilder setTypeDefinition(NodeId typeDefinition) {
            Objects.requireNonNull(this.nodeId, "NodeId cannot be null");
            this.references.add(new Reference(this.nodeId, Identifiers.HasTypeDefinition, typeDefinition.expanded(), true));
            return this;
        }
    }
}

