/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeTable;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.ReferenceTable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class InstanceDeclarationHierarchy {
    private final NodeId typeId;
    private final NodeTable nodeTable;
    private final ReferenceTable referenceTable;

    private InstanceDeclarationHierarchy(NodeId typeId, NodeTable nodeTable, ReferenceTable referenceTable) {
        this.typeId = typeId;
        this.nodeTable = nodeTable;
        this.referenceTable = referenceTable;
    }

    NodeTable getNodeTable() {
        return this.nodeTable;
    }

    ReferenceTable getReferenceTable() {
        return this.referenceTable;
    }

    private InstanceDeclarationHierarchy merge(InstanceDeclarationHierarchy parent) {
        NodeTable mergedNodeTable = NodeTable.merge(this.nodeTable, parent.nodeTable);
        ReferenceTable mergedReferenceTable = ReferenceTable.merge(this.referenceTable, parent.referenceTable);
        return new InstanceDeclarationHierarchy(this.typeId, mergedNodeTable, mergedReferenceTable);
    }

    public static InstanceDeclarationHierarchy create(AddressSpaceManager addressSpaceManager, NamespaceTable namespaceTable, NodeId typeDefinitionId) {
        Builder builder = new Builder(addressSpaceManager, namespaceTable);
        return builder.build(typeDefinitionId);
    }

    static /* synthetic */ InstanceDeclarationHierarchy access$0(InstanceDeclarationHierarchy instanceDeclarationHierarchy, InstanceDeclarationHierarchy instanceDeclarationHierarchy2) {
        return instanceDeclarationHierarchy.merge(instanceDeclarationHierarchy2);
    }

    static class Builder {
        private final NodeTable nodeTable = new NodeTable();
        private final ReferenceTable referenceTable = new ReferenceTable();
        private final AddressSpaceManager addressSpaceManager;
        private final NamespaceTable namespaceTable;

        Builder(AddressSpaceManager addressSpaceManager, NamespaceTable namespaceTable) {
            this.addressSpaceManager = addressSpaceManager;
            this.namespaceTable = namespaceTable;
        }

        public InstanceDeclarationHierarchy build(NodeId typeDefinitionId) {
            Optional<InstanceDeclarationHierarchy> parentIdh = this.addressSpaceManager.getManagedReferences(typeDefinitionId).stream().filter(r -> r.isInverse() && Identifiers.HasSubtype.equals((Object)r.getReferenceTypeId())).findFirst().flatMap(r -> r.getTargetNodeId().toNodeId(this.namespaceTable)).map(parentTypeId -> InstanceDeclarationHierarchy.create(this.addressSpaceManager, this.namespaceTable, parentTypeId));
            InstanceDeclarationHierarchy idh = this.buildHierarchyForType(typeDefinitionId);
            return parentIdh.map(arg_0 -> InstanceDeclarationHierarchy.access$0(idh, arg_0)).orElse(idh);
        }

        private InstanceDeclarationHierarchy buildHierarchyForType(NodeId typeDefinitionId) {
            BrowsePath browsePath = BrowsePath.ROOT;
            this.nodeTable.addNode(browsePath, typeDefinitionId);
            this.referenceTable.addReference(browsePath, Identifiers.HasTypeDefinition, typeDefinitionId.expanded());
            this.addModeledNodes(typeDefinitionId, browsePath);
            return new InstanceDeclarationHierarchy(typeDefinitionId, this.nodeTable, this.referenceTable);
        }

        private void addModeledNodes(NodeId typeDefinitionId, BrowsePath parentPath) {
            List<Reference> forwardReferences = this.addressSpaceManager.getManagedReferences(typeDefinitionId).stream().filter(Reference::isForward).collect(Collectors.toList());
            forwardReferences.forEach(reference -> this.addressSpaceManager.getManagedNode(reference.getTargetNodeId()).ifPresent(node -> {
                BrowsePath browsePath2 = new BrowsePath(parentPath, node.getBrowseName());
                if (Builder.isInstanceDeclaration(node)) {
                    this.nodeTable.addNode(browsePath2, node.getNodeId());
                    this.referenceTable.addReference(parentPath, reference.getReferenceTypeId(), browsePath2);
                    node.getReferences().stream().filter(r -> r.subtypeOf(Identifiers.NonHierarchicalReferences)).forEach(r -> this.referenceTable.addReference(browsePath2, r.getReferenceTypeId(), r.getTargetNodeId()));
                    this.addModeledNodes(node.getNodeId(), browsePath2);
                    Optional<ExpandedNodeId> instanceDeclarationTypeDefinitionId = node.getReferences().stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).findFirst().map(Reference::getTargetNodeId);
                    instanceDeclarationTypeDefinitionId.flatMap(xni -> xni.toNodeId(this.namespaceTable)).ifPresent(id -> this.addModeledNodes((NodeId)id, browsePath2));
                }
            }));
        }

        private static boolean isInstanceDeclaration(UaNode potentialMemberNode) {
            boolean methodOrObjectOrVariable;
            NodeClass nodeClass = potentialMemberNode.getNodeClass();
            boolean bl = methodOrObjectOrVariable = nodeClass == NodeClass.Method || nodeClass == NodeClass.Object || nodeClass == NodeClass.Variable;
            return methodOrObjectOrVariable && Builder.hasModellingRule(potentialMemberNode);
        }

        private static boolean hasModellingRule(UaNode potentialMemberNode) {
            return potentialMemberNode.getReferences().stream().filter(r -> Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId())).anyMatch(r -> Identifiers.ModellingRule_Mandatory.equalTo(r.getTargetNodeId()) || Identifiers.ModellingRule_Optional.equalTo(r.getTargetNodeId()));
        }
    }
}

