/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishQueue {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<ServiceRequest> serviceQueue = new LinkedList();
    private final LinkedHashMap<UInteger, WaitingSubscription> waitList = new LinkedHashMap();

    public synchronized void addRequest(ServiceRequest service) {
        ArrayList waitingSubscriptions = Lists.newArrayList(this.waitList.values());
        if (waitingSubscriptions.isEmpty()) {
            this.serviceQueue.add(service);
            this.logger.debug("Queued PublishRequest requestHandle={}, size={}", (Object)service.getRequest().getRequestHeader().getRequestHandle(), (Object)this.serviceQueue.size());
        } else {
            this.logger.debug("{} subscriptions waiting", (Object)waitingSubscriptions.size());
            WaitingSubscription subscription = null;
            int maxPriority = 0;
            long minWaitingSince = Long.MAX_VALUE;
            for (WaitingSubscription waiting : waitingSubscriptions) {
                int priority = waiting.getSubscription().getPriority();
                long waitingSince = waiting.getWaitingSince().getTime();
                this.logger.debug("subscription id={} priority={} waitingSince={}", new Object[]{waiting.getSubscription().getId(), priority, waitingSince});
                if (priority > maxPriority) {
                    maxPriority = priority;
                    minWaitingSince = Long.MAX_VALUE;
                }
                if (priority < maxPriority || waitingSince >= minWaitingSince) continue;
                minWaitingSince = waitingSince;
                subscription = waiting;
                this.logger.debug("subscription id={} priority={} now next in line", (Object)waiting.getSubscription().getId(), (Object)priority);
            }
            if (subscription != null) {
                this.waitList.remove(subscription.subscription.getId());
                this.logger.debug("delivering PublishRequest to subscription id={} priority={}", (Object)subscription.getSubscription().getId(), (Object)subscription.getSubscription().getPriority());
                WaitingSubscription ws = subscription;
                service.getServer().getConfig().getExecutor().execute(() -> waitingSubscription.subscription.onPublish(service));
            } else {
                this.serviceQueue.add(service);
            }
        }
    }

    public synchronized void addSubscription(Subscription subscription) {
        if (this.waitList.isEmpty() && !this.serviceQueue.isEmpty()) {
            ServiceRequest request = this.poll();
            if (request != null) {
                request.getServer().getConfig().getExecutor().execute(() -> subscription.onPublish(request));
            } else {
                this.waitList.putIfAbsent(subscription.getId(), new WaitingSubscription(subscription));
            }
        } else {
            this.waitList.putIfAbsent(subscription.getId(), new WaitingSubscription(subscription));
        }
    }

    public synchronized boolean isEmpty() {
        return this.serviceQueue.isEmpty();
    }

    public synchronized boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public synchronized boolean isWaitListEmpty() {
        return this.waitList.isEmpty();
    }

    @Nullable
    public synchronized ServiceRequest poll() {
        long nowNanos = System.nanoTime();
        ServiceRequest serviceRequest;
        while ((serviceRequest = this.serviceQueue.poll()) != null) {
            RequestHeader requestHeader = serviceRequest.getRequest().getRequestHeader();
            long millisSinceReceived = TimeUnit.MILLISECONDS.convert(nowNanos - serviceRequest.getReceivedAtNanos(), TimeUnit.NANOSECONDS);
            long timeoutHint = requestHeader.getTimeoutHint().longValue();
            if (timeoutHint == 0L || millisSinceReceived < timeoutHint) {
                return serviceRequest;
            }
            this.logger.debug("Discarding expired PublishRequest requestHandle={} timestamp={} timeoutHint={}", new Object[]{serviceRequest.getRequest().getRequestHeader().getRequestHandle(), requestHeader.getTimestamp().getJavaDate(), timeoutHint});
            serviceRequest.setServiceFault(0x800A0000L);
        }
        return null;
    }

    public synchronized int size() {
        return this.serviceQueue.size();
    }

    public static class WaitingSubscription {
        private final Date waitingSince = new Date();
        private final Subscription subscription;

        public WaitingSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public Date getWaitingSince() {
            return this.waitingSince;
        }
    }
}

