/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Set;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.jetbrains.annotations.Nullable;

public class AttributeUtil {
    public static DataValue dv(Object o) {
        return new DataValue(new Variant(o), StatusCode.GOOD, null, DateTime.now());
    }

    @Nullable
    public static <T> T extract(DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return null;
        }
        Object o = variant.getValue();
        if (o == null) {
            return null;
        }
        try {
            return (T)o;
        }
        catch (ClassCastException classCastException) {
            throw new UaException(2155085824L, "attribute value was not of the expected type: " + o);
        }
    }

    public static Set<AccessLevel> getAccessLevels(UaServerNode node, AttributeContext context) throws UaException {
        UByte accessLevel = (UByte)AttributeUtil.extract(node.getAttribute(context, AttributeId.AccessLevel));
        if (accessLevel != null) {
            return AccessLevel.fromValue((UByte)accessLevel);
        }
        return AccessLevel.NONE;
    }

    public static Set<AccessLevel> getUserAccessLevels(UaServerNode node, AttributeContext context) throws UaException {
        UByte userAccessLevel = (UByte)AttributeUtil.extract(node.getAttribute(context, AttributeId.UserAccessLevel));
        if (userAccessLevel != null) {
            return AccessLevel.fromValue((UByte)userAccessLevel);
        }
        return AccessLevel.NONE;
    }

    public static Set<WriteMask> getWriteMasks(UaServerNode node, AttributeContext internalContext) throws UaException {
        UInteger writeMask = (UInteger)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.WriteMask));
        if (writeMask != null) {
            return WriteMask.fromMask((UInteger)writeMask);
        }
        return WriteMask.NONE;
    }

    public static Set<WriteMask> getUserWriteMasks(UaServerNode node, AttributeContext internalContext) throws UaException {
        UInteger userWriteMask = (UInteger)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.UserWriteMask));
        if (userWriteMask != null) {
            return WriteMask.fromMask((UInteger)userWriteMask);
        }
        return WriteMask.NONE;
    }
}

