/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DataChangeTrigger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DeadbandType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataChangeFilter;

public class DataChangeMonitoringFilter {
    public static boolean filter(DataValue lastValue, DataValue currentValue, DataChangeFilter filter) {
        return DataChangeMonitoringFilter.triggerFilter(lastValue, currentValue, filter) && DataChangeMonitoringFilter.deadbandFilter(lastValue, currentValue, filter);
    }

    private static boolean triggerFilter(DataValue lastValue, DataValue currentValue, DataChangeFilter filter) {
        if (lastValue == null) {
            return true;
        }
        DataChangeTrigger trigger = filter.getTrigger();
        if (trigger == DataChangeTrigger.Status) {
            return DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
        }
        if (trigger == DataChangeTrigger.StatusValue) {
            return DataChangeMonitoringFilter.valueChanged(lastValue, currentValue) || DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
        }
        return DataChangeMonitoringFilter.timestampChanged(lastValue, currentValue) || DataChangeMonitoringFilter.valueChanged(lastValue, currentValue) || DataChangeMonitoringFilter.statusChanged(lastValue, currentValue);
    }

    private static boolean deadbandFilter(DataValue lastValue, DataValue currentValue, DataChangeFilter filter) {
        if (lastValue == null) {
            return true;
        }
        int index = filter.getDeadbandType().intValue();
        if (index < 0 || index >= DeadbandType.values().length) {
            return true;
        }
        DeadbandType deadbandType = DeadbandType.values()[index];
        if (deadbandType != DeadbandType.Absolute) {
            return true;
        }
        Object last = lastValue.getValue().getValue();
        Object current = currentValue.getValue().getValue();
        if (last == null || current == null) {
            return true;
        }
        if (last.getClass().isArray() && current.getClass().isArray()) {
            return DataChangeMonitoringFilter.compareArrayDeadband(last, current, filter.getDeadbandValue());
        }
        return DataChangeMonitoringFilter.compareScalarDeadband(last, current, filter.getDeadbandValue());
    }

    private static boolean compareArrayDeadband(Object last, Object current, double deadband) {
        Object[] lastA = (Object[])last;
        Object[] currentA = (Object[])current;
        if (lastA.length != currentA.length) {
            return true;
        }
        boolean exceeds = false;
        int i = 0;
        while (i < lastA.length) {
            exceeds = exceeds || DataChangeMonitoringFilter.exceedsDeadband(lastA[i], currentA[i], deadband);
            ++i;
        }
        return exceeds;
    }

    private static boolean compareScalarDeadband(Object last, Object current, double deadband) {
        return DataChangeMonitoringFilter.exceedsDeadband(last, current, deadband);
    }

    private static boolean exceedsDeadband(Object last, Object current, double deadband) {
        try {
            double lastD = ((Number)last).doubleValue();
            double currentD = ((Number)current).doubleValue();
            return Math.abs(lastD - currentD) > deadband;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private static boolean statusChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.getStatusCode(), currentValue.getStatusCode());
    }

    private static boolean valueChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.getValue(), currentValue.getValue());
    }

    private static boolean timestampChanged(DataValue lastValue, DataValue currentValue) {
        return !Objects.equals(lastValue.getSourceTime(), currentValue.getSourceTime());
    }
}

