/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.util.PendingRead;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;

public class SubscriptionModel
extends AbstractLifecycle {
    private final Set<DataItem> itemSet = Collections.newSetFromMap(Maps.newConcurrentMap());
    private final List<ScheduledUpdate> schedule = Lists.newCopyOnWriteArrayList();
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final ExecutionQueue executionQueue;
    private final OpcUaServer server;
    private final AttributeServices attributeServices;

    public SubscriptionModel(OpcUaServer server, AttributeServices attributeServices) {
        this.server = server;
        this.attributeServices = attributeServices;
        this.executor = server.getExecutorService();
        this.scheduler = server.getScheduledExecutorService();
        this.executionQueue = new ExecutionQueue((Executor)this.executor);
    }

    @Override
    protected void onStartup() {
    }

    @Override
    protected void onShutdown() {
        this.executionQueue.submit(() -> {
            this.schedule.forEach(ScheduledUpdate::access$0);
            this.schedule.clear();
            this.itemSet.clear();
        });
    }

    public void onDataItemsCreated(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(() -> {
            this.itemSet.addAll(items);
            this.reschedule();
        });
    }

    public void onDataItemsModified(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(this::reschedule);
    }

    public void onDataItemsDeleted(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(() -> {
            this.itemSet.removeAll(items);
            this.reschedule();
        });
    }

    public void onMonitoringModeChanged(List<MonitoredItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(this::reschedule);
    }

    private void reschedule() {
        Map<Double, List<DataItem>> bySamplingInterval = this.itemSet.stream().filter(MonitoredItem::isSamplingEnabled).collect(Collectors.groupingBy(DataItem::getSamplingInterval));
        List updates = bySamplingInterval.keySet().stream().map(samplingInterval -> {
            List items = (List)bySamplingInterval.get(samplingInterval);
            return new ScheduledUpdate((double)samplingInterval, items);
        }).collect(Collectors.toList());
        this.schedule.forEach(ScheduledUpdate::access$0);
        this.schedule.clear();
        this.schedule.addAll(updates);
        this.schedule.forEach(this.scheduler::execute);
    }

    static /* synthetic */ OpcUaServer access$0(SubscriptionModel subscriptionModel) {
        return subscriptionModel.server;
    }

    static /* synthetic */ AttributeServices access$1(SubscriptionModel subscriptionModel) {
        return subscriptionModel.attributeServices;
    }

    private class ScheduledUpdate
    implements Runnable {
        private volatile boolean cancelled = false;
        private final long samplingInterval;
        private final List<DataItem> items;

        private ScheduledUpdate(double samplingInterval, List<DataItem> items) {
            this.samplingInterval = DoubleMath.roundToLong((double)samplingInterval, (RoundingMode)RoundingMode.UP);
            this.items = items;
        }

        private void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            CompletableFuture future = GroupMapCollate.groupMapCollate(this.items, MonitoredItem::getSession, session -> sessionItems -> {
                List pending = sessionItems.stream().map(item -> new PendingRead(item.getReadValueId())).collect(Collectors.toList());
                List<ReadValueId> ids = pending.stream().map(PendingRead::getInput).collect(Collectors.toList());
                AttributeServices.ReadContext context = new AttributeServices.ReadContext(SubscriptionModel.this.server, (Session)session);
                SubscriptionModel.this.attributeServices.read(context, 0.0, TimestampsToReturn.Both, ids);
                return context.getFuture();
            });
            future.thenAcceptAsync(values -> {
                Iterator<DataItem> ii = this.items.iterator();
                Iterator vi = values.iterator();
                while (ii.hasNext() && vi.hasNext()) {
                    DataItem item = ii.next();
                    DataValue value = (DataValue)vi.next();
                    TimestampsToReturn timestamps = item.getTimestampsToReturn();
                    if (timestamps != null) {
                        UInteger attributeId = item.getReadValueId().getAttributeId();
                        value = AttributeId.Value.isEqual(attributeId) ? DataValue.derivedValue((DataValue)value, (TimestampsToReturn)timestamps) : DataValue.derivedNonValue((DataValue)value, (TimestampsToReturn)timestamps);
                    }
                    item.setValue(value);
                }
                if (!this.cancelled) {
                    SubscriptionModel.this.scheduler.schedule(this, this.samplingInterval, TimeUnit.MILLISECONDS);
                }
            }, (Executor)SubscriptionModel.this.executor);
        }

        static /* synthetic */ void access$0(ScheduledUpdate scheduledUpdate) {
            scheduledUpdate.cancel();
        }
    }
}

