/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaEnumUtil {
    public static EnumSet<NodeClass> nodeClasses(long mask) {
        ArrayList list = Lists.newArrayList();
        NodeClass[] nodeClassArray = NodeClass.values();
        int n = nodeClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeClass nc = nodeClassArray[n2];
            if ((mask & (long)nc.getValue()) == (long)nc.getValue()) {
                list.add(nc);
            }
            ++n2;
        }
        return EnumSet.copyOf(list);
    }

    public static EnumSet<BrowseResultMask> browseResultMasks(long mask) {
        ArrayList list = Lists.newArrayList();
        BrowseResultMask[] browseResultMaskArray = BrowseResultMask.values();
        int n = browseResultMaskArray.length;
        int n2 = 0;
        while (n2 < n) {
            BrowseResultMask brm = browseResultMaskArray[n2];
            if ((mask & (long)brm.getValue()) == (long)brm.getValue()) {
                list.add(brm);
            }
            ++n2;
        }
        return EnumSet.copyOf(list);
    }
}

