/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class DiscoveryClient {
    private final UaStackClient stackClient;

    public DiscoveryClient(UaStackClient stackClient) {
        this.stackClient = stackClient;
    }

    public CompletableFuture<DiscoveryClient> connect() {
        return this.stackClient.connect().thenApply(c -> this);
    }

    public CompletableFuture<DiscoveryClient> disconnect() {
        return this.stackClient.disconnect().thenApply(c -> this);
    }

    public CompletableFuture<FindServersResponse> findServers(String endpointUrl, String[] localeIds, String[] serverUris) {
        RequestHeader requestHeader = this.stackClient.newRequestHeader(NodeId.NULL_VALUE, this.stackClient.getConfig().getRequestTimeout());
        FindServersRequest request = new FindServersRequest(requestHeader, endpointUrl, localeIds, serverUris);
        return this.stackClient.sendRequest((UaRequestMessage)request).thenApply(FindServersResponse.class::cast);
    }

    public CompletableFuture<GetEndpointsResponse> getEndpoints(String endpointUrl, String[] localeIds, String[] profileUris) {
        RequestHeader header = this.stackClient.newRequestHeader(NodeId.NULL_VALUE, this.stackClient.getConfig().getRequestTimeout());
        GetEndpointsRequest request = new GetEndpointsRequest(header, endpointUrl, localeIds, profileUris);
        return this.stackClient.sendRequest((UaRequestMessage)request).thenApply(GetEndpointsResponse.class::cast);
    }

    public static CompletableFuture<List<ApplicationDescription>> findServers(String endpointUrl) {
        return DiscoveryClient.findServers(endpointUrl, b -> {});
    }

    public static CompletableFuture<List<ApplicationDescription>> findServers(String endpointUrl, Consumer<UaStackClientConfigBuilder> customizer) {
        EndpointDescription endpoint = new EndpointDescription(endpointUrl, null, null, MessageSecurityMode.None, SecurityPolicy.None.getUri(), null, "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary", Unsigned.ubyte((int)0));
        UaStackClientConfigBuilder builder = UaStackClientConfig.builder();
        builder.setEndpoint(endpoint);
        customizer.accept(builder);
        UaStackClientConfig config = builder.build();
        try {
            UaStackClient stackClient = UaStackClient.create(config);
            DiscoveryClient discoveryClient = new DiscoveryClient(stackClient);
            return ((CompletableFuture)((CompletableFuture)discoveryClient.connect().thenCompose(c -> c.findServers(endpointUrl, new String[0], new String[0]))).whenComplete((e, ex) -> {
                CompletableFuture<DiscoveryClient> completableFuture = discoveryClient.disconnect();
            })).thenApply(response -> ConversionUtil.l((Object[])response.getServers()));
        }
        catch (UaException e2) {
            return FutureUtils.failedFuture((Throwable)e2);
        }
    }

    public static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl) {
        return DiscoveryClient.getEndpoints(endpointUrl, b -> {});
    }

    public static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl, Consumer<UaStackClientConfigBuilder> customizer) {
        String profileUri;
        String scheme = EndpointUtil.getScheme((String)endpointUrl);
        switch (Strings.nullToEmpty((String)scheme).toLowerCase()) {
            case "opc.tcp": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
                break;
            }
            case "opc.https": 
            case "opc.http": 
            case "http": 
            case "https": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
                break;
            }
            case "opc.wss": 
            case "opc.ws": {
                profileUri = "http://opcfoundation.org/UA-Profile/Transport/wss-uasc-uabinary";
                break;
            }
            default: {
                return FutureUtils.failedFuture((Throwable)new UaException(0x80020000L, "unsupported protocol: " + scheme));
            }
        }
        return DiscoveryClient.getEndpoints(endpointUrl, profileUri, customizer);
    }

    private static CompletableFuture<List<EndpointDescription>> getEndpoints(String endpointUrl, String profileUri, Consumer<UaStackClientConfigBuilder> customizer) {
        EndpointDescription endpoint = new EndpointDescription(endpointUrl, null, null, MessageSecurityMode.None, SecurityPolicy.None.getUri(), null, profileUri, Unsigned.ubyte((int)0));
        UaStackClientConfigBuilder builder = UaStackClientConfig.builder();
        builder.setEndpoint(endpoint);
        customizer.accept(builder);
        UaStackClientConfig config = builder.build();
        try {
            UaStackClient stackClient = UaStackClient.create(config);
            DiscoveryClient discoveryClient = new DiscoveryClient(stackClient);
            return ((CompletableFuture)((CompletableFuture)discoveryClient.connect().thenCompose(c -> c.getEndpoints(endpointUrl, new String[0], new String[]{profileUri}))).whenComplete((e, ex) -> {
                CompletableFuture<DiscoveryClient> completableFuture = discoveryClient.disconnect();
            })).thenApply(response -> ConversionUtil.l((Object[])response.getEndpoints()));
        }
        catch (UaException e2) {
            return FutureUtils.failedFuture((Throwable)e2);
        }
    }
}

