/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfig;
import org.eclipse.milo.opcua.stack.client.transport.UaTransport;
import org.eclipse.milo.opcua.stack.client.transport.http.OpcHttpTransport;
import org.eclipse.milo.opcua.stack.client.transport.tcp.OpcTcpTransport;
import org.eclipse.milo.opcua.stack.client.transport.websocket.OpcWebSocketTransport;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaStackClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LongSequence requestHandles = new LongSequence(0L, 0xFFFFFFFFL);
    private final Map<UInteger, CompletableFuture<UaResponseMessage>> pending = Maps.newConcurrentMap();
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final DataTypeManager staticDataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final DataTypeManager dynamicDataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final SerializationContext staticSerializationContext;
    private final SerializationContext dynamicSerializationContext;
    private final UaTransport transport;
    private final ExecutionQueue deliveryQueue;
    private final UaStackClientConfig config;

    public UaStackClient(final UaStackClientConfig config, Function<UaStackClient, UaTransport> transportFactory) {
        this.config = config;
        this.deliveryQueue = new ExecutionQueue((Executor)config.getExecutor());
        this.staticSerializationContext = new SerializationContext(){

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return UaStackClient.this.namespaceTable;
            }

            public DataTypeManager getDataTypeManager() {
                return UaStackClient.this.staticDataTypeManager;
            }
        };
        this.dynamicSerializationContext = new SerializationContext(){

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return UaStackClient.this.namespaceTable;
            }

            public DataTypeManager getDataTypeManager() {
                return UaStackClient.this.dynamicDataTypeManager;
            }
        };
        this.transport = transportFactory.apply(this);
    }

    public UaStackClientConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<UaStackClient> connect() {
        return this.transport.connect().thenApply(t -> this);
    }

    public CompletableFuture<UaStackClient> disconnect() {
        return ((CompletableFuture)this.transport.disconnect().whenComplete((u, ex) -> {
            UaException disconnect = new UaException(2158821376L, "client disconnect");
            this.pending.forEach((h, cf) -> {
                boolean bl = cf.completeExceptionally(disconnect);
            });
            this.pending.clear();
        })).thenApply(t -> this);
    }

    public UaTransport getTransport() {
        return this.transport;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public DataTypeManager getStaticDataTypeManager() {
        return this.staticDataTypeManager;
    }

    public DataTypeManager getDynamicDataTypeManager() {
        return this.dynamicDataTypeManager;
    }

    public SerializationContext getStaticSerializationContext() {
        return this.staticSerializationContext;
    }

    public SerializationContext getDynamicSerializationContext() {
        return this.dynamicSerializationContext;
    }

    public RequestHeader newRequestHeader() {
        return this.newRequestHeader(NodeId.NULL_VALUE);
    }

    public RequestHeader newRequestHeader(NodeId authToken) {
        return this.newRequestHeader(authToken, this.config.getRequestTimeout());
    }

    public RequestHeader newRequestHeader(NodeId authToken, UInteger requestTimeout) {
        return new RequestHeader(authToken, DateTime.now(), Unsigned.uint((long)this.requestHandles.getAndIncrement()), Unsigned.uint((int)0), null, requestTimeout, null);
    }

    public CompletableFuture<UaResponseMessage> sendRequest(UaRequestMessage request) {
        RequestHeader requestHeader = request.getRequestHeader();
        UInteger requestHandle = requestHeader.getRequestHandle();
        CompletableFuture<UaResponseMessage> future = new CompletableFuture<UaResponseMessage>();
        this.pending.put(requestHandle, future);
        this.transport.sendRequest(request).whenComplete((response, ex) -> {
            this.pending.remove(requestHandle);
            this.deliverResponse(request, (UaResponseMessage)response, (Throwable)ex, future);
        });
        return future;
    }

    private void deliverResponse(UaRequestMessage request, @Nullable UaResponseMessage response, @Nullable Throwable failure, CompletableFuture<UaResponseMessage> future) {
        this.deliveryQueue.submit(() -> {
            if (response != null) {
                ResponseHeader header = response.getResponseHeader();
                UInteger requestHandle = header.getRequestHandle();
                if (header.getServiceResult().isGood()) {
                    future.complete(response);
                } else {
                    ServiceFault serviceFault = response instanceof ServiceFault ? (ServiceFault)response : new ServiceFault(header);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received ServiceFault request={} requestHandle={}, result={}", new Object[]{request.getClass().getSimpleName(), requestHandle, header.getServiceResult()});
                    }
                    future.completeExceptionally((Throwable)new UaServiceFaultException(serviceFault));
                }
            } else {
                assert (failure != null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("sendRequest() failed, request={}, requestHandle={}", new Object[]{request.getClass().getSimpleName(), request.getRequestHeader().getRequestHandle(), failure});
                }
                future.completeExceptionally(failure);
            }
        });
    }

    public static UaStackClient create(UaStackClientConfig config) throws UaException {
        String transportProfileUri = config.getEndpoint().getTransportProfileUri();
        TransportProfile transportProfile = TransportProfile.fromUri((String)transportProfileUri);
        return new UaStackClient(config, switch (transportProfile) {
            case TransportProfile.TCP_UASC_UABINARY -> OpcTcpTransport::new;
            case TransportProfile.HTTPS_UABINARY -> OpcHttpTransport::new;
            case TransportProfile.WSS_UASC_UABINARY -> OpcWebSocketTransport::new;
            default -> throw new UaException(0x80020000L, "unsupported transport: " + transportProfileUri);
        });
    }
}

