/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.jetbrains.annotations.Nullable;

public enum BuiltinDataType {
    Boolean(1, Boolean.class),
    SByte(2, Byte.class),
    Byte(3, UByte.class),
    Int16(4, Short.class),
    UInt16(5, UShort.class),
    Int32(6, Integer.class),
    UInt32(7, UInteger.class),
    Int64(8, Long.class),
    UInt64(9, ULong.class),
    Float(10, Float.class),
    Double(11, Double.class),
    String(12, String.class),
    DateTime(13, DateTime.class),
    Guid(14, UUID.class),
    ByteString(15, ByteString.class),
    XmlElement(16, XmlElement.class),
    NodeId(17, NodeId.class),
    ExpandedNodeId(18, ExpandedNodeId.class),
    StatusCode(19, StatusCode.class),
    QualifiedName(20, QualifiedName.class),
    LocalizedText(21, LocalizedText.class),
    ExtensionObject(22, ExtensionObject.class),
    DataValue(23, DataValue.class),
    Variant(24, Variant.class),
    DiagnosticInfo(25, DiagnosticInfo.class);

    private final int typeId;
    private final Class<?> backingClass;
    private static final BiMap<Integer, Class<?>> BackingClassesById;
    private static final BiMap<NodeId, Class<?>> BackingClassesByNodeId;
    private static final BiMap<NodeId, BuiltinDataType> DataTypesByNodeId;

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder builder2 = ImmutableBiMap.builder();
        ImmutableBiMap.Builder builder3 = ImmutableBiMap.builder();
        BuiltinDataType[] builtinDataTypeArray = BuiltinDataType.values();
        int n = builtinDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinDataType dataType = builtinDataTypeArray[n2];
            builder.put((Object)dataType.getTypeId(), dataType.getBackingClass());
            builder2.put((Object)dataType.getNodeId(), dataType.getBackingClass());
            builder3.put((Object)dataType.getNodeId(), (Object)dataType);
            ++n2;
        }
        BackingClassesById = builder.build();
        BackingClassesByNodeId = builder2.build();
        DataTypesByNodeId = builder3.build();
    }

    private BuiltinDataType(int typeId, Class<?> backingClass) {
        this.typeId = typeId;
        this.backingClass = backingClass;
    }

    public NodeId getNodeId() {
        return new NodeId(0, this.typeId);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public Class<?> getBackingClass() {
        return this.backingClass;
    }

    public static int getBuiltinTypeId(Class<?> backingClass) {
        return (Integer)BackingClassesById.inverse().get(BuiltinDataType.maybeBoxPrimitive(backingClass));
    }

    @Nullable
    public static Class<?> getBackingClass(int typeId) {
        return (Class)BackingClassesById.get((Object)typeId);
    }

    @Nullable
    public static Class<?> getBackingClass(NodeId typeId) {
        return (Class)BackingClassesByNodeId.get((Object)typeId);
    }

    @Nullable
    public static Class<?> getBackingClass(ExpandedNodeId typeId) {
        if (typeId.getNamespaceIndex().intValue() == 0 && typeId.getType() == IdType.Numeric) {
            Number id = (Number)typeId.getIdentifier();
            return (Class)BackingClassesById.get((Object)id.intValue());
        }
        return null;
    }

    @Nullable
    public static BuiltinDataType fromBackingClass(Class<?> backingClass) {
        NodeId nodeId = (NodeId)BackingClassesByNodeId.inverse().get(BuiltinDataType.maybeBoxPrimitive(backingClass));
        return nodeId != null ? (BuiltinDataType)((Object)DataTypesByNodeId.get((Object)nodeId)) : null;
    }

    @Nullable
    public static BuiltinDataType fromNodeId(NodeId nodeId) {
        return (BuiltinDataType)((Object)DataTypesByNodeId.get((Object)nodeId));
    }

    @Nullable
    public static BuiltinDataType fromNodeId(ExpandedNodeId nodeId) {
        if (nodeId.getIdentifier() instanceof UInteger && ("http://opcfoundation.org/UA/".equals(nodeId.getNamespaceUri()) || nodeId.getNamespaceIndex().intValue() == 0)) {
            return BuiltinDataType.fromNodeId(new NodeId(0, (UInteger)nodeId.getIdentifier()));
        }
        return null;
    }

    public static boolean isBuiltin(int typeId) {
        return BackingClassesById.containsKey((Object)typeId);
    }

    public static boolean isBuiltin(NodeId typeId) {
        return BackingClassesByNodeId.containsKey((Object)typeId);
    }

    public static boolean isBuiltin(ExpandedNodeId typeId) {
        return BuiltinDataType.fromNodeId(typeId) != null;
    }

    private static Class<?> maybeBoxPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == java.lang.Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == java.lang.Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == java.lang.Float.TYPE) {
                return Float.class;
            }
            if (clazz == java.lang.Double.TYPE) {
                return Double.class;
            }
        }
        return clazz;
    }
}

