/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.MessageEncodeException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.SecureMessageHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.SequenceHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.SymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;

public final class ChunkEncoder {
    private final AsymmetricEncoder asymmetricEncoder = new AsymmetricEncoder();
    private final SymmetricEncoder symmetricEncoder = new SymmetricEncoder();
    private final LongSequence sequenceNumber = new LongSequence(1L, 0xFFFFFBFFL);
    private final ChannelParameters parameters;

    public ChunkEncoder(ChannelParameters parameters) {
        this.parameters = parameters;
    }

    public EncodedMessage encodeAsymmetric(SecureChannel channel, long requestId, ByteBuf messageBuffer, MessageType messageType) throws MessageEncodeException {
        return this.encode(this.asymmetricEncoder, channel, requestId, messageBuffer, messageType);
    }

    public EncodedMessage encodeSymmetric(SecureChannel channel, long requestId, ByteBuf messageBuffer, MessageType messageType) throws MessageEncodeException {
        return this.encode(this.symmetricEncoder, channel, requestId, messageBuffer, messageType);
    }

    private EncodedMessage encode(AbstractEncoder encoder, SecureChannel channel, long requestId, ByteBuf messageBuffer, MessageType messageType) throws MessageEncodeException {
        ArrayList<ByteBuf> chunks = new ArrayList<ByteBuf>();
        try {
            return encoder.encode(chunks, channel, requestId, messageBuffer, messageType);
        }
        catch (UaException e) {
            chunks.forEach(ReferenceCountUtil::safeRelease);
            throw new MessageEncodeException(e);
        }
    }

    private abstract class AbstractEncoder {
        private AbstractEncoder() {
        }

        /*
         * Unable to fully structure code
         */
        EncodedMessage encode(List<ByteBuf> chunks, SecureChannel channel, long requestId, ByteBuf messageBuffer, MessageType messageType) throws UaException {
            encrypted = this.isEncryptionEnabled(channel);
            securityHeaderSize = this.getSecurityHeaderSize(channel);
            cipherTextBlockSize = this.getCipherTextBlockSize(channel);
            plainTextBlockSize = this.getPlainTextBlockSize(channel);
            signatureSize = this.getSignatureSize(channel);
            maxChunkSize = ChunkEncoder.this.parameters.getLocalSendBufferSize();
            paddingOverhead = encrypted ? (cipherTextBlockSize > 256 ? 2 : 1) : 0;
            maxCipherTextSize = maxChunkSize - 12 - securityHeaderSize;
            maxCipherTextBlocks = maxCipherTextSize / cipherTextBlockSize;
            maxPlainTextSize = maxCipherTextBlocks * plainTextBlockSize;
            maxBodySize = maxPlainTextSize - 8 - paddingOverhead - signatureSize;
            if (AbstractEncoder.$assertionsDisabled || maxPlainTextSize + securityHeaderSize + 12 <= maxChunkSize) ** GOTO lbl78
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                bodySize = Math.min(messageBuffer.readableBytes(), maxBodySize);
                paddingSize = encrypted != false ? ((remaining = (plainTextSize = 8 + bodySize + paddingOverhead + signatureSize) % plainTextBlockSize) > 0 ? plainTextBlockSize - remaining : 0) : 0;
                plainTextContentSize = 8 + bodySize + signatureSize + paddingSize + paddingOverhead;
                if (!AbstractEncoder.$assertionsDisabled && plainTextContentSize % plainTextBlockSize != 0) {
                    throw new AssertionError();
                }
                chunkSize = 12 + securityHeaderSize + plainTextContentSize / plainTextBlockSize * cipherTextBlockSize;
                if (!AbstractEncoder.$assertionsDisabled && chunkSize > maxChunkSize) {
                    throw new AssertionError();
                }
                chunkBuffer = BufferUtil.pooledBuffer(chunkSize);
                chunks.add(chunkBuffer);
                remoteMaxChunkCount = ChunkEncoder.this.parameters.getRemoteMaxChunkCount();
                if (remoteMaxChunkCount > 0 && chunks.size() > remoteMaxChunkCount) {
                    throw new UaException(0x80080000L, "remote chunk count exceeded: " + remoteMaxChunkCount);
                }
                messageHeader = new SecureMessageHeader(messageType, messageBuffer.readableBytes() > bodySize ? 'C' : 'F', chunkSize, channel.getChannelId());
                SecureMessageHeader.encode(messageHeader, chunkBuffer);
                this.encodeSecurityHeader(channel, chunkBuffer);
                sequenceHeader = new SequenceHeader(ChunkEncoder.this.sequenceNumber.getAndIncrement(), requestId);
                SequenceHeader.encode(sequenceHeader, chunkBuffer);
                chunkBuffer.writeBytes(messageBuffer, bodySize);
                if (encrypted) {
                    this.writePadding(cipherTextBlockSize, paddingSize, chunkBuffer);
                }
                if (this.isSigningEnabled(channel)) {
                    chunkNioBuffer = chunkBuffer.nioBuffer(0, chunkBuffer.writerIndex());
                    signature = this.signChunk(channel, chunkNioBuffer);
                    chunkBuffer.writeBytes(signature);
                }
                if (encrypted) {
                    chunkBuffer.readerIndex(12 + securityHeaderSize);
                    if (!AbstractEncoder.$assertionsDisabled && chunkBuffer.readableBytes() % plainTextBlockSize != 0) {
                        throw new AssertionError();
                    }
                    try {
                        blockCount = chunkBuffer.readableBytes() / plainTextBlockSize;
                        chunkNioBuffer = chunkBuffer.nioBuffer(chunkBuffer.readerIndex(), blockCount * cipherTextBlockSize);
                        copyBuffer = chunkBuffer.copy();
                        plainTextNioBuffer = copyBuffer.nioBuffer();
                        cipher = this.getCipher(channel);
                        if (this.isAsymmetric()) {
                            blockNumber = 0;
                            while (blockNumber < blockCount) {
                                position = blockNumber * plainTextBlockSize;
                                limit = (blockNumber + 1) * plainTextBlockSize;
                                plainTextNioBuffer.position(position);
                                plainTextNioBuffer.limit(limit);
                                bytesWritten = cipher.doFinal(plainTextNioBuffer, chunkNioBuffer);
                                if (!AbstractEncoder.$assertionsDisabled && bytesWritten != cipherTextBlockSize) {
                                    throw new AssertionError();
                                }
                                ++blockNumber;
                            }
                        } else {
                            cipher.doFinal(plainTextNioBuffer, chunkNioBuffer);
                        }
                        copyBuffer.release();
                    }
                    catch (GeneralSecurityException e) {
                        throw new UaException(2148728832L, (Throwable)e);
                    }
                }
                chunkBuffer.readerIndex(0).writerIndex(chunkSize);
lbl78:
                // 2 sources

                ** while (messageBuffer.readableBytes() > 0)
            }
lbl79:
            // 1 sources

            return new EncodedMessage(chunks, requestId);
        }

        private void writePadding(int cipherTextBlockSize, int paddingSize, ByteBuf buffer) {
            buffer.writeByte(paddingSize);
            int i = 0;
            while (i < paddingSize) {
                buffer.writeByte(paddingSize);
                ++i;
            }
            if (cipherTextBlockSize > 256) {
                int paddingLengthMsb = paddingSize >> 8 & 0xFF;
                buffer.writeByte(paddingLengthMsb);
            }
        }

        protected abstract byte[] signChunk(SecureChannel var1, ByteBuffer var2) throws UaException;

        protected abstract void encodeSecurityHeader(SecureChannel var1, ByteBuf var2) throws UaException;

        protected abstract Cipher getCipher(SecureChannel var1) throws UaException;

        protected abstract int getSecurityHeaderSize(SecureChannel var1) throws UaException;

        protected abstract int getCipherTextBlockSize(SecureChannel var1);

        protected abstract int getPlainTextBlockSize(SecureChannel var1);

        protected abstract int getSignatureSize(SecureChannel var1);

        protected abstract boolean isAsymmetric();

        protected abstract boolean isEncryptionEnabled(SecureChannel var1);

        protected abstract boolean isSigningEnabled(SecureChannel var1);
    }

    private final class AsymmetricEncoder
    extends AbstractEncoder {
        private AsymmetricEncoder() {
        }

        @Override
        public byte[] signChunk(SecureChannel channel, ByteBuffer chunkNioBuffer) throws UaException {
            return SignatureUtil.sign(channel.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), channel.getKeyPair().getPrivate(), chunkNioBuffer);
        }

        @Override
        public Cipher getCipher(SecureChannel channel) throws UaException {
            X509Certificate remoteCertificate = channel.getRemoteCertificate();
            assert (remoteCertificate != null);
            try {
                String transformation = channel.getSecurityPolicy().getAsymmetricEncryptionAlgorithm().getTransformation();
                Cipher cipher = Cipher.getInstance(transformation);
                cipher.init(1, remoteCertificate.getPublicKey());
                return cipher;
            }
            catch (GeneralSecurityException e) {
                throw new UaException(2148728832L, (Throwable)e);
            }
        }

        @Override
        public void encodeSecurityHeader(SecureChannel channel, ByteBuf buffer) throws UaException {
            AsymmetricSecurityHeader header = new AsymmetricSecurityHeader(channel.getSecurityPolicy().getUri(), channel.getLocalCertificateChainBytes(), channel.getRemoteCertificateThumbprint());
            AsymmetricSecurityHeader.encode(header, buffer);
        }

        @Override
        public int getSecurityHeaderSize(SecureChannel channel) throws UaException {
            String securityPolicyUri = channel.getSecurityPolicy().getUri();
            byte[] localCertificateChainBytes = channel.getLocalCertificateChainBytes().bytes();
            byte[] remoteCertificateThumbprint = channel.getRemoteCertificateThumbprint().bytes();
            return 12 + securityPolicyUri.length() + (localCertificateChainBytes != null ? localCertificateChainBytes.length : 0) + (remoteCertificateThumbprint != null ? remoteCertificateThumbprint.length : 0);
        }

        @Override
        public int getCipherTextBlockSize(SecureChannel channel) {
            return channel.getRemoteAsymmetricCipherTextBlockSize();
        }

        @Override
        public int getPlainTextBlockSize(SecureChannel channel) {
            return channel.getRemoteAsymmetricPlainTextBlockSize();
        }

        @Override
        public int getSignatureSize(SecureChannel channel) {
            return channel.getLocalAsymmetricSignatureSize();
        }

        @Override
        protected boolean isAsymmetric() {
            return true;
        }

        @Override
        public boolean isEncryptionEnabled(SecureChannel channel) {
            return channel.isAsymmetricEncryptionEnabled();
        }

        @Override
        public boolean isSigningEnabled(SecureChannel channel) {
            return channel.isAsymmetricSigningEnabled();
        }
    }

    public static class EncodedMessage {
        private final List<ByteBuf> messageChunks;
        private final long requestId;

        public EncodedMessage(List<ByteBuf> messageChunks, long requestId) {
            this.messageChunks = messageChunks;
            this.requestId = requestId;
        }

        public List<ByteBuf> getMessageChunks() {
            return this.messageChunks;
        }

        public long getRequestId() {
            return this.requestId;
        }
    }

    private final class SymmetricEncoder
    extends AbstractEncoder {
        private volatile ChannelSecurity.SecurityKeys securityKeys;
        private volatile Cipher cipher = null;
        private volatile long cipherId = -1L;

        private SymmetricEncoder() {
        }

        @Override
        public void encodeSecurityHeader(SecureChannel channel, ByteBuf buffer) throws UaException {
            ChannelSecurity channelSecurity = channel.getChannelSecurity();
            long tokenId = channelSecurity != null ? channelSecurity.getCurrentToken().getTokenId().longValue() : 0L;
            SymmetricSecurityHeader.encode(new SymmetricSecurityHeader(tokenId), buffer);
            ChannelSecurity.SecurityKeys securityKeys = this.securityKeys = channelSecurity != null ? channelSecurity.getCurrentKeys() : null;
            if (this.cipherId != tokenId && channel.isSymmetricEncryptionEnabled()) {
                this.cipher = this.initCipher(channel);
                this.cipherId = tokenId;
            }
        }

        @Override
        public byte[] signChunk(SecureChannel channel, ByteBuffer chunkNioBuffer) throws UaException {
            SecurityAlgorithm signatureAlgorithm = channel.getSecurityPolicy().getSymmetricSignatureAlgorithm();
            byte[] signatureKey = channel.getEncryptionKeys(this.securityKeys).getSignatureKey();
            return SignatureUtil.hmac(signatureAlgorithm, signatureKey, chunkNioBuffer);
        }

        @Override
        public Cipher getCipher(SecureChannel channel) {
            assert (this.cipher != null);
            return this.cipher;
        }

        @Override
        public int getSecurityHeaderSize(SecureChannel channel) {
            return 4;
        }

        @Override
        public int getCipherTextBlockSize(SecureChannel channel) {
            return channel.getSymmetricBlockSize();
        }

        @Override
        public int getPlainTextBlockSize(SecureChannel channel) {
            return channel.getSymmetricBlockSize();
        }

        @Override
        public int getSignatureSize(SecureChannel channel) {
            return channel.getSymmetricSignatureSize();
        }

        @Override
        protected boolean isAsymmetric() {
            return false;
        }

        @Override
        public boolean isEncryptionEnabled(SecureChannel channel) {
            return channel.isSymmetricEncryptionEnabled();
        }

        @Override
        public boolean isSigningEnabled(SecureChannel channel) {
            return channel.isSymmetricSigningEnabled();
        }

        private Cipher initCipher(SecureChannel channel) throws UaException {
            try {
                String transformation = channel.getSecurityPolicy().getSymmetricEncryptionAlgorithm().getTransformation();
                ChannelSecurity.SecretKeys secretKeys = channel.getEncryptionKeys(this.securityKeys);
                SecretKeySpec keySpec = new SecretKeySpec(secretKeys.getEncryptionKey(), "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(secretKeys.getInitializationVector());
                Cipher cipher = Cipher.getInstance(transformation);
                cipher.init(1, (Key)keySpec, ivSpec);
                assert (cipher.getBlockSize() == channel.getSymmetricBlockSize());
                return cipher;
            }
            catch (GeneralSecurityException e) {
                throw new UaException(2148728832L, (Throwable)e);
            }
        }
    }
}

