/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class OpcUaBinaryStreamEncoder
implements UaEncoder {
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final Charset CHARSET_UTF16 = StandardCharsets.UTF_16;
    private ByteBuf buffer;
    private int currentByte;
    private int bitCount;
    private final SerializationContext context;

    public OpcUaBinaryStreamEncoder(SerializationContext context) {
        this.context = context;
    }

    public OpcUaBinaryStreamEncoder setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    public <T> void writeArray(T[] values, Consumer<T> write) throws UaSerializationException {
        if (values == null) {
            this.buffer.writeIntLE(-1);
        } else {
            if (values.length > this.context.getEncodingLimits().getMaxMessageSize()) {
                throw new UaSerializationException(0x80080000L, "array length exceeds max message size");
            }
            this.writeInt32(values.length);
            T[] TArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                write.accept(t);
                ++n2;
            }
        }
    }

    public void writeBit(int value) throws UaSerializationException {
        this.currentByte |= (value & 1) << this.bitCount;
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.buffer.writeByte(this.currentByte);
            this.currentByte = 0;
            this.bitCount = 0;
        }
    }

    public void writeBoolean(Boolean value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeBoolean(false);
        } else {
            this.buffer.writeBoolean(value.booleanValue());
        }
    }

    public void writeSByte(Byte value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte((int)value.byteValue());
        }
    }

    public void writeByte(UByte value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(value.intValue());
        }
    }

    public void writeInt16(Short value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeShortLE(0);
        } else {
            this.buffer.writeShortLE((int)value.shortValue());
        }
    }

    public void writeUInt16(UShort value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeShortLE(0);
        } else {
            this.buffer.writeShortLE(value.intValue());
        }
    }

    public void writeInt32(Integer value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeIntLE(0);
        } else {
            this.buffer.writeIntLE(value.intValue());
        }
    }

    public void writeUInt32(UInteger value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeIntLE(0);
        } else {
            this.buffer.writeIntLE(value.intValue());
        }
    }

    public void writeInt64(Long value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeLongLE(0L);
        } else {
            this.buffer.writeLongLE(value.longValue());
        }
    }

    public void writeUInt64(ULong value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeLongLE(0L);
        } else {
            this.buffer.writeLongLE(value.longValue());
        }
    }

    public void writeFloat(Float value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeFloatLE(0.0f);
        } else {
            this.buffer.writeFloatLE(value.floatValue());
        }
    }

    public void writeDouble(Double value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeDoubleLE(0.0);
        } else {
            this.buffer.writeDoubleLE(value.doubleValue());
        }
    }

    public void writeCharacter(Character value) throws UaSerializationException {
        this.buffer.writeByte(value.charValue() & 0xFF);
    }

    public void writeWideChar(Character value) throws UaSerializationException {
        this.buffer.writeChar((int)value.charValue());
    }

    public void writeUtf8NullTerminatedString(String value) throws UaSerializationException {
        if (value != null) {
            byte[] bytes;
            byte[] byArray = bytes = value.getBytes(CHARSET_UTF8);
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.buffer.writeByte((int)b);
                if (b == 0) {
                    return;
                }
                ++n2;
            }
        }
        this.buffer.writeByte(0);
    }

    public void writeUtf8CharArray(String value) throws UaSerializationException {
        if (value == null) {
            this.writeInt32(-1);
        } else {
            this.writeLengthPrefixedString(value, CHARSET_UTF8);
        }
    }

    public void writeUtf16NullTerminatedString(String value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            int i = 0;
            while (i < value.length()) {
                int c = value.codePointAt(i);
                this.buffer.writeChar(c);
                if (c == 0) {
                    return;
                }
                ++i;
            }
            this.buffer.writeChar(0);
        }
    }

    public void writeUtf16CharArray(String value) throws UaSerializationException {
        if (value == null) {
            this.writeInt32(-1);
        } else {
            this.writeLengthPrefixedString(value, CHARSET_UTF16);
        }
    }

    public void writeDateTime(DateTime value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeLongLE(0L);
        } else {
            this.buffer.writeLongLE(value.getUtcTime());
        }
    }

    public void writeByteString(ByteString value) throws UaSerializationException {
        if (value == null || value.isNull()) {
            this.buffer.writeIntLE(-1);
        } else {
            byte[] bytes = value.bytes();
            assert (bytes != null);
            this.buffer.writeIntLE(bytes.length);
            this.buffer.writeBytes(bytes);
        }
    }

    public void writeGuid(UUID value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeZero(16);
        } else {
            long msb = value.getMostSignificantBits();
            long lsb = value.getLeastSignificantBits();
            this.buffer.writeIntLE((int)(msb >>> 32));
            this.buffer.writeShortLE((int)(msb >>> 16) & 0xFFFF);
            this.buffer.writeShortLE((int)msb & 0xFFFF);
            this.buffer.writeLong(lsb);
        }
    }

    public void writeXmlElement(XmlElement value) throws UaSerializationException {
        if (value == null || value.isNull()) {
            this.buffer.writeIntLE(-1);
        } else {
            this.writeByteString(new ByteString(value.getFragment().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public void writeDataValue(DataValue value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            int mask = 0;
            if (value.getValue() != null && value.getValue().isNotNull()) {
                mask |= 1;
            }
            if (!StatusCode.GOOD.equals(value.getStatusCode())) {
                mask |= 2;
            }
            if (value.getSourceTime() != null && !DateTime.MIN_VALUE.equals(value.getSourceTime())) {
                mask |= 4;
            }
            if (value.getServerTime() != null && !DateTime.MIN_VALUE.equals(value.getServerTime())) {
                mask |= 8;
            }
            if (value.getSourcePicoseconds() != null && value.getSourcePicoseconds().intValue() != 0) {
                mask |= 0x10;
            }
            if (value.getServerPicoseconds() != null && value.getServerPicoseconds().intValue() != 0) {
                mask |= 0x20;
            }
            this.buffer.writeByte(mask);
            if ((mask & 1) == 1) {
                this.writeVariant(value.getValue());
            }
            if ((mask & 2) == 2) {
                this.writeStatusCode(value.getStatusCode());
            }
            if ((mask & 4) == 4) {
                this.writeDateTime(value.getSourceTime());
            }
            if ((mask & 0x10) == 16) {
                this.writeUInt16(value.getSourcePicoseconds());
            }
            if ((mask & 8) == 8) {
                this.writeDateTime(value.getServerTime());
            }
            if ((mask & 0x20) == 32) {
                this.writeUInt16(value.getServerPicoseconds());
            }
        }
    }

    public void writeDiagnosticInfo(DiagnosticInfo value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            int mask = 127;
            if (value.getSymbolicId() == -1) {
                mask ^= 1;
            }
            if (value.getNamespaceUri() == -1) {
                mask ^= 2;
            }
            if (value.getLocalizedText() == -1) {
                mask ^= 4;
            }
            if (value.getLocale() == -1) {
                mask ^= 8;
            }
            if (value.getAdditionalInfo() == null || value.getAdditionalInfo().isEmpty()) {
                mask ^= 0x10;
            }
            if (value.getInnerStatusCode() == null) {
                mask ^= 0x20;
            }
            if (value.getInnerDiagnosticInfo() == null) {
                mask ^= 0x40;
            }
            this.buffer.writeByte(mask);
            if ((mask & 1) == 1) {
                this.writeInt32(value.getSymbolicId());
            }
            if ((mask & 2) == 2) {
                this.writeInt32(value.getNamespaceUri());
            }
            if ((mask & 4) == 4) {
                this.writeInt32(value.getLocalizedText());
            }
            if ((mask & 8) == 8) {
                this.writeInt32(value.getLocale());
            }
            if ((mask & 0x10) == 16) {
                this.writeString(value.getAdditionalInfo());
            }
            if ((mask & 0x20) == 32) {
                this.writeStatusCode(value.getInnerStatusCode());
            }
            if ((mask & 0x40) == 64) {
                this.writeDiagnosticInfo(value.getInnerDiagnosticInfo());
            }
        }
    }

    public void writeExpandedNodeId(ExpandedNodeId value) throws UaSerializationException {
        UShort index;
        if (value == null) {
            value = ExpandedNodeId.NULL_VALUE;
        }
        int flags = 0;
        String namespaceUri = value.getNamespaceUri();
        UInteger serverIndex = value.getServerIndex();
        if (namespaceUri != null && namespaceUri.length() > 0) {
            flags |= 0x80;
        }
        if (serverIndex.longValue() > 0L) {
            flags |= 0x40;
        }
        if ((index = value.getNamespaceIndex()) == null) {
            index = UShort.MIN;
        }
        int namespaceIndex = index.intValue();
        if (value.getType() == IdType.Numeric) {
            UInteger identifier = (UInteger)value.getIdentifier();
            long idv = identifier.longValue();
            if (namespaceIndex == 0 && idv >= 0L && idv <= 255L) {
                this.buffer.writeByte(flags);
                this.buffer.writeByte((int)idv);
            } else if (namespaceIndex >= 0 && namespaceIndex <= 255 && idv <= 65535L) {
                this.buffer.writeByte(1 | flags);
                this.buffer.writeByte(namespaceIndex);
                this.buffer.writeShortLE((int)idv);
            } else {
                this.buffer.writeByte(2 | flags);
                this.buffer.writeShortLE(namespaceIndex);
                this.buffer.writeIntLE((int)idv);
            }
        } else if (value.getType() == IdType.String) {
            String identifier = (String)value.getIdentifier();
            this.buffer.writeByte(3 | flags);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeString(identifier);
        } else if (value.getType() == IdType.Guid) {
            UUID identifier = (UUID)value.getIdentifier();
            this.buffer.writeByte(4 | flags);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeGuid(identifier);
        } else if (value.getType() == IdType.Opaque) {
            ByteString identifier = (ByteString)value.getIdentifier();
            this.buffer.writeByte(5 | flags);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeByteString(identifier);
        } else {
            throw new UaSerializationException(0x80060000L, "invalid identifier: " + value.getIdentifier());
        }
        if (namespaceUri != null && namespaceUri.length() > 0) {
            this.writeString(namespaceUri);
        }
        if (serverIndex.longValue() > 0L) {
            this.writeUInt32(serverIndex);
        }
    }

    public void writeExtensionObject(ExtensionObject value) throws UaSerializationException {
        if (value == null || value.getBody() == null) {
            this.writeNodeId(NodeId.NULL_VALUE);
            this.buffer.writeByte(0);
        } else {
            Object body = value.getBody();
            switch (value.getBodyType()) {
                case ByteString: {
                    ByteString byteString = (ByteString)body;
                    this.writeNodeId(value.getEncodingId());
                    this.buffer.writeByte(1);
                    this.writeByteString(byteString);
                    break;
                }
                case XmlElement: {
                    XmlElement xmlElement = (XmlElement)body;
                    this.writeNodeId(value.getEncodingId());
                    this.buffer.writeByte(2);
                    this.writeXmlElement(xmlElement);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown body type: " + (Object)((Object)value.getBodyType()));
                }
            }
        }
    }

    public void writeLocalizedText(LocalizedText value) throws UaSerializationException {
        if (value == null) {
            value = LocalizedText.NULL_VALUE;
        }
        String locale = value.getLocale();
        String text = value.getText();
        int mask = 3;
        if (locale == null || locale.isEmpty()) {
            mask ^= 1;
        }
        if (text == null || text.isEmpty()) {
            mask ^= 2;
        }
        this.buffer.writeByte(mask);
        if (locale != null && !locale.isEmpty()) {
            this.writeString(locale);
        }
        if (text != null && !text.isEmpty()) {
            this.writeString(text);
        }
    }

    public void writeNodeId(NodeId value) throws UaSerializationException {
        if (value == null) {
            value = NodeId.NULL_VALUE;
        }
        int namespaceIndex = value.getNamespaceIndex().intValue();
        if (value.getType() == IdType.Numeric) {
            UInteger identifier = (UInteger)value.getIdentifier();
            long idv = identifier.longValue();
            if (namespaceIndex == 0 && idv >= 0L && idv <= 255L) {
                this.buffer.writeByte(0);
                this.buffer.writeByte((int)idv);
            } else if (namespaceIndex >= 0 && namespaceIndex <= 255 && idv <= 65535L) {
                this.buffer.writeByte(1);
                this.buffer.writeByte(namespaceIndex);
                this.buffer.writeShortLE((int)idv);
            } else {
                this.buffer.writeByte(2);
                this.buffer.writeShortLE(namespaceIndex);
                this.buffer.writeIntLE((int)idv);
            }
        } else if (value.getType() == IdType.String) {
            String identifier = (String)value.getIdentifier();
            this.buffer.writeByte(3);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeString(identifier);
        } else if (value.getType() == IdType.Guid) {
            UUID identifier = (UUID)value.getIdentifier();
            this.buffer.writeByte(4);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeGuid(identifier);
        } else if (value.getType() == IdType.Opaque) {
            ByteString identifier = (ByteString)value.getIdentifier();
            this.buffer.writeByte(5);
            this.buffer.writeShortLE(namespaceIndex);
            this.writeByteString(identifier);
        } else {
            throw new UaSerializationException(0x80060000L, "invalid identifier: " + value.getIdentifier());
        }
    }

    public void writeQualifiedName(QualifiedName value) throws UaSerializationException {
        if (value == null) {
            value = QualifiedName.NULL_VALUE;
        }
        this.writeUInt16(value.getNamespaceIndex());
        this.writeString(value.getName());
    }

    public void writeString(String value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeIntLE(-1);
        } else {
            this.writeLengthPrefixedString(value, CHARSET_UTF8);
        }
    }

    public void writeStatusCode(StatusCode value) throws UaSerializationException {
        if (value == null) {
            this.buffer.writeIntLE(0);
        } else {
            this.buffer.writeIntLE((int)value.getValue());
        }
    }

    public void writeVariant(Variant variant) throws UaSerializationException {
        Object value = variant.getValue();
        if (value == null) {
            this.buffer.writeByte(0);
        } else {
            boolean structure = false;
            boolean enumeration = false;
            Class<Object> valueClass = this.getClass(value);
            if (UaStructure.class.isAssignableFrom(valueClass)) {
                valueClass = ExtensionObject.class;
                structure = true;
            } else if (UaEnumeration.class.isAssignableFrom(valueClass)) {
                valueClass = Integer.class;
                enumeration = true;
            }
            int typeId = TypeUtil.getBuiltinTypeId(valueClass);
            if (typeId == -1) {
                LoggerFactory.getLogger(this.getClass()).warn("Not a built-in type: {}", valueClass);
            }
            if (value.getClass().isArray()) {
                int[] dimensions = ArrayUtil.getDimensions(value);
                if (dimensions.length == 1) {
                    this.buffer.writeByte(typeId | 0x80);
                    int length = Array.getLength(value);
                    this.buffer.writeIntLE(length);
                    int i = 0;
                    while (i < length) {
                        Object o = Array.get(value, i);
                        this.writeValue(o, typeId, structure, enumeration);
                        ++i;
                    }
                } else {
                    this.buffer.writeByte(typeId | 0xC0);
                    Object flattened = ArrayUtil.flatten(value);
                    int length = Array.getLength(flattened);
                    this.buffer.writeIntLE(length);
                    int i = 0;
                    while (i < length) {
                        Object o = Array.get(flattened, i);
                        this.writeValue(o, typeId, structure, enumeration);
                        ++i;
                    }
                    this.writeInt32(dimensions.length);
                    int[] nArray = dimensions;
                    int n = dimensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int dimension = nArray[n2];
                        this.writeInt32(dimension);
                        ++n2;
                    }
                }
            } else {
                this.buffer.writeByte(typeId);
                this.writeValue(value, typeId, structure, enumeration);
            }
        }
    }

    private void writeValue(Object value, int typeId, boolean structure, boolean enumeration) {
        if (structure) {
            UaStructure struct = (UaStructure)value;
            ExtensionObject extensionObject = ExtensionObject.encode(this.context, struct);
            this.writeBuiltinType(typeId, extensionObject);
        } else if (enumeration) {
            this.writeBuiltinType(typeId, ((UaEnumeration)value).getValue());
        } else {
            this.writeBuiltinType(typeId, value);
        }
    }

    private void writeBuiltinType(int typeId, Object value) throws UaSerializationException {
        switch (typeId) {
            case 1: {
                this.writeBoolean(null, (Boolean)value);
                break;
            }
            case 2: {
                this.writeSByte((Byte)value);
                break;
            }
            case 3: {
                this.writeByte((UByte)value);
                break;
            }
            case 4: {
                this.writeInt16((Short)value);
                break;
            }
            case 5: {
                this.writeUInt16((UShort)value);
                break;
            }
            case 6: {
                this.writeInt32((Integer)value);
                break;
            }
            case 7: {
                this.writeUInt32((UInteger)value);
                break;
            }
            case 8: {
                this.writeInt64((Long)value);
                break;
            }
            case 9: {
                this.writeUInt64((ULong)value);
                break;
            }
            case 10: {
                this.writeFloat((Float)value);
                break;
            }
            case 11: {
                this.writeDouble((Double)value);
                break;
            }
            case 12: {
                this.writeString((String)value);
                break;
            }
            case 13: {
                this.writeDateTime((DateTime)value);
                break;
            }
            case 14: {
                this.writeGuid((UUID)value);
                break;
            }
            case 15: {
                this.writeByteString((ByteString)value);
                break;
            }
            case 16: {
                this.writeXmlElement((XmlElement)value);
                break;
            }
            case 17: {
                this.writeNodeId((NodeId)value);
                break;
            }
            case 18: {
                this.writeExpandedNodeId((ExpandedNodeId)value);
                break;
            }
            case 19: {
                this.writeStatusCode((StatusCode)value);
                break;
            }
            case 20: {
                this.writeQualifiedName((QualifiedName)value);
                break;
            }
            case 21: {
                this.writeLocalizedText((LocalizedText)value);
                break;
            }
            case 22: {
                this.writeExtensionObject((ExtensionObject)value);
                break;
            }
            case 23: {
                this.writeDataValue((DataValue)value);
                break;
            }
            case 24: {
                this.writeVariant((Variant)value);
                break;
            }
            case 25: {
                this.writeDiagnosticInfo((DiagnosticInfo)value);
                break;
            }
            default: {
                throw new UaSerializationException(0x80060000L, "unknown builtin type: " + typeId);
            }
        }
    }

    private Class<?> getClass(@NotNull Object o) {
        if (o.getClass().isArray()) {
            return ArrayUtil.getType(o);
        }
        return o.getClass();
    }

    private void writeLengthPrefixedString(String value, Charset charset) throws UaSerializationException {
        byte[] bytes = value.getBytes(charset);
        int length = bytes.length;
        if (length > this.context.getEncodingLimits().getMaxMessageSize()) {
            throw new UaSerializationException(0x80080000L, String.format("string length exceeds max message size (length=%s, max=%s)", length, this.context.getEncodingLimits().getMaxMessageSize()));
        }
        this.writeInt32(length);
        this.buffer.writeBytes(bytes);
    }

    @Override
    public void writeBoolean(String field, Boolean value) throws UaSerializationException {
        this.writeBoolean(value);
    }

    @Override
    public void writeSByte(String field, Byte value) throws UaSerializationException {
        this.writeSByte(value);
    }

    @Override
    public void writeInt16(String field, Short value) throws UaSerializationException {
        this.writeInt16(value);
    }

    @Override
    public void writeInt32(String field, Integer value) throws UaSerializationException {
        this.writeInt32(value);
    }

    @Override
    public void writeInt64(String field, Long value) throws UaSerializationException {
        this.writeInt64(value);
    }

    @Override
    public void writeByte(String field, UByte value) throws UaSerializationException {
        this.writeByte(value);
    }

    @Override
    public void writeUInt16(String field, UShort value) throws UaSerializationException {
        this.writeUInt16(value);
    }

    @Override
    public void writeUInt32(String field, UInteger value) throws UaSerializationException {
        this.writeUInt32(value);
    }

    @Override
    public void writeUInt64(String field, ULong value) throws UaSerializationException {
        this.writeUInt64(value);
    }

    @Override
    public void writeFloat(String field, Float value) throws UaSerializationException {
        this.writeFloat(value);
    }

    @Override
    public void writeDouble(String field, Double value) throws UaSerializationException {
        this.writeDouble(value);
    }

    @Override
    public void writeString(String field, String value) throws UaSerializationException {
        this.writeString(value);
    }

    @Override
    public void writeDateTime(String field, DateTime value) throws UaSerializationException {
        this.writeDateTime(value);
    }

    @Override
    public void writeGuid(String field, UUID value) throws UaSerializationException {
        this.writeGuid(value);
    }

    @Override
    public void writeByteString(String field, ByteString value) throws UaSerializationException {
        this.writeByteString(value);
    }

    @Override
    public void writeXmlElement(String field, XmlElement value) throws UaSerializationException {
        this.writeXmlElement(value);
    }

    @Override
    public void writeNodeId(String field, NodeId value) throws UaSerializationException {
        this.writeNodeId(value);
    }

    @Override
    public void writeExpandedNodeId(String field, ExpandedNodeId value) throws UaSerializationException {
        this.writeExpandedNodeId(value);
    }

    @Override
    public void writeStatusCode(String field, StatusCode value) throws UaSerializationException {
        this.writeStatusCode(value);
    }

    @Override
    public void writeQualifiedName(String field, QualifiedName value) throws UaSerializationException {
        this.writeQualifiedName(value);
    }

    @Override
    public void writeLocalizedText(String field, LocalizedText value) throws UaSerializationException {
        this.writeLocalizedText(value);
    }

    @Override
    public void writeExtensionObject(String field, ExtensionObject value) throws UaSerializationException {
        this.writeExtensionObject(value);
    }

    @Override
    public void writeDataValue(String field, DataValue value) throws UaSerializationException {
        this.writeDataValue(value);
    }

    @Override
    public void writeVariant(String field, Variant value) throws UaSerializationException {
        this.writeVariant(value);
    }

    @Override
    public void writeDiagnosticInfo(String field, DiagnosticInfo value) throws UaSerializationException {
        this.writeDiagnosticInfo(value);
    }

    @Override
    public void writeMessage(String field, UaMessage message) throws UaSerializationException {
        ExpandedNodeId xBinaryEncodingId = message.getBinaryEncodingId();
        NodeId encodingId = xBinaryEncodingId.toNodeId(this.context.getNamespaceTable()).orElseThrow(() -> new UaSerializationException(0x80060000L, "namespace not registered: " + xBinaryEncodingId.getNamespaceUri()));
        OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)this.context.getDataTypeManager().getCodec(encodingId);
        if (binaryCodec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + encodingId);
        }
        this.writeNodeId(encodingId);
        binaryCodec.encode(this.context, this, message);
    }

    @Override
    public void writeEnum(String field, UaEnumeration value) {
        this.writeInt32(value.getValue());
    }

    @Override
    public void writeStruct(String field, Object value, NodeId dataTypeId) throws UaSerializationException {
        try {
            OpcUaBinaryDataTypeCodec codec = (OpcUaBinaryDataTypeCodec)this.context.getDataTypeManager().getCodec(OpcUaDefaultBinaryEncoding.ENCODING_NAME, dataTypeId);
            if (codec == null) {
                throw new UaSerializationException(0x80060000L, "no codec registered: " + dataTypeId);
            }
            codec.encode(this.context, this, value);
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80060000L, (Throwable)e);
        }
    }

    @Override
    public void writeStruct(String field, Object value, ExpandedNodeId dataTypeId) throws UaSerializationException {
        NodeId localDateTypeId = dataTypeId.toNodeId(this.context.getNamespaceTable()).orElseThrow(() -> new UaSerializationException(0x80060000L, "no codec registered: " + dataTypeId));
        this.writeStruct(field, value, localDateTypeId);
    }

    @Override
    public void writeStruct(String field, Object value, DataTypeCodec codec) throws UaSerializationException {
        if (!(codec instanceof OpcUaBinaryDataTypeCodec)) {
            throw new UaSerializationException(0x80060000L, (Throwable)new IllegalArgumentException("codec: " + codec));
        }
        OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)codec;
        binaryCodec.encode(this.context, this, value);
    }

    @Override
    public void writeBooleanArray(String field, Boolean[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeBoolean);
    }

    @Override
    public void writeSByteArray(String field, Byte[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeSByte);
    }

    @Override
    public void writeInt16Array(String field, Short[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeInt16);
    }

    @Override
    public void writeInt32Array(String field, Integer[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeInt32);
    }

    @Override
    public void writeInt64Array(String field, Long[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeInt64);
    }

    @Override
    public void writeByteArray(String field, UByte[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeByte);
    }

    @Override
    public void writeUInt16Array(String field, UShort[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeUInt16);
    }

    @Override
    public void writeUInt32Array(String field, UInteger[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeUInt32);
    }

    @Override
    public void writeUInt64Array(String field, ULong[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeUInt64);
    }

    @Override
    public void writeFloatArray(String field, Float[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeFloat);
    }

    @Override
    public void writeDoubleArray(String field, Double[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeDouble);
    }

    @Override
    public void writeStringArray(String field, String[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeString);
    }

    @Override
    public void writeDateTimeArray(String field, DateTime[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeDateTime);
    }

    @Override
    public void writeGuidArray(String field, UUID[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeGuid);
    }

    @Override
    public void writeByteStringArray(String field, ByteString[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeByteString);
    }

    @Override
    public void writeXmlElementArray(String field, XmlElement[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeXmlElement);
    }

    @Override
    public void writeNodeIdArray(String field, NodeId[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeNodeId);
    }

    @Override
    public void writeExpandedNodeIdArray(String field, ExpandedNodeId[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeExpandedNodeId);
    }

    @Override
    public void writeStatusCodeArray(String field, StatusCode[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeStatusCode);
    }

    @Override
    public void writeQualifiedNameArray(String field, QualifiedName[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeQualifiedName);
    }

    @Override
    public void writeLocalizedTextArray(String field, LocalizedText[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeLocalizedText);
    }

    @Override
    public void writeExtensionObjectArray(String field, ExtensionObject[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeExtensionObject);
    }

    @Override
    public void writeDataValueArray(String field, DataValue[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeDataValue);
    }

    @Override
    public void writeVariantArray(String field, Variant[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeVariant);
    }

    @Override
    public void writeDiagnosticInfoArray(String field, DiagnosticInfo[] value) throws UaSerializationException {
        this.writeArray(field, value, this::writeDiagnosticInfo);
    }

    @Override
    public void writeEnumArray(String field, UaEnumeration[] value) throws UaSerializationException {
        this.writeArray(value, v -> this.writeEnum(field, (UaEnumeration)v));
    }

    @Override
    public void writeStructArray(String field, Object[] values, NodeId dataTypeId) throws UaSerializationException {
        this.writeArray(values, o -> this.writeStruct(field, o, dataTypeId));
    }

    @Override
    public void writeStructArray(String field, Object[] value, ExpandedNodeId dataTypeId) throws UaSerializationException {
        NodeId localDateTypeId = dataTypeId.toNodeId(this.context.getNamespaceTable()).orElseThrow(() -> new UaSerializationException(0x80060000L, "no codec registered: " + dataTypeId));
        this.writeStructArray(field, value, localDateTypeId);
    }

    @Override
    public <T> void writeArray(String field, T[] values, BiConsumer<String, T> encoder) throws UaSerializationException {
        if (values == null) {
            this.buffer.writeIntLE(-1);
        } else {
            if (values.length > this.context.getEncodingLimits().getMaxMessageSize()) {
                throw new UaSerializationException(0x80080000L, "array length exceeds max message size");
            }
            this.writeInt32(values.length);
            T[] TArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                encoder.accept(field, (String)t);
                ++n2;
            }
        }
    }
}

