/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeInitializer;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.jetbrains.annotations.Nullable;

public class DefaultDataTypeManager
implements DataTypeManager {
    private final ConcurrentMap<String, DataTypeDictionary<?>> dictionaries = Maps.newConcurrentMap();
    private final ConcurrentMap<NodeId, DataTypeCodec> codecsByEncodingId = Maps.newConcurrentMap();
    private final Table<QualifiedName, NodeId, DataTypeCodec> codecsByDataTypeId = Tables.synchronizedTable((Table)HashBasedTable.create());

    @Override
    public void registerCodec(NodeId encodingId, DataTypeCodec codec) {
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public void registerCodec(QualifiedName encodingName, NodeId dataTypeId, DataTypeCodec codec) {
        this.codecsByDataTypeId.put((Object)encodingName, (Object)dataTypeId, (Object)codec);
    }

    @Override
    public void registerTypeDictionary(DataTypeDictionary<?> dataTypeDictionary) {
        this.dictionaries.put(dataTypeDictionary.getNamespaceUri(), dataTypeDictionary);
        this.codecsByEncodingId.putAll(dataTypeDictionary.getCodecsByEncodingId());
        dataTypeDictionary.getCodecsByDataTypeId().forEach((dataTypeId, codec) -> {
            Object object = this.codecsByDataTypeId.put((Object)dataTypeDictionary.getEncodingName(), dataTypeId, (Object)((DataTypeCodec)codec));
        });
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(NodeId encodingId) {
        return (DataTypeCodec)this.codecsByEncodingId.get(encodingId);
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(QualifiedName encodingName, NodeId dataTypeId) {
        return (DataTypeCodec)this.codecsByDataTypeId.get((Object)encodingName, (Object)dataTypeId);
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(String namespaceUri, String description) {
        DataTypeDictionary dataTypeDictionary = (DataTypeDictionary)this.dictionaries.get(namespaceUri);
        return dataTypeDictionary != null ? (DataTypeCodec)dataTypeDictionary.getCodec(description) : null;
    }

    @Override
    @Nullable
    public DataTypeDictionary<?> getDataTypeDictionary(String namespaceUri) {
        return (DataTypeDictionary)this.dictionaries.get(namespaceUri);
    }

    public static DataTypeManager createAndInitialize(NamespaceTable namespaceTable) {
        DefaultDataTypeManager dataTypeManager = new DefaultDataTypeManager();
        DataTypeInitializer.initialize(namespaceTable, dataTypeManager);
        return dataTypeManager;
    }
}

