/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class OpcUaDefaultBinaryEncoding
implements DataTypeEncoding {
    public static final QualifiedName ENCODING_NAME = new QualifiedName(0, "Default Binary");

    public static OpcUaDefaultBinaryEncoding getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private OpcUaDefaultBinaryEncoding() {
    }

    @Override
    public QualifiedName getName() {
        return ENCODING_NAME;
    }

    @Override
    public ExtensionObject.BodyType getBodyType() {
        return ExtensionObject.BodyType.ByteString;
    }

    @Override
    public Object encode(SerializationContext context, Object decodedBody, NodeId encodingId) {
        ByteString byteString;
        OpcUaBinaryDataTypeCodec codec = (OpcUaBinaryDataTypeCodec)context.getDataTypeManager().getCodec(encodingId);
        if (codec == null) {
            throw new UaSerializationException(0x80060000L, "no codec registered for encodingId=" + encodingId);
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            OpcUaBinaryStreamEncoder writer = new OpcUaBinaryStreamEncoder(context).setBuffer(buffer);
            codec.encode(context, writer, decodedBody);
            byte[] bs = new byte[buffer.readableBytes()];
            buffer.readBytes(bs);
            byteString = ByteString.of(bs);
        }
        catch (Throwable throwable) {
            try {
                buffer.release();
                throw throwable;
            }
            catch (ClassCastException e) {
                throw new UaSerializationException(0x80060000L, (Throwable)e);
            }
        }
        buffer.release();
        return byteString;
    }

    @Override
    public Object decode(SerializationContext context, Object encodedBody, NodeId encodingId) {
        try {
            OpcUaBinaryDataTypeCodec codec = (OpcUaBinaryDataTypeCodec)context.getDataTypeManager().getCodec(encodingId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered for encodingId=" + encodingId);
            }
            ByteString binaryBody = (ByteString)encodedBody;
            byte[] bs = binaryBody.bytesOrEmpty();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bs);
            OpcUaBinaryStreamDecoder reader = new OpcUaBinaryStreamDecoder(context).setBuffer(buffer);
            return codec.decode(context, reader);
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private static class InstanceHolder {
        private static final OpcUaDefaultBinaryEncoding INSTANCE = new OpcUaDefaultBinaryEncoding();

        private InstanceHolder() {
        }
    }
}

