/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Date;

public final class DateTime {
    public static volatile boolean USE_NANOS = false;
    public static final DateTime MIN_VALUE;
    public static final DateTime NULL_VALUE;
    private static final long EPOCH_DELTA = 116444736000000000L;
    private final long utcTime;

    static {
        NULL_VALUE = MIN_VALUE = new DateTime(0L);
    }

    public DateTime() {
        this(DateTime.javaToUtc(System.currentTimeMillis()));
    }

    public DateTime(long utcTime) {
        this.utcTime = utcTime;
    }

    public DateTime(Date date) {
        this(DateTime.javaToUtc(date.getTime()));
    }

    public DateTime(Instant instant) {
        this(DateTime.javaToUtc(instant.toEpochMilli()) + (long)(instant.getNano() % 1000000 / 100));
    }

    public long getUtcTime() {
        return this.utcTime;
    }

    public long getJavaTime() {
        return DateTime.utcToJava(this.utcTime);
    }

    public Date getJavaDate() {
        return new Date(DateTime.utcToJava(this.utcTime));
    }

    public Instant getJavaInstant() {
        return Instant.ofEpochSecond(DateTime.utcToJava(this.utcTime) / 1000L, this.utcTime % 10000000L * 100L);
    }

    public boolean isNull() {
        return this.utcTime == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        return this.utcTime == dateTime.utcTime;
    }

    public int hashCode() {
        return (int)(this.utcTime ^ this.utcTime >>> 32);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("utcTime", this.utcTime).add("javaDate", (Object)this.getJavaDate()).toString();
    }

    public static DateTime now() {
        if (USE_NANOS) {
            return DateTime.nowNanos();
        }
        return DateTime.nowMillis();
    }

    public static DateTime nowMillis() {
        return new DateTime();
    }

    public static DateTime nowNanos() {
        return new DateTime(Instant.now());
    }

    private static long javaToUtc(long javaTime) {
        return javaTime * 10000L + 116444736000000000L;
    }

    private static long utcToJava(long utcTime) {
        return (utcTime - 116444736000000000L) / 10000L;
    }
}

