/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpandedNodeId {
    public static final ExpandedNodeId NULL_VALUE = new ExpandedNodeId(UShort.MIN, null, UInteger.MIN, UInteger.MIN);
    private final UShort namespaceIndex;
    private final Object identifier;
    private final String namespaceUri;
    private final UInteger serverIndex;

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, UInteger identifier) {
        this(namespaceIndex, namespaceUri, identifier, UInteger.MIN);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, UInteger identifier, UInteger serverIndex) {
        this(namespaceIndex, namespaceUri, (Object)identifier, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, String identifier) {
        this(namespaceIndex, namespaceUri, identifier, UInteger.MIN);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, String identifier, UInteger serverIndex) {
        this(namespaceIndex, namespaceUri, (Object)identifier, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, ByteString identifier) {
        this(namespaceIndex, namespaceUri, identifier, UInteger.MIN);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, ByteString identifier, UInteger serverIndex) {
        this(namespaceIndex, namespaceUri, (Object)identifier, serverIndex);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, UUID identifier) {
        this(namespaceIndex, namespaceUri, identifier, UInteger.MIN);
    }

    public ExpandedNodeId(UShort namespaceIndex, String namespaceUri, UUID identifier, UInteger serverIndex) {
        this(namespaceIndex, namespaceUri, (Object)identifier, serverIndex);
    }

    public ExpandedNodeId(@NotNull UShort namespaceIndex, @Nullable String namespaceUri, @Nullable Object identifier, @NotNull UInteger serverIndex) {
        Preconditions.checkNotNull((Object)namespaceIndex);
        Preconditions.checkNotNull((Object)serverIndex);
        this.namespaceIndex = namespaceIndex;
        this.namespaceUri = namespaceUri;
        this.identifier = identifier;
        this.serverIndex = serverIndex;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public IdType getType() {
        if (this.identifier instanceof UInteger) {
            return IdType.Numeric;
        }
        if (this.identifier instanceof String) {
            return IdType.String;
        }
        if (this.identifier instanceof UUID) {
            return IdType.Guid;
        }
        return IdType.Opaque;
    }

    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    @Nullable
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public UInteger getServerIndex() {
        return this.serverIndex;
    }

    public boolean isAbsolute() {
        return this.namespaceUri != null;
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public boolean isLocal() {
        return this.serverIndex.longValue() == 0L;
    }

    public boolean isNull() {
        if (this.namespaceIndex.intValue() > 0) {
            return false;
        }
        switch (this.getType()) {
            case Numeric: {
                UInteger id = (UInteger)this.identifier;
                return id.intValue() == 0;
            }
            case String: {
                String id = (String)this.identifier;
                return Strings.isNullOrEmpty((String)id);
            }
            case Guid: {
                UUID id = (UUID)this.identifier;
                return id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L;
            }
            case Opaque: {
                ByteString id = (ByteString)this.identifier;
                return id == null || id.isNullOrEmpty();
            }
        }
        return true;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public Optional<ExpandedNodeId> absolute(NamespaceTable namespaceTable) {
        if (this.isAbsolute()) {
            return Optional.of(this);
        }
        String namespaceUri = namespaceTable.getUri(this.namespaceIndex);
        if (namespaceUri != null) {
            ExpandedNodeId xni = new ExpandedNodeId(UShort.MIN, namespaceUri, this.identifier, this.serverIndex);
            return Optional.of(xni);
        }
        return Optional.empty();
    }

    public Optional<ExpandedNodeId> relative(NamespaceTable namespaceTable) {
        if (this.isRelative()) {
            return Optional.of(this);
        }
        UShort namespaceIndex = namespaceTable.getIndex(this.namespaceUri);
        if (namespaceIndex != null) {
            ExpandedNodeId xni = new ExpandedNodeId(namespaceIndex, null, this.identifier, this.serverIndex);
            return Optional.of(xni);
        }
        return Optional.empty();
    }

    public ExpandedNodeId reindex(NamespaceTable namespaceTable, String namespaceUri) {
        if (this.isAbsolute()) {
            return this;
        }
        UShort newNamespaceIndex = namespaceTable.getIndex(namespaceUri);
        if (newNamespaceIndex != null && !Objects.equals(this.namespaceIndex, newNamespaceIndex)) {
            return new ExpandedNodeId(newNamespaceIndex, null, this.identifier, this.serverIndex);
        }
        return this;
    }

    @Deprecated
    public Optional<NodeId> local(NamespaceTable namespaceTable) {
        return this.toNodeId(namespaceTable);
    }

    @Deprecated
    public NodeId localOrThrow(NamespaceTable namespaceTable) throws Exception {
        return this.toNodeIdOrThrow(namespaceTable);
    }

    public Optional<NodeId> toNodeId(NamespaceTable namespaceTable) {
        if (this.isLocal()) {
            if (this.namespaceUri == null || this.namespaceUri.isEmpty()) {
                NodeId nodeId = new NodeId(this.namespaceIndex, this.identifier);
                return Optional.of(nodeId);
            }
            UShort namespaceIndex = namespaceTable.getIndex(this.namespaceUri);
            if (namespaceIndex == null) {
                return Optional.empty();
            }
            NodeId nodeId = new NodeId(namespaceIndex, this.identifier);
            return Optional.of(nodeId);
        }
        return Optional.empty();
    }

    public NodeId toNodeIdOrThrow(NamespaceTable namespaceTable) throws Exception {
        if (this.isLocal()) {
            return this.toNodeId(namespaceTable).orElseThrow(() -> new Exception("namespace not registered: " + this.namespaceUri));
        }
        throw new Exception("not a local node (serverIndex = " + this.serverIndex + ")");
    }

    @Deprecated
    public boolean equals(NodeId nodeId) {
        return this.equalTo(nodeId);
    }

    @Deprecated
    public boolean equals(NodeId nodeId, NamespaceTable namespaceTable) {
        return this.equalTo(nodeId, namespaceTable);
    }

    public boolean equalTo(NodeId nodeId) {
        return nodeId.equalTo(this);
    }

    public boolean equalTo(NodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.equalTo(this, namespaceTable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandedNodeId that = (ExpandedNodeId)o;
        return Objects.equals(this.namespaceIndex, that.namespaceIndex) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.namespaceUri, that.namespaceUri) && this.serverIndex.equals(that.serverIndex);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceIndex, this.identifier, this.namespaceUri, this.serverIndex);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (this.namespaceUri != null && this.namespaceUri.length() > 0) {
            helper.add("ns", (Object)this.namespaceUri);
        } else {
            helper.add("ns", (Object)this.getNamespaceIndex());
        }
        helper.add("id", this.getIdentifier());
        helper.add("serverIndex", (Object)this.getServerIndex());
        return helper.toString();
    }

    public String toParseableString() {
        StringBuilder sb = new StringBuilder();
        if (this.serverIndex.intValue() != 0) {
            sb.append("svr=").append(this.serverIndex).append(";");
        }
        if (this.namespaceUri != null) {
            sb.append("nsu=").append(this.namespaceUri).append(";");
        } else {
            int namespaceIndex = this.getNamespaceIndex().intValue();
            sb.append("ns=").append(namespaceIndex).append(";");
        }
        switch (this.getType()) {
            case Numeric: {
                sb.append("i=").append(this.getIdentifier());
                break;
            }
            case String: {
                sb.append("s=").append(this.getIdentifier());
                break;
            }
            case Guid: {
                sb.append("g=").append(this.getIdentifier());
                break;
            }
            case Opaque: {
                ByteString bs = (ByteString)this.getIdentifier();
                if (bs.isNull()) {
                    sb.append("b=");
                    break;
                }
                sb.append("b=").append(DatatypeConverter.printBase64Binary((byte[])bs.bytes()));
                break;
            }
            default: {
                throw new IllegalStateException("IdType " + this.getType());
            }
        }
        return sb.toString();
    }

    public static ExpandedNodeId parse(String s) {
        try {
            Object identifier;
            UInteger serverIndex = UInteger.MIN;
            if (s.startsWith("svr=")) {
                int endIndex = s.indexOf(";");
                serverIndex = Unsigned.uint(Integer.parseInt(s.substring(4, endIndex)));
                s = s.substring(endIndex + 1);
            }
            UShort namespaceIndex = UShort.MIN;
            String namespaceUri = null;
            if (s.startsWith("ns=")) {
                endIndex = s.indexOf(";");
                namespaceIndex = Unsigned.ushort(Integer.parseInt(s.substring(3, endIndex)));
                s = s.substring(endIndex + 1);
            } else if (s.startsWith("nsu=")) {
                endIndex = s.indexOf(";");
                namespaceUri = s.substring(4, endIndex);
                s = s.substring(endIndex + 1);
            }
            String type = s.substring(0, 2);
            String id = s.substring(2);
            switch (type) {
                case "i=": {
                    try {
                        identifier = Unsigned.uint(Long.parseLong(id));
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new UaRuntimeException(0x80330000L, (Throwable)e);
                    }
                }
                case "s=": {
                    identifier = id;
                    break;
                }
                case "g=": {
                    try {
                        identifier = UUID.fromString(id);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new UaRuntimeException(0x80330000L, (Throwable)e);
                    }
                }
                case "b=": {
                    try {
                        identifier = ByteString.of(DatatypeConverter.parseBase64Binary((String)id));
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new UaRuntimeException(0x80330000L, (Throwable)e);
                    }
                }
                default: {
                    throw new UaRuntimeException(0x80330000L);
                }
            }
            return new ExpandedNodeId(namespaceIndex, namespaceUri, identifier, serverIndex);
        }
        catch (Throwable t) {
            throw new UaRuntimeException(0x80330000L, t);
        }
    }

    @Nullable
    public static ExpandedNodeId parseOrNull(@NotNull String s) {
        try {
            return ExpandedNodeId.parse(s);
        }
        catch (UaRuntimeException uaRuntimeException) {
            return null;
        }
    }

    public static Optional<ExpandedNodeId> parseSafe(@NotNull String s) {
        return Optional.ofNullable(ExpandedNodeId.parseOrNull(s));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private UShort namespaceIndex = UShort.MIN;
        private String namespaceUri = null;
        private Object identifier = null;
        private UInteger serverIndex = UInteger.MIN;

        public Builder setNamespaceIndex(int namespaceIndex) {
            return this.setNamespaceIndex(Unsigned.ushort(namespaceIndex));
        }

        public Builder setNamespaceIndex(UShort namespaceIndex) {
            this.namespaceIndex = namespaceIndex;
            return this;
        }

        public Builder setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        public Builder setIdentifier(UInteger identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setIdentifier(ByteString identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setServerIndex(long serverIndex) {
            return this.setServerIndex(Unsigned.uint(serverIndex));
        }

        public Builder setServerIndex(UInteger serverIndex) {
            this.serverIndex = serverIndex;
            return this;
        }

        public ExpandedNodeId build() {
            return new ExpandedNodeId(this.namespaceIndex, this.namespaceUri, this.identifier, this.serverIndex);
        }
    }
}

