/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionObject {
    private final Lazy<Object> decoded = new Lazy();
    private final BodyType bodyType;
    private final Object body;
    private final NodeId encodingId;

    public ExtensionObject(@NotNull ByteString body, @NotNull NodeId encodingId) {
        this((Object)body, encodingId);
    }

    public ExtensionObject(@NotNull XmlElement body, @NotNull NodeId encodingId) {
        this((Object)body, encodingId);
    }

    private ExtensionObject(@NotNull Object body, @NotNull NodeId encodingId) {
        this.body = body;
        this.encodingId = encodingId;
        if (body instanceof ByteString) {
            this.bodyType = BodyType.ByteString;
        } else if (body instanceof XmlElement) {
            this.bodyType = BodyType.XmlElement;
        } else {
            throw new IllegalArgumentException("body: " + body);
        }
    }

    public Object getBody() {
        return this.body;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public NodeId getEncodingId() {
        return this.encodingId;
    }

    public boolean isNull() {
        switch (this.bodyType) {
            case ByteString: {
                return ((ByteString)this.body).isNull();
            }
            case XmlElement: {
                return ((XmlElement)this.body).isNull();
            }
        }
        throw new IllegalStateException("BodyType: " + (Object)((Object)this.bodyType));
    }

    public Object decode(SerializationContext context) throws UaSerializationException {
        switch (this.bodyType) {
            case ByteString: {
                return this.decode(context, OpcUaDefaultBinaryEncoding.getInstance());
            }
            case XmlElement: {
                return this.decode(context, OpcUaDefaultXmlEncoding.getInstance());
            }
        }
        throw new IllegalStateException("BodyType: " + (Object)((Object)this.bodyType));
    }

    public Object decode(SerializationContext context, DataTypeEncoding encoding) throws UaSerializationException {
        return this.decoded.getOrCompute(() -> encoding.decode(context, this.body, this.encodingId));
    }

    @Nullable
    public Object decodeOrNull(SerializationContext context) {
        try {
            return this.decode(context);
        }
        catch (UaSerializationException uaSerializationException) {
            return null;
        }
    }

    public ExtensionObject transcode(SerializationContext context, NodeId newEncodingId, DataTypeEncoding newEncoding) {
        if (this.encodingId.equals(newEncodingId)) {
            return this;
        }
        Object struct = this.decodeOrNull(context);
        if (struct != null) {
            Object encoded = newEncoding.encode(context, struct, newEncodingId);
            return new ExtensionObject(encoded, newEncodingId);
        }
        return this;
    }

    public static ExtensionObject encode(SerializationContext context, UaStructure struct) throws UaSerializationException {
        NodeId encodingId = struct.getBinaryEncodingId().toNodeId(context.getNamespaceTable()).orElseThrow(() -> new UaSerializationException(0x80060000L, "namespace not registered: " + struct.getBinaryEncodingId().getNamespaceUri()));
        return ExtensionObject.encodeDefaultBinary(context, struct, encodingId);
    }

    public static ExtensionObject[] encodeArray(SerializationContext context, UaStructure[] structArray) throws UaSerializationException {
        ExtensionObject[] xos = new ExtensionObject[structArray.length];
        int i = 0;
        while (i < xos.length) {
            xos[i] = ExtensionObject.encode(context, structArray[i]);
            ++i;
        }
        return xos;
    }

    public static ExtensionObject encodeDefaultBinary(SerializationContext context, Object object, NodeId encodingId) throws UaSerializationException {
        return ExtensionObject.encode(context, object, encodingId, (DataTypeEncoding)OpcUaDefaultBinaryEncoding.getInstance());
    }

    public static ExtensionObject encodeDefaultXml(SerializationContext context, Object object, NodeId encodingId) throws UaSerializationException {
        return ExtensionObject.encode(context, object, encodingId, (DataTypeEncoding)OpcUaDefaultXmlEncoding.getInstance());
    }

    public static ExtensionObject encode(SerializationContext context, Object object, ExpandedNodeId xEncodingId, DataTypeEncoding encoding) throws UaSerializationException {
        NodeId encodingId = xEncodingId.toNodeId(context.getNamespaceTable()).orElseThrow(() -> new UaSerializationException(0x80060000L, "namespace not registered: " + xEncodingId.getNamespaceUri()));
        Object body = encoding.encode(context, object, encodingId);
        return new ExtensionObject(body, encodingId);
    }

    public static ExtensionObject encode(SerializationContext context, Object object, NodeId encodingId, DataTypeEncoding encoding) throws UaSerializationException {
        Object body = encoding.encode(context, object, encodingId);
        return new ExtensionObject(body, encodingId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return Objects.equal((Object)this.body, (Object)that.body) && Objects.equal((Object)this.encodingId, (Object)that.encodingId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.body, this.encodingId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("encoded", this.body).add("encodingId", (Object)this.encodingId).toString();
    }

    public static enum BodyType {
        ByteString,
        XmlElement;

    }
}

